/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.ExceptionHandlingService;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.core.service.StatementLockFactory;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.named.IndexMultiKey;
import com.espertech.esper.epl.named.NamedWindowConsumerDispatchUnit;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowLifecycleEvent;
import com.espertech.esper.epl.named.NamedWindowLifecycleObserver;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.util.ManagedReadWriteLock;
import com.espertech.esper.util.MetricUtil;
import com.espertech.esper.view.ViewProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NamedWindowServiceImpl
implements NamedWindowService {
    private final Map<String, NamedWindowProcessor> processors;
    private final Map<String, NamedWindowLockPair> windowStatementLocks;
    private final StatementLockFactory statementLockFactory;
    private final VariableService variableService;
    private final Set<NamedWindowLifecycleObserver> observers;
    private final ExceptionHandlingService exceptionHandlingService;
    private final boolean isPrioritized;
    private final ManagedReadWriteLock eventProcessingRWLock;
    private final boolean enableQueryPlanLog;
    private final MetricReportingService metricReportingService;
    private ThreadLocal<List<NamedWindowConsumerDispatchUnit>> threadLocal = new ThreadLocal<List<NamedWindowConsumerDispatchUnit>>(){

        @Override
        protected synchronized List<NamedWindowConsumerDispatchUnit> initialValue() {
            return new ArrayList<NamedWindowConsumerDispatchUnit>();
        }
    };
    private ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>> dispatchesPerStmtTL = new ThreadLocal<Map<EPStatementAgentInstanceHandle, Object>>(){

        @Override
        protected synchronized Map<EPStatementAgentInstanceHandle, Object> initialValue() {
            return new HashMap<EPStatementAgentInstanceHandle, Object>();
        }
    };

    public NamedWindowServiceImpl(StatementLockFactory statementLockFactory, VariableService variableService, boolean isPrioritized, ManagedReadWriteLock eventProcessingRWLock, ExceptionHandlingService exceptionHandlingService, boolean enableQueryPlanLog, MetricReportingService metricReportingService) {
        this.processors = new HashMap<String, NamedWindowProcessor>();
        this.windowStatementLocks = new HashMap<String, NamedWindowLockPair>();
        this.statementLockFactory = statementLockFactory;
        this.variableService = variableService;
        this.observers = new HashSet<NamedWindowLifecycleObserver>();
        this.isPrioritized = isPrioritized;
        this.eventProcessingRWLock = eventProcessingRWLock;
        this.exceptionHandlingService = exceptionHandlingService;
        this.enableQueryPlanLog = enableQueryPlanLog;
        this.metricReportingService = metricReportingService;
    }

    @Override
    public void destroy() {
        this.processors.clear();
        this.threadLocal.remove();
        this.dispatchesPerStmtTL.remove();
    }

    @Override
    public String[] getNamedWindows() {
        Set<String> names = this.processors.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public StatementAgentInstanceLock getNamedWindowLock(String windowName) {
        NamedWindowLockPair pair = this.windowStatementLocks.get(windowName);
        if (pair == null) {
            return null;
        }
        return pair.getLock();
    }

    @Override
    public void addNamedWindowLock(String windowName, StatementAgentInstanceLock statementResourceLock, String statementName) {
        this.windowStatementLocks.put(windowName, new NamedWindowLockPair(statementName, statementResourceLock));
    }

    @Override
    public void removeNamedWindowLock(String statementName) {
        for (Map.Entry<String, NamedWindowLockPair> entry : this.windowStatementLocks.entrySet()) {
            if (!entry.getValue().getStatementName().equals(statementName)) continue;
            this.windowStatementLocks.remove(entry.getKey());
            return;
        }
    }

    @Override
    public boolean isNamedWindow(String name) {
        return this.processors.containsKey(name);
    }

    @Override
    public NamedWindowProcessor getProcessor(String name) {
        return this.processors.get(name);
    }

    @Override
    public IndexMultiKey[] getNamedWindowIndexes(String windowName) {
        NamedWindowProcessor processor = this.processors.get(windowName);
        if (processor == null) {
            return null;
        }
        return processor.getProcessorInstance(null).getIndexDescriptors();
    }

    @Override
    public NamedWindowProcessor addProcessor(String name, String contextName, boolean singleInstanceContext, EventType eventType, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, boolean isEnableSubqueryIndexShare, boolean isBatchingDataWindow, boolean isVirtualDataWindow, StatementMetricHandle statementMetricHandle) throws ViewProcessingException {
        if (this.processors.containsKey(name)) {
            throw new ViewProcessingException("A named window by name '" + name + "' has already been created");
        }
        NamedWindowProcessor processor = new NamedWindowProcessor(name, this, contextName, singleInstanceContext, eventType, statementResultService, revisionProcessor, eplExpression, statementName, isPrioritized, isEnableSubqueryIndexShare, this.enableQueryPlanLog, this.metricReportingService, isBatchingDataWindow, isVirtualDataWindow, statementMetricHandle);
        this.processors.put(name, processor);
        if (!this.observers.isEmpty()) {
            NamedWindowLifecycleEvent event = new NamedWindowLifecycleEvent(name, processor, NamedWindowLifecycleEvent.LifecycleEventType.CREATE, new Object[0]);
            for (NamedWindowLifecycleObserver observer : this.observers) {
                observer.observe(event);
            }
        }
        return processor;
    }

    @Override
    public void removeProcessor(String name) {
        NamedWindowProcessor processor = this.processors.get(name);
        if (processor != null) {
            processor.destroy();
            this.processors.remove(name);
            if (!this.observers.isEmpty()) {
                NamedWindowLifecycleEvent event = new NamedWindowLifecycleEvent(name, processor, NamedWindowLifecycleEvent.LifecycleEventType.DESTROY, new Object[0]);
                for (NamedWindowLifecycleObserver observer : this.observers) {
                    observer.observe(event);
                }
            }
        }
    }

    @Override
    public void addDispatch(NamedWindowDeltaData delta, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumers) {
        if (!consumers.isEmpty()) {
            NamedWindowConsumerDispatchUnit unit = new NamedWindowConsumerDispatchUnit(delta, consumers);
            this.threadLocal.get().add(unit);
        }
    }

    @Override
    public boolean dispatch(ExprEvaluatorContext exprEvaluatorContext) {
        List<NamedWindowConsumerDispatchUnit> dispatches = this.threadLocal.get();
        if (dispatches.isEmpty()) {
            return false;
        }
        while (!dispatches.isEmpty()) {
            this.eventProcessingRWLock.acquireReadLock();
            try {
                NamedWindowConsumerDispatchUnit[] units = dispatches.toArray(new NamedWindowConsumerDispatchUnit[dispatches.size()]);
                dispatches.clear();
                this.processDispatches(exprEvaluatorContext, units);
            }
            catch (RuntimeException ex) {
                throw new EPException(ex);
            }
            finally {
                this.eventProcessingRWLock.releaseReadLock();
            }
        }
        return true;
    }

    private void processDispatches(ExprEvaluatorContext exprEvaluatorContext, NamedWindowConsumerDispatchUnit[] dispatches) {
        LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer;
        EventBean[] oldData;
        NamedWindowConsumerDispatchUnit unit;
        Object perStmtObj;
        if (dispatches.length == 1) {
            NamedWindowConsumerDispatchUnit unit2 = dispatches[0];
            EventBean[] newData = unit2.getDeltaData().getNewData();
            EventBean[] oldData2 = unit2.getDeltaData().getOldData();
            if (MetricReportingPath.isMetricsEnabled) {
                for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : unit2.getDispatchTo().entrySet()) {
                    EPStatementAgentInstanceHandle handle = entry.getKey();
                    if (handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                        long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                        long wallTimeBefore = MetricUtil.getWall();
                        this.processHandle(handle, entry.getValue(), newData, oldData2, exprEvaluatorContext);
                        long wallTimeAfter = MetricUtil.getWall();
                        long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                        long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                        long deltaWall = wallTimeAfter - wallTimeBefore;
                        this.metricReportingService.accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                    } else {
                        this.processHandle(handle, entry.getValue(), newData, oldData2, exprEvaluatorContext);
                    }
                    if (!this.isPrioritized || !handle.isPreemptive()) continue;
                    break;
                }
            } else {
                for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : unit2.getDispatchTo().entrySet()) {
                    EPStatementAgentInstanceHandle handle = entry.getKey();
                    this.processHandle(handle, entry.getValue(), newData, oldData2, exprEvaluatorContext);
                    if (!this.isPrioritized || !handle.isPreemptive()) continue;
                    break;
                }
            }
            return;
        }
        Map<EPStatementAgentInstanceHandle, Object> dispatchesPerStmt = this.dispatchesPerStmtTL.get();
        for (NamedWindowConsumerDispatchUnit unit3 : dispatches) {
            for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : unit3.getDispatchTo().entrySet()) {
                EPStatementAgentInstanceHandle handle = entry.getKey();
                Object perStmtObj2 = dispatchesPerStmt.get(handle);
                if (perStmtObj2 == null) {
                    dispatchesPerStmt.put(handle, unit3);
                    continue;
                }
                if (perStmtObj2 instanceof List) {
                    List list = (List)perStmtObj2;
                    list.add(unit3);
                    continue;
                }
                NamedWindowConsumerDispatchUnit unitObj = (NamedWindowConsumerDispatchUnit)perStmtObj2;
                ArrayList<NamedWindowConsumerDispatchUnit> list = new ArrayList<NamedWindowConsumerDispatchUnit>();
                list.add(unitObj);
                list.add(unit3);
                dispatchesPerStmt.put(handle, list);
            }
        }
        if (MetricReportingPath.isMetricsEnabled) {
            for (Map.Entry<EPStatementAgentInstanceHandle, Object> entry : dispatchesPerStmt.entrySet()) {
                EPStatementAgentInstanceHandle handle = entry.getKey();
                perStmtObj = entry.getValue();
                if (perStmtObj instanceof NamedWindowConsumerDispatchUnit) {
                    unit = (NamedWindowConsumerDispatchUnit)perStmtObj;
                    EventBean[] newData = unit.getDeltaData().getNewData();
                    oldData = unit.getDeltaData().getOldData();
                    if (handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                        long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                        long wallTimeBefore = MetricUtil.getWall();
                        this.processHandle(handle, unit.getDispatchTo().get(handle), newData, oldData, exprEvaluatorContext);
                        long wallTimeAfter = MetricUtil.getWall();
                        long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                        long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                        long deltaWall = wallTimeAfter - wallTimeBefore;
                        this.metricReportingService.accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                    } else {
                        Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entries = unit.getDispatchTo();
                        List<NamedWindowConsumerView> items = entries.get(handle);
                        if (items != null) {
                            this.processHandle(handle, items, newData, oldData, exprEvaluatorContext);
                        }
                    }
                    if (!this.isPrioritized || !handle.isPreemptive()) continue;
                } else {
                    deltaPerConsumer = this.getDeltaPerConsumer(perStmtObj, handle);
                    if (handle.getStatementHandle().getMetricsHandle().isEnabled()) {
                        long cpuTimeBefore = MetricUtil.getCPUCurrentThread();
                        long wallTimeBefore = MetricUtil.getWall();
                        this.processHandleMultiple(handle, deltaPerConsumer, exprEvaluatorContext);
                        long wallTimeAfter = MetricUtil.getWall();
                        long cpuTimeAfter = MetricUtil.getCPUCurrentThread();
                        long deltaCPU = cpuTimeAfter - cpuTimeBefore;
                        long deltaWall = wallTimeAfter - wallTimeBefore;
                        this.metricReportingService.accountTime(handle.getStatementHandle().getMetricsHandle(), deltaCPU, deltaWall, 1);
                    } else {
                        this.processHandleMultiple(handle, deltaPerConsumer, exprEvaluatorContext);
                    }
                    if (!this.isPrioritized || !handle.isPreemptive()) continue;
                }
                break;
            }
        } else {
            for (Map.Entry<EPStatementAgentInstanceHandle, Object> entry : dispatchesPerStmt.entrySet()) {
                EPStatementAgentInstanceHandle handle = entry.getKey();
                perStmtObj = entry.getValue();
                if (perStmtObj instanceof NamedWindowConsumerDispatchUnit) {
                    unit = (NamedWindowConsumerDispatchUnit)perStmtObj;
                    EventBean[] newData = unit.getDeltaData().getNewData();
                    oldData = unit.getDeltaData().getOldData();
                    this.processHandle(handle, unit.getDispatchTo().get(handle), newData, oldData, exprEvaluatorContext);
                    if (!this.isPrioritized || !handle.isPreemptive()) continue;
                } else {
                    deltaPerConsumer = this.getDeltaPerConsumer(perStmtObj, handle);
                    this.processHandleMultiple(handle, deltaPerConsumer, exprEvaluatorContext);
                    if (!this.isPrioritized || !handle.isPreemptive()) continue;
                }
                break;
            }
        }
        dispatchesPerStmt.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandleMultiple(EPStatementAgentInstanceHandle handle, Map<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer, ExprEvaluatorContext exprEvaluatorContext) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(this.statementLockFactory);
        try {
            if (handle.isHasVariables()) {
                this.variableService.setLocalVersion();
            }
            for (Map.Entry<NamedWindowConsumerView, NamedWindowDeltaData> entryDelta : deltaPerConsumer.entrySet()) {
                EventBean[] newData = entryDelta.getValue().getNewData();
                EventBean[] oldData = entryDelta.getValue().getOldData();
                entryDelta.getKey().update(newData, oldData);
            }
            handle.internalDispatch(exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            this.exceptionHandlingService.handleException(ex, handle);
        }
        finally {
            handle.getStatementAgentInstanceLock().releaseWriteLock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandle(EPStatementAgentInstanceHandle handle, List<NamedWindowConsumerView> value, EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        handle.getStatementAgentInstanceLock().acquireWriteLock(this.statementLockFactory);
        try {
            if (handle.isHasVariables()) {
                this.variableService.setLocalVersion();
            }
            for (NamedWindowConsumerView consumerView : value) {
                consumerView.update(newData, oldData);
            }
            handle.internalDispatch(exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            this.exceptionHandlingService.handleException(ex, handle);
        }
        finally {
            handle.getStatementAgentInstanceLock().releaseWriteLock(null);
        }
    }

    @Override
    public void addObserver(NamedWindowLifecycleObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(NamedWindowLifecycleObserver observer) {
        this.observers.remove(observer);
    }

    public LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> getDeltaPerConsumer(Object perStmtObj, EPStatementAgentInstanceHandle handle) {
        List list = (List)perStmtObj;
        LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer = new LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData>();
        for (NamedWindowConsumerDispatchUnit unit : list) {
            for (NamedWindowConsumerView consumerView : unit.getDispatchTo().get(handle)) {
                NamedWindowDeltaData deltaForConsumer = deltaPerConsumer.get(consumerView);
                if (deltaForConsumer == null) {
                    deltaPerConsumer.put(consumerView, unit.getDeltaData());
                    continue;
                }
                NamedWindowDeltaData aggregated = new NamedWindowDeltaData(deltaForConsumer, unit.getDeltaData());
                deltaPerConsumer.put(consumerView, aggregated);
            }
        }
        return deltaPerConsumer;
    }

    private static class NamedWindowLockPair {
        private final String statementName;
        private final StatementAgentInstanceLock lock;

        private NamedWindowLockPair(String statementName, StatementAgentInstanceLock lock) {
            this.statementName = statementName;
            this.lock = lock;
        }

        public String getStatementName() {
            return this.statementName;
        }

        public StatementAgentInstanceLock getLock() {
            return this.lock;
        }
    }
}

