/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.named.NamedWindowConsumerCallback;
import com.espertech.esper.epl.named.NamedWindowConsumerDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.epl.named.NamedWindowUtil;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.ViewSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class NamedWindowTailViewInstance
extends ViewSupport
implements Iterable<EventBean> {
    private final NamedWindowRootViewInstance rootViewInstance;
    private final NamedWindowTailView tailView;
    private final AgentInstanceContext agentInstanceContext;
    private volatile Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersInContext;
    private volatile long numberOfEvents;

    public NamedWindowTailViewInstance(NamedWindowRootViewInstance rootViewInstance, NamedWindowTailView tailView, AgentInstanceContext agentInstanceContext) {
        this.rootViewInstance = rootViewInstance;
        this.tailView = tailView;
        this.agentInstanceContext = agentInstanceContext;
        this.consumersInContext = NamedWindowUtil.createConsumerMap(tailView.isPrioritized());
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && !this.tailView.isParentBatchWindow()) {
            this.rootViewInstance.addNewData(newData);
        }
        if (oldData != null) {
            this.rootViewInstance.removeOldData(oldData);
            this.numberOfEvents -= (long)oldData.length;
        }
        if (newData != null) {
            this.numberOfEvents += (long)newData.length;
        }
        if (this.tailView.getStatementResultService().isMakeNatural() || this.tailView.getStatementResultService().isMakeSynthetic()) {
            this.updateChildren(newData, oldData);
        }
        if (!this.consumersInContext.isEmpty() || !this.tailView.getConsumersNonContext().isEmpty()) {
            NamedWindowDeltaData delta = new NamedWindowDeltaData(newData, oldData);
            this.tailView.getNamedWindowService().addDispatch(delta, this.consumersInContext);
            this.tailView.getNamedWindowService().addDispatch(delta, this.tailView.getConsumersNonContext());
        }
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc) {
        NamedWindowConsumerCallback consumerCallback = new NamedWindowConsumerCallback(){

            @Override
            public Iterator<EventBean> getIterator() {
                return NamedWindowTailViewInstance.this.iterator();
            }

            @Override
            public void stopped(NamedWindowConsumerView namedWindowConsumerView) {
                NamedWindowTailViewInstance.this.removeConsumer(namedWindowConsumerView);
            }
        };
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(ExprNodeUtility.getEvaluators(consumerDesc.getFilterList()), consumerDesc.getOptPropertyEvaluator(), this.tailView.getEventType(), consumerCallback, this.agentInstanceContext);
        List<NamedWindowConsumerView> viewsPerStatements = this.consumersInContext.get(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle());
        if (viewsPerStatements == null) {
            viewsPerStatements = new CopyOnWriteArrayList<NamedWindowConsumerView>();
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
            newConsumers.putAll(this.consumersInContext);
            newConsumers.put(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle(), viewsPerStatements);
            this.consumersInContext = newConsumers;
        }
        viewsPerStatements.add(consumerView);
        return consumerView;
    }

    public void removeConsumer(NamedWindowConsumerView namedWindowConsumerView) {
        EPStatementAgentInstanceHandle handleRemoved = null;
        for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : this.consumersInContext.entrySet()) {
            boolean foundAndRemoved = entry.getValue().remove(namedWindowConsumerView);
            if (!foundAndRemoved || entry.getValue().size() != 0) continue;
            handleRemoved = entry.getKey();
            break;
        }
        if (handleRemoved != null) {
            LinkedHashMap<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = new LinkedHashMap<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>>();
            newConsumers.putAll(this.consumersInContext);
            newConsumers.remove(handleRemoved);
            this.consumersInContext = newConsumers;
        }
    }

    @Override
    public EventType getEventType() {
        return this.tailView.getEventType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<EventBean> iterator() {
        if (this.tailView.getRevisionProcessor() != null) {
            Collection<EventBean> coll = this.tailView.getRevisionProcessor().getSnapshot(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this.parent);
            return coll.iterator();
        }
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Iterator<EventBean> it = this.parent.iterator();
            if (!it.hasNext()) {
                Iterator<EventBean> iterator = CollectionUtil.NULL_EVENT_ITERATOR;
                return iterator;
            }
            ArrayList<EventBean> list = new ArrayList<EventBean>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayEventIterator arrayEventIterator = new ArrayEventIterator(list.toArray(new EventBean[list.size()]));
            return arrayEventIterator;
        }
        finally {
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EventBean> snapshot(FilterSpecCompiled filter, Annotation[] annotations) {
        if (this.tailView.getRevisionProcessor() != null) {
            return this.tailView.getRevisionProcessor().getSnapshot(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this.parent);
        }
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Collection<EventBean> indexedResult = this.rootViewInstance.snapshot(filter, annotations);
            if (indexedResult != null) {
                Collection<EventBean> collection = indexedResult;
                return collection;
            }
            Iterator<EventBean> it = this.parent.iterator();
            if (!it.hasNext()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayDeque<EventBean> arrayDeque = list;
            return arrayDeque;
        }
        finally {
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    public void destroy() {
        this.consumersInContext.clear();
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public NamedWindowTailView getTailView() {
        return this.tailView;
    }
}

