/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.type.BoolValue;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.type.FloatValue;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.LongValue;
import com.espertech.esper.type.StringValue;
import org.antlr.runtime.tree.Tree;

public class ASTConstantHelper {
    public static String removeTicks(String tickedString) {
        int indexLast;
        int indexFirst = tickedString.indexOf(96);
        if (indexFirst != (indexLast = tickedString.lastIndexOf(96)) && indexFirst != -1 && indexLast != -1) {
            return tickedString.substring(indexFirst + 1, indexLast);
        }
        return tickedString;
    }

    public static Object parse(Tree node) {
        switch (node.getType()) {
            case 335: {
                return ASTConstantHelper.parseIntLongByte(node.getText());
            }
            case 285: {
                return ASTConstantHelper.parseIntLongByte(node.getText());
            }
            case 286: {
                return LongValue.parseString(node.getText());
            }
            case 290: {
                return BoolValue.parseString(node.getText());
            }
            case 287: {
                return Float.valueOf(FloatValue.parseString(node.getText()));
            }
            case 288: {
                return DoubleValue.parseString(node.getText());
            }
            case 289: {
                return StringValue.parseString(node.getText());
            }
            case 291: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected constant of non-primitive type " + node.getType() + " encountered");
    }

    private static Object parseIntLongByte(String arg) {
        try {
            return IntValue.parseString(arg);
        }
        catch (NumberFormatException e1) {
            try {
                return LongValue.parseString(arg);
            }
            catch (Exception e2) {
                try {
                    return Byte.decode(arg);
                }
                catch (Exception e3) {
                    throw e1;
                }
            }
        }
    }
}

