/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import org.antlr.runtime.tree.Tree;

public class ASTFilterSpecHelper {
    protected static String getPropertyName(Tree parentNode, int startIndex) {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        for (int childIndex = startIndex; childIndex < parentNode.getChildCount(); ++childIndex) {
            Tree child = parentNode.getChild(childIndex);
            buffer.append(delimiter);
            switch (child.getType()) {
                case 183: {
                    buffer.append(ASTFilterSpecHelper.escapeDot(child.getChild(0).getText()));
                    break;
                }
                case 184: {
                    buffer.append(ASTFilterSpecHelper.escapeDot(child.getChild(0).getText()));
                    buffer.append('(');
                    buffer.append(child.getChild(1).getText());
                    buffer.append(')');
                    break;
                }
                case 185: {
                    buffer.append(ASTFilterSpecHelper.escapeDot(child.getChild(0).getText()));
                    buffer.append('[');
                    buffer.append(child.getChild(1).getText());
                    buffer.append(']');
                    break;
                }
                case 186: {
                    buffer.append(ASTFilterSpecHelper.escapeDot(child.getChild(0).getText()));
                    buffer.append('?');
                    break;
                }
                case 188: {
                    buffer.append(ASTFilterSpecHelper.escapeDot(child.getChild(0).getText()));
                    buffer.append('(');
                    buffer.append(child.getChild(1).getText());
                    buffer.append(')');
                    buffer.append('?');
                    break;
                }
                case 187: {
                    buffer.append(ASTFilterSpecHelper.escapeDot(child.getChild(0).getText()));
                    buffer.append('[');
                    buffer.append(child.getChild(1).getText());
                    buffer.append(']');
                    buffer.append('?');
                    break;
                }
                default: {
                    throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
                }
            }
            delimiter = ".";
        }
        return buffer.toString();
    }

    protected static String escapeDot(String identifierToEscape) {
        int indexof = identifierToEscape.indexOf(".");
        if (indexof == -1) {
            return identifierToEscape;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < identifierToEscape.length(); ++i) {
            char c = identifierToEscape.charAt(i);
            if (c != '.') {
                builder.append(c);
                continue;
            }
            if (i > 0 && identifierToEscape.charAt(i - 1) == '\\') {
                builder.append('.');
                continue;
            }
            builder.append('\\');
            builder.append('.');
        }
        return builder.toString();
    }

    public static int unescapedIndexOfDot(String identifier) {
        int indexof = identifier.indexOf(".");
        if (indexof == -1) {
            return -1;
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c != '.' || i > 0 && identifier.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    public static String unescapeDot(String identifierToUnescape) {
        int indexof = identifierToUnescape.indexOf(".");
        if (indexof == -1) {
            return identifierToUnescape;
        }
        indexof = identifierToUnescape.indexOf("\\");
        if (indexof == -1) {
            return identifierToUnescape;
        }
        StringBuilder builder = new StringBuilder();
        int index = -1;
        int max = identifierToUnescape.length() - 1;
        do {
            char c;
            if ((c = identifierToUnescape.charAt(++index)) != '\\') {
                builder.append(c);
                continue;
            }
            if (index >= identifierToUnescape.length() - 1 || identifierToUnescape.charAt(index + 1) != '.') continue;
            builder.append('.');
            ++index;
        } while (index < max);
        return builder.toString();
    }
}

