/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.IntValue;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;

public class ASTOutputLimitHelper {
    public static OutputLimitSpec buildOutputLimitSpec(Tree node, Map<Tree, ExprNode> astExprNodeMap, VariableService variableService, String engineURI, TimeProvider timeProvider, ExprEvaluatorContext exprEvaluatorContext) {
        int count = 0;
        Tree child = node.getChild(count);
        OutputLimitLimitType displayLimit = OutputLimitLimitType.DEFAULT;
        if (child.getType() == 52) {
            displayLimit = OutputLimitLimitType.FIRST;
            child = node.getChild(++count);
        } else if (child.getType() == 53) {
            displayLimit = OutputLimitLimitType.LAST;
            child = node.getChild(++count);
        } else if (child.getType() == 82) {
            displayLimit = OutputLimitLimitType.SNAPSHOT;
            child = node.getChild(++count);
        } else if (child.getType() == 47) {
            displayLimit = OutputLimitLimitType.ALL;
            child = node.getChild(++count);
        }
        String variableName = null;
        double rate = -1.0;
        ExprNode whenExpression = null;
        List<ExprNode> crontabScheduleSpec = null;
        List<OnTriggerSetAssignment> thenExpressions = null;
        ExprTimePeriod timePeriodExpr = null;
        if (node.getType() != 195) {
            if (node.getType() == 194) {
                Tree expressionNode = node.getChild(count);
                whenExpression = astExprNodeMap.remove(expressionNode);
                if (node.getChildCount() > count + 1) {
                    Tree setExpr = ASTUtil.findFirstNode(node, 247);
                    thenExpressions = EPLTreeWalker.getOnTriggerSetAssignments(setExpr, astExprNodeMap);
                }
            } else if (node.getType() == 192) {
                Tree parent = node.getChild(0);
                if (parent.getType() != 193) {
                    parent = node.getChild(1);
                }
                crontabScheduleSpec = ASTUtil.getRemoveAllChildExpr(parent, astExprNodeMap);
            } else if (node.getType() != 191) {
                if (child.getType() == 305) {
                    variableName = child.getText();
                } else if (child.getType() == 204) {
                    ExprNode expression = astExprNodeMap.remove(child);
                    try {
                        ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(engineURI, false), null, null, timeProvider, variableService, exprEvaluatorContext, null, null, null, null, null);
                        timePeriodExpr = (ExprTimePeriod)ExprNodeUtility.getValidatedSubtree(expression, validationContext);
                    }
                    catch (ExprValidationException ex) {
                        throw new ASTWalkException("Invalid time period expresion: " + ex.getMessage(), ex);
                    }
                } else {
                    rate = Double.parseDouble(child.getText());
                }
            }
        }
        ExprTimePeriod afterTimePeriodExpr = null;
        Integer afterNumberOfEvents = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 117) continue;
            ExprNode expression = astExprNodeMap.remove(node.getChild(i).getChild(0));
            if (expression != null) {
                try {
                    ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(engineURI, false), null, null, timeProvider, variableService, exprEvaluatorContext, null, null, null, null, null);
                    afterTimePeriodExpr = (ExprTimePeriod)ExprNodeUtility.getValidatedSubtree(expression, validationContext);
                    continue;
                }
                catch (ExprValidationException ex) {
                    throw new ASTWalkException("Invalid time period expresion: " + ex.getMessage(), ex);
                }
            }
            Object constant = ASTConstantHelper.parse(node.getChild(i).getChild(0));
            afterNumberOfEvents = ((Number)constant).intValue();
        }
        boolean andAfterTerminate = node.getChild(node.getChildCount() - 1).getType() == 128;
        switch (node.getType()) {
            case 189: {
                return new OutputLimitSpec(rate, variableName, OutputLimitRateType.EVENTS, displayLimit, null, null, null, null, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate);
            }
            case 190: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.TIME_PERIOD, displayLimit, null, null, null, timePeriodExpr, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate);
            }
            case 192: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.CRONTAB, displayLimit, null, null, crontabScheduleSpec, null, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate);
            }
            case 194: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.WHEN_EXPRESSION, displayLimit, whenExpression, thenExpressions, null, null, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate);
            }
            case 191: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.AFTER, displayLimit, null, null, null, null, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate);
            }
            case 195: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.TERM, displayLimit, null, null, null, null, afterTimePeriodExpr, afterNumberOfEvents, andAfterTerminate);
            }
        }
        throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized output limit type");
    }

    public static RowLimitSpec buildRowLimitSpec(Tree node) {
        Object offset;
        Object numRows;
        if (node.getChildCount() == 1) {
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(0));
            offset = null;
        } else if (node.getChild(node.getChildCount() - 1).getType() == 311) {
            offset = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(0));
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(1));
        } else {
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(0));
            offset = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(1));
        }
        Integer numRowsInt = null;
        String numRowsVariable = null;
        if (numRows instanceof String) {
            numRowsVariable = (String)numRows;
        } else {
            numRowsInt = (Integer)numRows;
        }
        Integer offsetInt = null;
        String offsetVariable = null;
        if (offset instanceof String) {
            offsetVariable = (String)offset;
        } else {
            offsetInt = (Integer)offset;
        }
        return new RowLimitSpec(numRowsInt, offsetInt, numRowsVariable, offsetVariable);
    }

    private static Object parseNumOrVariableIdent(Tree child) {
        if (child.getType() == 305) {
            return child.getText();
        }
        return IntValue.parseString(child.getText());
    }
}

