/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.EPAdministratorHelper;
import com.espertech.esper.epl.agg.AggregationAccessType;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.declexpr.ExprDeclaredNodeImpl;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.expression.ExprAccessAggNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprAndNodeImpl;
import com.espertech.esper.epl.expression.ExprArrayNode;
import com.espertech.esper.epl.expression.ExprAvedevNode;
import com.espertech.esper.epl.expression.ExprAvgNode;
import com.espertech.esper.epl.expression.ExprBetweenNodeImpl;
import com.espertech.esper.epl.expression.ExprBitWiseNode;
import com.espertech.esper.epl.expression.ExprCaseNode;
import com.espertech.esper.epl.expression.ExprCastNode;
import com.espertech.esper.epl.expression.ExprChainedSpec;
import com.espertech.esper.epl.expression.ExprCoalesceNode;
import com.espertech.esper.epl.expression.ExprConcatNode;
import com.espertech.esper.epl.expression.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.ExprContextPropertyNode;
import com.espertech.esper.epl.expression.ExprCountNode;
import com.espertech.esper.epl.expression.ExprDotNode;
import com.espertech.esper.epl.expression.ExprEqualsAllAnyNode;
import com.espertech.esper.epl.expression.ExprEqualsNodeImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorContextTimeOnly;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.ExprInNodeImpl;
import com.espertech.esper.epl.expression.ExprInstanceofNode;
import com.espertech.esper.epl.expression.ExprLikeNode;
import com.espertech.esper.epl.expression.ExprMathNode;
import com.espertech.esper.epl.expression.ExprMedianNode;
import com.espertech.esper.epl.expression.ExprMinMaxAggrNode;
import com.espertech.esper.epl.expression.ExprMinMaxRowNode;
import com.espertech.esper.epl.expression.ExprNewNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprNotNode;
import com.espertech.esper.epl.expression.ExprNumberSetCronParam;
import com.espertech.esper.epl.expression.ExprNumberSetFrequency;
import com.espertech.esper.epl.expression.ExprNumberSetList;
import com.espertech.esper.epl.expression.ExprNumberSetRange;
import com.espertech.esper.epl.expression.ExprNumberSetWildcard;
import com.espertech.esper.epl.expression.ExprOrNode;
import com.espertech.esper.epl.expression.ExprOrderedExpr;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNode;
import com.espertech.esper.epl.expression.ExprPlugInSingleRowNode;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprPropertyExistsNode;
import com.espertech.esper.epl.expression.ExprRegexpNode;
import com.espertech.esper.epl.expression.ExprRelationalOpAllAnyNode;
import com.espertech.esper.epl.expression.ExprRelationalOpNodeImpl;
import com.espertech.esper.epl.expression.ExprStddevNode;
import com.espertech.esper.epl.expression.ExprSubselectAllSomeAnyNode;
import com.espertech.esper.epl.expression.ExprSubselectExistsNode;
import com.espertech.esper.epl.expression.ExprSubselectInNode;
import com.espertech.esper.epl.expression.ExprSubselectRowNode;
import com.espertech.esper.epl.expression.ExprSubstitutionNode;
import com.espertech.esper.epl.expression.ExprSumNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprTimestampNode;
import com.espertech.esper.epl.expression.ExprTypeofNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprVariableNode;
import com.espertech.esper.epl.expression.PreviousType;
import com.espertech.esper.epl.generated.EsperEPL2Ast;
import com.espertech.esper.epl.parse.ASTAnnotationHelper;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.epl.parse.ASTMatchRecognizeHelper;
import com.espertech.esper.epl.parse.ASTMatchUntilHelper;
import com.espertech.esper.epl.parse.ASTOutputLimitHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.epl.spec.ContextDetail;
import com.espertech.esper.epl.spec.ContextDetailCategory;
import com.espertech.esper.epl.spec.ContextDetailCategoryItem;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.epl.spec.ContextDetailPartitioned;
import com.espertech.esper.epl.spec.ContextDetailTemporalFixed;
import com.espertech.esper.epl.spec.CreateContextDesc;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.CreateIndexItem;
import com.espertech.esper.epl.spec.CreateIndexType;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.spec.CreateWindowDesc;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.ExpressionDeclDesc;
import com.espertech.esper.epl.spec.ExpressionDeclItem;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.ForClauseItemSpec;
import com.espertech.esper.epl.spec.ForClauseSpec;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeInterval;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MatchRecognizeSkipEnum;
import com.espertech.esper.epl.spec.MatchRecognizeSpec;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerMergeAction;
import com.espertech.esper.epl.spec.OnTriggerMergeActionDelete;
import com.espertech.esper.epl.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.epl.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.epl.spec.OnTriggerMergeDesc;
import com.espertech.esper.epl.spec.OnTriggerMergeMatched;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerType;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.PatternGuardSpec;
import com.espertech.esper.epl.spec.PatternObserverSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.PropertyEvalAtom;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.PatternNodeFactory;
import com.espertech.esper.pattern.guard.GuardEnum;
import com.espertech.esper.rowregex.RegexNFATypeEnum;
import com.espertech.esper.rowregex.RowRegexExprNode;
import com.espertech.esper.rowregex.RowRegexExprNodeAlteration;
import com.espertech.esper.rowregex.RowRegexExprNodeAtom;
import com.espertech.esper.rowregex.RowRegexExprNodeConcatenation;
import com.espertech.esper.rowregex.RowRegexExprNodeNested;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.BitWiseOpEnum;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.MathArithTypeEnum;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.PlaceholderParseException;
import com.espertech.esper.util.PlaceholderParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPLTreeWalker
extends EsperEPL2Ast {
    private Map<Tree, ExprNode> astExprNodeMap = new HashMap<Tree, ExprNode>();
    private final Stack<Map<Tree, ExprNode>> astExprNodeMapStack;
    private final Map<Tree, EvalFactoryNode> astPatternNodeMap = new HashMap<Tree, EvalFactoryNode>();
    private final Map<Tree, RowRegexExprNode> astRowRegexNodeMap = new HashMap<Tree, RowRegexExprNode>();
    private FilterSpecRaw filterSpec;
    private final List<ViewSpec> viewSpecs = new LinkedList<ViewSpec>();
    private List<ExprSubstitutionNode> substitutionParamNodes = new ArrayList<ExprSubstitutionNode>();
    private StatementSpecRaw statementSpec;
    private final Stack<StatementSpecRaw> statementSpecStack;
    private List<SelectClauseElementRaw> propertySelectRaw;
    private PropertyEvalSpec propertyEvalSpec;
    private List<OnTriggerMergeMatched> mergeMatcheds;
    private List<OnTriggerMergeAction> mergeActions;
    private Map<EvalFactoryNode, String> evalNodeExpressions;
    private ContextDescriptor contextDescriptor;
    private final EngineImportService engineImportService;
    private final VariableService variableService;
    private final TimeProvider timeProvider;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final SelectClauseStreamSelectorEnum defaultStreamSelector;
    private final String engineURI;
    private final ConfigurationInformation configurationInformation;
    private final SchedulingService schedulingService;
    private final PatternNodeFactory patternNodeFactory;
    private final ContextManagementService contextManagementService;
    private final CommonTokenStream tokenStream;
    private static final Log log = LogFactory.getLog(EPLTreeWalker.class);

    public EPLTreeWalker(TreeNodeStream input, CommonTokenStream tokenStream, EngineImportService engineImportService, VariableService variableService, SchedulingService schedulingService, SelectClauseStreamSelectorEnum defaultStreamSelector, String engineURI, ConfigurationInformation configurationInformation, PatternNodeFactory patternNodeFactory, ContextManagementService contextManagementService) {
        super(input);
        this.tokenStream = tokenStream;
        this.engineImportService = engineImportService;
        this.variableService = variableService;
        this.defaultStreamSelector = defaultStreamSelector;
        this.timeProvider = schedulingService;
        this.patternNodeFactory = patternNodeFactory;
        this.exprEvaluatorContext = new ExprEvaluatorContextTimeOnly(this.timeProvider);
        this.engineURI = engineURI;
        this.configurationInformation = configurationInformation;
        this.schedulingService = schedulingService;
        this.contextManagementService = contextManagementService;
        if (defaultStreamSelector == null) {
            throw new IllegalArgumentException("Default stream selector is null");
        }
        this.statementSpec = new StatementSpecRaw(defaultStreamSelector);
        this.statementSpecStack = new Stack();
        this.astExprNodeMapStack = new Stack();
    }

    @Override
    protected void pushStmtContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)".pushStmtContext");
        }
        this.statementSpecStack.push(this.statementSpec);
        this.astExprNodeMapStack.push(this.astExprNodeMap);
        this.statementSpec = new StatementSpecRaw(this.defaultStreamSelector);
        this.astExprNodeMap = new HashMap<Tree, ExprNode>();
    }

    public StatementSpecRaw getStatementSpec() {
        return this.statementSpec;
    }

    @Override
    protected void leaveNode(Tree node) throws ASTWalkException {
        Object childEvalNode;
        Tree childNode;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".leaveNode " + node));
        }
        switch (node.getType()) {
            case 173: {
                this.leaveStreamExpr(node);
                break;
            }
            case 138: {
                this.leaveStreamFilter(node);
                break;
            }
            case 135: {
                this.leavePatternFilter(node);
                break;
            }
            case 156: {
                return;
            }
            case 155: {
                this.leaveView(node);
                break;
            }
            case 170: {
                this.leaveSelectClause(node);
                break;
            }
            case 221: {
                this.leaveWildcardSelect();
                break;
            }
            case 171: {
                this.leaveSelectionElement(node);
                break;
            }
            case 172: {
                this.leaveSelectionStream(node);
                break;
            }
            case 141: {
                this.leavePropertySelectionElement(node);
                break;
            }
            case 142: {
                this.leavePropertySelectionStream(node);
                break;
            }
            case 143: {
                this.leavePropertyWildcardSelect();
                break;
            }
            case 140: {
                this.leavePropertySelectAtom(node);
                break;
            }
            case 182: {
                this.leaveEventPropertyExpr(node);
                break;
            }
            case 161: {
                this.leaveJoinAndExpr(node);
                break;
            }
            case 162: {
                this.leaveJoinOrExpr(node);
                break;
            }
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.leaveEqualsExpr(node);
                break;
            }
            case 167: 
            case 168: 
            case 374: 
            case 375: {
                this.leaveEqualsGroupExpr(node);
                break;
            }
            case 158: {
                this.leaveWhereClause();
                break;
            }
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 335: {
                this.leaveConstant(node);
                break;
            }
            case 233: {
                this.leaveSubstitution(node);
                break;
            }
            case 316: 
            case 318: 
            case 332: 
            case 333: 
            case 334: {
                this.leaveMath(node);
                break;
            }
            case 317: 
            case 323: 
            case 324: {
                this.leaveBitWise(node);
                break;
            }
            case 327: 
            case 328: 
            case 329: 
            case 330: {
                this.leaveRelationalOp(node);
                break;
            }
            case 22: {
                this.leaveCoalesce(node);
                break;
            }
            case 13: {
                this.leaveExprNot(node);
                break;
            }
            case 136: {
                this.leavePatternNot(node);
                break;
            }
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 261: 
            case 262: 
            case 263: {
                this.leaveAggregate(node);
                break;
            }
            case 202: {
                this.leaveDotExpr(node);
                break;
            }
            case 201: {
                this.leaveLibFunctionChain(node);
                break;
            }
            case 175: 
            case 176: 
            case 177: 
            case 178: {
                this.leaveOuterInnerJoin(node);
                break;
            }
            case 179: {
                this.leaveGroupBy(node);
                break;
            }
            case 159: {
                this.leaveHavingClause();
                break;
            }
            case 180: {
                break;
            }
            case 181: {
                this.leaveOrderByElement(node);
                break;
            }
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 194: 
            case 195: {
                this.leaveOutputLimit(node);
                break;
            }
            case 109: {
                this.leaveRowLimit(node);
                break;
            }
            case 196: {
                this.leaveInsertInto(node);
                break;
            }
            case 199: {
                this.leaveConcat(node);
                break;
            }
            case 28: {
                this.leaveCaseNode(node, false);
                break;
            }
            case 29: {
                this.leaveCaseNode(node, true);
                break;
            }
            case 14: {
                this.leaveEvery(node);
                break;
            }
            case 15: {
                this.leaveEveryDistinct(node);
                break;
            }
            case 133: {
                this.leaveFollowedBy(node);
                break;
            }
            case 11: {
                this.leaveOr(node);
                break;
            }
            case 12: {
                this.leaveAnd(node);
                break;
            }
            case 153: {
                this.leaveGuard(node);
                break;
            }
            case 154: {
                this.leaveObserver(node);
                break;
            }
            case 250: {
                this.leaveMatch(node);
                break;
            }
            case 6: 
            case 214: {
                this.leaveInSet(node);
                break;
            }
            case 223: 
            case 224: {
                this.leaveInRange(node);
                break;
            }
            case 7: 
            case 215: {
                this.leaveBetween(node);
                break;
            }
            case 8: 
            case 216: {
                this.leaveLike(node);
                break;
            }
            case 9: 
            case 217: {
                this.leaveRegexp(node);
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                this.leavePrevious(node);
                break;
            }
            case 73: {
                this.leavePrior(node);
                break;
            }
            case 205: {
                this.leaveArray(node);
                break;
            }
            case 225: {
                this.leaveSubselectRow(node);
                break;
            }
            case 227: {
                this.leaveSubselectExists(node);
                break;
            }
            case 228: 
            case 229: {
                this.leaveSubselectIn(node);
                break;
            }
            case 230: {
                this.leaveSubselectQueryIn(node);
                break;
            }
            case 77: {
                this.leaveInstanceOf(node);
                break;
            }
            case 78: {
                this.leaveTypeOf(node);
                break;
            }
            case 74: {
                this.leaveExists(node);
                break;
            }
            case 79: {
                this.leaveCast(node);
                break;
            }
            case 80: {
                this.leaveTimestamp(node);
                break;
            }
            case 236: {
                this.leaveCreateWindow(node);
                break;
            }
            case 235: {
                this.leaveCreateIndex(node);
                break;
            }
            case 267: {
                this.leaveCreateSchema(node);
                break;
            }
            case 237: {
                this.leaveCreateWindowSelect();
                break;
            }
            case 248: {
                this.leaveCreateVariable(node);
                break;
            }
            case 238: {
                this.leaveOnExpr(node);
                break;
            }
            case 265: {
                this.leaveUpdateExpr(node);
                break;
            }
            case 204: {
                this.leaveTimePeriod(node);
                break;
            }
            case 257: {
                this.leaveNumberSetStar(node);
                break;
            }
            case 131: {
                this.leaveNumberSetFrequency(node);
                break;
            }
            case 129: {
                this.leaveNumberSetRange(node);
                break;
            }
            case 130: {
                this.leaveNumberSetList(node);
                break;
            }
            case 53: 
            case 231: {
                this.leaveLastNumberSetOperator(node);
                break;
            }
            case 76: {
                this.leaveLastWeekdayNumberSetOperator(node);
                break;
            }
            case 232: {
                this.leaveWeekdayNumberSetOperator(node);
                break;
            }
            case 132: {
                this.leaveObjectParamOrderedExpression(node);
                break;
            }
            case 258: {
                this.leaveAnnotation(node);
                break;
            }
            case 304: {
                this.leaveMatchRecognizeMeasureItem(node);
                break;
            }
            case 294: {
                this.leaveMatchRecognizePattern(node);
                break;
            }
            case 298: {
                this.leaveMatchRecognizePatternNested(node);
                break;
            }
            case 296: {
                this.leaveMatchRecognizePatternConcat(node);
                break;
            }
            case 297: {
                this.leaveMatchRecognizePatternAlter(node);
                break;
            }
            case 295: {
                this.leaveMatchRecognizePatternAtom(node);
                break;
            }
            case 302: {
                this.leaveMatchRecognizeDefineItem(node);
                break;
            }
            case 284: {
                this.leaveMatchRecognizePartition(node);
                break;
            }
            case 112: {
                this.leaveMatchRecognize(node);
                break;
            }
            case 241: {
                this.leaveOnSelect(node);
                break;
            }
            case 239: {
                this.leaveOnStream(node);
                break;
            }
            case 118: {
                this.leaveForClause(node);
                break;
            }
            case 271: 
            case 272: {
                this.leaveMergeMatchedUnmatched(node);
                break;
            }
            case 275: {
                this.leaveMergeDelClause(node);
                break;
            }
            case 273: {
                this.leaveMergeUpdClause(node);
                break;
            }
            case 274: {
                this.leaveMergeInsClause(node);
                break;
            }
            case 123: {
                this.leaveExpressionDecl(node);
                break;
            }
            case 124: {
                this.leaveNewKeyword(node);
                break;
            }
            case 126: {
                this.leaveContext(node);
                break;
            }
            case 278: {
                this.leaveCreateContext(node);
                break;
            }
            default: {
                throw new ASTWalkException("Unhandled node type encountered, type '" + node.getType() + "' with text '" + node.getText() + '\'');
            }
        }
        if (!this.astExprNodeMap.isEmpty()) {
            this.mapChildASTToChildExprNode(node);
        }
        if (!this.astPatternNodeMap.isEmpty()) {
            EvalFactoryNode thisPatternNode = this.astPatternNodeMap.get(node);
            for (i = 0; i < node.getChildCount(); ++i) {
                childNode = node.getChild(i);
                childEvalNode = this.astPatternNodeMap.get(childNode);
                if (childEvalNode == null) continue;
                thisPatternNode.addChildNode((EvalFactoryNode)childEvalNode);
                this.astPatternNodeMap.remove(childNode);
            }
        }
        if (!this.astRowRegexNodeMap.isEmpty()) {
            RowRegexExprNode thisRegexNode = this.astRowRegexNodeMap.get(node);
            for (i = 0; i < node.getChildCount(); ++i) {
                childNode = node.getChild(i);
                childEvalNode = this.astRowRegexNodeMap.get(childNode);
                if (childEvalNode == null) continue;
                thisRegexNode.addChildNode((RowRegexExprNode)childEvalNode);
                this.astRowRegexNodeMap.remove(childNode);
            }
        }
        switch (node.getType()) {
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 261: 
            case 262: 
            case 263: {
                this.postLeaveAggregate(node);
            }
        }
    }

    private void mapChildASTToChildExprNode(Tree node) {
        ExprNode thisEvalNode = this.astExprNodeMap.get(node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            ExprNode childEvalNode = this.astExprNodeMap.get(childNode);
            if (childEvalNode == null || thisEvalNode == null) continue;
            thisEvalNode.addChildNode(childEvalNode);
            this.astExprNodeMap.remove(childNode);
        }
    }

    private void leaveCreateWindow(Tree node) {
        log.debug((Object)".leaveCreateWindow");
        String windowName = node.getChild(0).getText();
        String eventName = null;
        Tree eventNameNode = ASTUtil.findFirstNode(node, 152);
        if (eventNameNode != null) {
            eventName = eventNameNode.getText();
        }
        if (eventName == null) {
            eventName = "java.lang.Object";
        }
        boolean isRetainUnion = false;
        boolean isRetainIntersection = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() == 64) {
                isRetainUnion = true;
                break;
            }
            if (node.getChild(i).getType() != 65) continue;
            isRetainIntersection = true;
            break;
        }
        StreamSpecOptions streamSpecOptions = new StreamSpecOptions(false, isRetainUnion, isRetainIntersection);
        List<ColumnDesc> colums = this.getColTypeList(node);
        boolean isInsert = false;
        ExprNode insertWhereExpr = null;
        Tree insertNode = ASTUtil.findFirstNode(node, 54);
        if (insertNode != null) {
            isInsert = true;
            if (insertNode.getChildCount() > 0) {
                insertWhereExpr = ASTUtil.getRemoveExpr(insertNode.getChild(0), this.astExprNodeMap);
            }
        }
        CreateWindowDesc desc = new CreateWindowDesc(windowName, this.viewSpecs, streamSpecOptions, isInsert, insertWhereExpr, colums, eventName);
        this.statementSpec.setCreateWindowDesc(desc);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, new LinkedList<ExprNode>(), null);
        FilterStreamSpecRaw streamSpec = new FilterStreamSpecRaw(rawFilterSpec, new LinkedList<ViewSpec>(), null, streamSpecOptions);
        this.statementSpec.getStreamSpecs().add(streamSpec);
    }

    private List<ColumnDesc> getColTypeList(Tree node) {
        ArrayList<ColumnDesc> result = new ArrayList<ColumnDesc>();
        for (int nodeNum = 0; nodeNum < node.getChildCount(); ++nodeNum) {
            if (node.getChild(nodeNum).getType() != 255) continue;
            Tree parent = node.getChild(nodeNum);
            for (int i = 0; i < parent.getChildCount(); ++i) {
                String name = parent.getChild(i).getChild(0).getText();
                String type = parent.getChild(i).getChild(1).getText();
                boolean array = parent.getChild(i).getChildCount() > 2;
                result.add(new ColumnDesc(name, type, array));
            }
        }
        return result;
    }

    private void leaveCreateIndex(Tree node) {
        log.debug((Object)".leaveCreateIndex");
        String indexName = node.getChild(0).getText();
        String windowName = node.getChild(1).getText();
        Tree nodeExpr = node.getChild(2);
        ArrayList<CreateIndexItem> columns = new ArrayList<CreateIndexItem>();
        for (int i = 0; i < nodeExpr.getChildCount(); ++i) {
            CreateIndexType type = CreateIndexType.HASH;
            Tree child = nodeExpr.getChild(i);
            if (child.getType() != 198) continue;
            String columnName = child.getChild(0).getText();
            if (child.getChildCount() == 2) {
                String typeName = child.getChild(1).getText();
                try {
                    type = CreateIndexType.valueOf(typeName.toUpperCase());
                }
                catch (RuntimeException ex) {
                    throw new ASTWalkException("Invalid column index type '" + typeName + "' encountered, please use any of the following index type names " + Arrays.asList(CreateIndexType.values()));
                }
            }
            columns.add(new CreateIndexItem(columnName, type));
        }
        this.statementSpec.setCreateIndexDesc(new CreateIndexDesc(indexName, windowName, columns));
    }

    private void leaveCreateSchema(Tree node) {
        log.debug((Object)".leaveCreateSchema");
        String schemaName = node.getChild(0).getText();
        List<ColumnDesc> columnTypes = this.getColTypeList(node);
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 270) continue;
            for (int j = 0; j < node.getChild(i).getChildCount(); ++j) {
                typeNames.add(node.getChild(i).getChild(j).getText());
            }
        }
        boolean variant = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree p = node.getChild(i);
            if (p.getType() != 269) continue;
            if (!p.getChild(0).getText().toLowerCase().equals("variant")) {
                throw new EPException("Expected 'variant' keyword after create-schema clause but encountered '" + p.getChild(0).getText() + "'");
            }
            variant = true;
        }
        String startTimestamp = null;
        String endTimestamp = null;
        LinkedHashSet<String> inherited = new LinkedHashSet<String>();
        LinkedHashSet<String> copyFrom = new LinkedHashSet<String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree p = node.getChild(i);
            if (p.getType() != 268) continue;
            String childName = p.getChild(0).getText().toLowerCase();
            if (childName.equals("inherits")) {
                for (int j = 1; j < p.getChildCount(); ++j) {
                    if (p.getChild(j).getType() != 197) continue;
                    for (int k = 0; k < p.getChild(j).getChildCount(); ++k) {
                        inherited.add(p.getChild(j).getChild(k).getText());
                    }
                }
                continue;
            }
            if (childName.equals("starttimestamp")) {
                startTimestamp = p.getChild(1).getChild(0).getText();
                continue;
            }
            if (childName.equals("endtimestamp")) {
                endTimestamp = p.getChild(1).getChild(0).getText();
                continue;
            }
            if (childName.equals("copyfrom")) {
                Tree parent = p.getChild(1);
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    copyFrom.add(parent.getChild(j).getText());
                }
                continue;
            }
            throw new EPException("Expected 'inherits', 'starttimestamp', 'endtimestamp' or 'copyfrom' keyword after create-schema clause but encountered '" + p.getChild(0).getText() + "'");
        }
        this.statementSpec.getStreamSpecs().add(new FilterStreamSpecRaw(new FilterSpecRaw(Object.class.getName(), Collections.<ExprNode>emptyList(), null), Collections.<ViewSpec>emptyList(), null, new StreamSpecOptions()));
        this.statementSpec.setCreateSchemaDesc(new CreateSchemaDesc(schemaName, typeNames, columnTypes, inherited, variant, startTimestamp, endTimestamp, copyFrom));
    }

    private void leaveCreateVariable(Tree node) {
        log.debug((Object)".leaveCreateVariable");
        Tree child = node.getChild(0);
        String variableType = child.getText();
        child = node.getChild(1);
        String variableName = child.getText();
        ExprNode assignment = null;
        if (node.getChildCount() > 2) {
            child = node.getChild(2);
            assignment = this.astExprNodeMap.get(child);
            this.astExprNodeMap.remove(child);
        }
        CreateVariableDesc desc = new CreateVariableDesc(variableType, variableName, assignment);
        this.statementSpec.setCreateVariableDesc(desc);
    }

    private void leaveCreateWindowSelect() {
        log.debug((Object)".leaveCreateWindowSelect");
    }

    private void leaveOnExpr(Tree node) {
        log.debug((Object)".leaveOnExpr");
        boolean isOnDelete = false;
        Tree typeChildNode = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            if (childNode.getType() == 240) {
                typeChildNode = childNode;
                isOnDelete = true;
                continue;
            }
            if (childNode.getType() == 241) {
                typeChildNode = childNode;
                continue;
            }
            if (childNode.getType() == 242) {
                typeChildNode = childNode;
                continue;
            }
            if (childNode.getType() == 247) {
                typeChildNode = childNode;
                continue;
            }
            if (childNode.getType() != 243) continue;
            typeChildNode = childNode;
        }
        if (typeChildNode == null) {
            throw new IllegalStateException("Could not determine on-expr type");
        }
        if (typeChildNode.getType() == 243) {
            String windowName = typeChildNode.getChild(0).getText();
            String asName = null;
            if (typeChildNode.getChild(1).getType() == 305) {
                asName = typeChildNode.getChild(1).getText();
            }
            OnTriggerMergeDesc desc = new OnTriggerMergeDesc(windowName, asName, this.mergeMatcheds == null ? Collections.emptyList() : this.mergeMatcheds);
            this.statementSpec.setOnTriggerDesc(desc);
        } else if (typeChildNode.getType() != 247) {
            UniformPair<String> windowName = this.getWindowName(typeChildNode);
            if (windowName == null) {
                ArrayList<OnTriggerSplitStream> splitStreams = new ArrayList<OnTriggerSplitStream>();
                for (int i = 1; i <= this.statementSpecStack.size() - 1; ++i) {
                    StatementSpecRaw raw = (StatementSpecRaw)this.statementSpecStack.get(i);
                    splitStreams.add(new OnTriggerSplitStream(raw.getInsertIntoDesc(), raw.getSelectClauseSpec(), raw.getFilterExprRootNode()));
                }
                splitStreams.add(new OnTriggerSplitStream(this.statementSpec.getInsertIntoDesc(), this.statementSpec.getSelectClauseSpec(), this.statementSpec.getFilterExprRootNode()));
                if (!this.statementSpecStack.isEmpty()) {
                    this.statementSpec = (StatementSpecRaw)this.statementSpecStack.get(0);
                }
                boolean isFirst = this.isSelectInsertFirst(node);
                this.statementSpec.setOnTriggerDesc(new OnTriggerSplitStreamDesc(OnTriggerType.ON_SPLITSTREAM, isFirst, splitStreams));
                this.statementSpecStack.clear();
            } else if (typeChildNode.getType() == 242) {
                List<OnTriggerSetAssignment> assignments = EPLTreeWalker.getOnTriggerSetAssignments(typeChildNode, this.astExprNodeMap);
                this.statementSpec.setOnTriggerDesc(new OnTriggerWindowUpdateDesc(windowName.getFirst(), windowName.getSecond(), assignments));
                this.statementSpec.setFilterExprRootNode(this.getRemoveFirstByType(typeChildNode, 158));
            } else {
                this.statementSpec.setOnTriggerDesc(new OnTriggerWindowDesc(windowName.getFirst(), windowName.getSecond(), isOnDelete ? OnTriggerType.ON_DELETE : OnTriggerType.ON_SELECT));
            }
        } else {
            List<OnTriggerSetAssignment> assignments = EPLTreeWalker.getOnTriggerSetAssignments(typeChildNode, this.astExprNodeMap);
            this.statementSpec.setOnTriggerDesc(new OnTriggerSetDesc(assignments));
        }
    }

    private void leaveOnStream(Tree node) {
        StreamSpecBase streamSpec;
        log.debug((Object)".leaveOnStream");
        Tree childNode = node.getChild(1);
        String streamAsName = null;
        if (childNode != null && childNode.getType() == 305) {
            streamAsName = childNode.getText();
        }
        if (node.getChild(0).getType() == 138) {
            streamSpec = new FilterStreamSpecRaw(this.filterSpec, new ArrayList<ViewSpec>(), streamAsName, new StreamSpecOptions());
        } else if (node.getChild(0).getType() == 156) {
            if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
                throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
            }
            EvalFactoryNode evalNode = this.astPatternNodeMap.values().iterator().next();
            streamSpec = new PatternStreamSpecRaw(evalNode, this.evalNodeExpressions, this.viewSpecs, streamAsName, new StreamSpecOptions());
            if (this.evalNodeExpressions != null) {
                this.evalNodeExpressions = new HashMap<EvalFactoryNode, String>();
            }
            this.astPatternNodeMap.clear();
        } else {
            throw new IllegalStateException("Invalid AST type node, cannot map to stream specification");
        }
        this.statementSpec.getStreamSpecs().add((StreamSpecRaw)((Object)streamSpec));
    }

    private void leaveForClause(Tree node) {
        log.debug((Object)".leaveForClause");
        if (this.statementSpec.getForClauseSpec() == null) {
            this.statementSpec.setForClauseSpec(new ForClauseSpec());
        }
        String ident = node.getChild(0).getText();
        List<ExprNode> expressions = ASTUtil.getExprNodes(node, 1, this.astExprNodeMap);
        this.statementSpec.getForClauseSpec().getClauses().add(new ForClauseItemSpec(ident, expressions));
    }

    private void leaveMergeMatchedUnmatched(Tree node) {
        boolean matched;
        log.debug((Object)".leaveMergeMatchedUnmatched");
        boolean bl = matched = node.getType() == 272;
        if (this.mergeMatcheds == null) {
            this.mergeMatcheds = new ArrayList<OnTriggerMergeMatched>();
        }
        ExprNode filterSpec = null;
        if (node.getChildCount() > 0) {
            filterSpec = ASTUtil.getRemoveExpr(node.getChild(node.getChildCount() - 1), this.astExprNodeMap);
        }
        this.mergeMatcheds.add(new OnTriggerMergeMatched(matched, filterSpec, this.mergeActions));
        this.mergeActions = null;
    }

    private void leaveMergeDelClause(Tree node) {
        Tree whereCondNode;
        log.debug((Object)".leaveMergeDelClause");
        if (this.mergeActions == null) {
            this.mergeActions = new ArrayList<OnTriggerMergeAction>();
        }
        ExprNode whereCond = (whereCondNode = ASTUtil.findFirstNode(node, 158)) != null ? ASTUtil.getRemoveExpr(whereCondNode.getChild(0), this.astExprNodeMap) : null;
        this.mergeActions.add(new OnTriggerMergeActionDelete(whereCond));
    }

    private void leaveMergeUpdClause(Tree node) {
        Tree whereCondNode;
        log.debug((Object)".leaveMergeUpdClause");
        if (this.mergeActions == null) {
            this.mergeActions = new ArrayList<OnTriggerMergeAction>();
        }
        ExprNode whereCond = (whereCondNode = ASTUtil.findFirstNode(node, 158)) != null ? ASTUtil.getRemoveExpr(whereCondNode.getChild(0), this.astExprNodeMap) : null;
        List<OnTriggerSetAssignment> sets = EPLTreeWalker.getOnTriggerSetAssignments(node, this.astExprNodeMap);
        this.mergeActions.add(new OnTriggerMergeActionUpdate(whereCond, sets));
    }

    private void leaveMergeInsClause(Tree node) {
        log.debug((Object)".leaveMergeInsClause");
        Tree whereCondNode = ASTUtil.findFirstNode(node, 158);
        ExprNode whereCond = whereCondNode != null ? ASTUtil.getRemoveExpr(whereCondNode.getChild(0), this.astExprNodeMap) : null;
        ArrayList<SelectClauseElementRaw> expressions = new ArrayList<SelectClauseElementRaw>(this.statementSpec.getSelectClauseSpec().getSelectExprList());
        this.statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        Tree optInsertNameNode = ASTUtil.findFirstNode(node, 152);
        String optionalInsertName = optInsertNameNode != null ? optInsertNameNode.getText() : null;
        List<String> columsList = Collections.emptyList();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 197) continue;
            columsList = EPLTreeWalker.getIdentList(node.getChild(i));
        }
        if (this.mergeActions == null) {
            this.mergeActions = new ArrayList<OnTriggerMergeAction>();
        }
        this.mergeActions.add(new OnTriggerMergeActionInsert(whereCond, optionalInsertName, columsList, expressions));
    }

    private void leaveUpdateExpr(Tree node) {
        log.debug((Object)".leaveUpdateExpr");
        String eventTypeName = node.getChild(0).getText();
        FilterStreamSpecRaw streamSpec = new FilterStreamSpecRaw(new FilterSpecRaw(eventTypeName, Collections.<ExprNode>emptyList(), null), new ArrayList<ViewSpec>(), eventTypeName, new StreamSpecOptions());
        this.statementSpec.getStreamSpecs().add(streamSpec);
        String optionalStreamName = null;
        if (node.getChildCount() > 1 && node.getChild(1).getType() == 305) {
            optionalStreamName = node.getChild(1).getText();
        }
        List<OnTriggerSetAssignment> assignments = EPLTreeWalker.getOnTriggerSetAssignments(node, this.astExprNodeMap);
        ExprNode whereClause = this.getRemoveFirstByType(node, 158);
        this.statementSpec.setUpdateDesc(new UpdateDesc(optionalStreamName, assignments, whereClause));
    }

    protected static List<OnTriggerSetAssignment> getOnTriggerSetAssignments(Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>();
        if (node == null) {
            return assignments;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 266) continue;
            Tree childNode = node.getChild(i);
            String variableName = ASTFilterSpecHelper.getPropertyName(childNode.getChild(0), 0);
            ExprNode childEvalNode = astExprNodeMap.get(childNode.getChild(1));
            astExprNodeMap.remove(childNode.getChild(1));
            assignments.add(new OnTriggerSetAssignment(variableName, childEvalNode));
        }
        return assignments;
    }

    private UniformPair<String> getWindowName(Tree typeChildNode) {
        String windowName = null;
        String windowStreamName = null;
        for (int i = 0; i < typeChildNode.getChildCount(); ++i) {
            Tree child = typeChildNode.getChild(i);
            if (child.getType() != 246) continue;
            windowName = child.getChild(0).getText();
            if (child.getChildCount() <= 1) break;
            windowStreamName = child.getChild(1).getText();
            break;
        }
        if (windowName == null) {
            return null;
        }
        return new UniformPair<Object>(windowName, windowStreamName);
    }

    private void leavePrevious(Tree node) {
        PreviousType previousType;
        log.debug((Object)".leavePrevious");
        if (node.getType() == 69) {
            previousType = PreviousType.PREV;
        } else if (node.getType() == 70) {
            previousType = PreviousType.PREVTAIL;
        } else if (node.getType() == 72) {
            previousType = PreviousType.PREVWINDOW;
        } else if (node.getType() == 71) {
            previousType = PreviousType.PREVCOUNT;
        } else {
            throw new IllegalStateException("Failed to handle type '" + node.getType() + "'");
        }
        ExprPreviousNode previousNode = new ExprPreviousNode(previousType);
        this.astExprNodeMap.put(node, previousNode);
    }

    private void leavePrior(Tree node) {
        log.debug((Object)".leavePrior");
        ExprPriorNode priorNode = new ExprPriorNode();
        this.astExprNodeMap.put(node, priorNode);
    }

    private void leaveInstanceOf(Tree node) {
        log.debug((Object)".leaveInstanceOf");
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 1; i < node.getChildCount(); ++i) {
            Tree classIdent = node.getChild(i);
            classes.add(classIdent.getText());
        }
        String[] idents = classes.toArray(new String[classes.size()]);
        ExprInstanceofNode instanceofNode = new ExprInstanceofNode(idents);
        this.astExprNodeMap.put(node, instanceofNode);
    }

    private void leaveTypeOf(Tree node) {
        log.debug((Object)".leaveTypeOf");
        ExprTypeofNode typeofNode = new ExprTypeofNode();
        this.astExprNodeMap.put(node, typeofNode);
    }

    private void leaveExists(Tree node) {
        log.debug((Object)".leaveExists");
        ExprPropertyExistsNode instanceofNode = new ExprPropertyExistsNode();
        this.astExprNodeMap.put(node, instanceofNode);
    }

    private void leaveCast(Tree node) {
        log.debug((Object)".leaveCast");
        String classIdent = node.getChild(1).getText();
        ExprCastNode castNode = new ExprCastNode(classIdent);
        this.astExprNodeMap.put(node, castNode);
    }

    private void leaveTimestamp(Tree node) {
        log.debug((Object)".leaveTimestamp");
        ExprTimestampNode timeNode = new ExprTimestampNode();
        this.astExprNodeMap.put(node, timeNode);
    }

    private void leaveTimePeriod(Tree node) {
        log.debug((Object)".leaveTimePeriod");
        ExprTimePeriod timeNode = ASTUtil.getTimePeriodExpr(node, this.astExprNodeMap);
        this.astExprNodeMap.put(node, timeNode);
    }

    private void leaveNumberSetStar(Tree node) {
        log.debug((Object)".leaveNumberSetStar");
        ExprNumberSetWildcard exprNode = new ExprNumberSetWildcard();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveNumberSetFrequency(Tree node) {
        log.debug((Object)".leaveNumberSetFrequency");
        ExprNumberSetFrequency exprNode = new ExprNumberSetFrequency();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveNumberSetRange(Tree node) {
        log.debug((Object)".leaveNumberSetRange");
        ExprNumberSetRange exprNode = new ExprNumberSetRange();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveNumberSetList(Tree node) {
        log.debug((Object)".leaveNumberSetList");
        ExprNumberSetList exprNode = new ExprNumberSetList();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveLastNumberSetOperator(Tree node) {
        log.debug((Object)".leaveLastNumberSetOperator");
        ExprNumberSetCronParam exprNode = new ExprNumberSetCronParam(CronOperatorEnum.LASTDAY);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveLastWeekdayNumberSetOperator(Tree node) {
        log.debug((Object)".leaveLastWeekdayNumberSetOperator");
        ExprNumberSetCronParam exprNode = new ExprNumberSetCronParam(CronOperatorEnum.LASTWEEKDAY);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveWeekdayNumberSetOperator(Tree node) {
        log.debug((Object)".leaveWeekdayNumberSetOperator");
        ExprNumberSetCronParam exprNode = new ExprNumberSetCronParam(CronOperatorEnum.WEEKDAY);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveObjectParamOrderedExpression(Tree node) {
        log.debug((Object)".leaveObjectParamOrderedExpression");
        boolean isDescending = false;
        if (node.getChildCount() > 1 && node.getChild(1).getText().toUpperCase().equals("DESC")) {
            isDescending = true;
        }
        ExprOrderedExpr exprNode = new ExprOrderedExpr(isDescending);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveAnnotation(Tree node) {
        log.debug((Object)".leaveAnnotation");
        this.statementSpec.getAnnotations().add(ASTAnnotationHelper.walk(node, this.engineImportService));
    }

    private void leaveArray(Tree node) {
        log.debug((Object)".leaveArray");
        ExprArrayNode arrayNode = new ExprArrayNode();
        this.astExprNodeMap.put(node, arrayNode);
    }

    private void leaveSubselectRow(Tree node) {
        log.debug((Object)".leaveSubselectRow");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectRowNode subselectNode = new ExprSubselectRowNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private void leaveSubselectExists(Tree node) {
        log.debug((Object)".leaveSubselectExists");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectExistsNode subselectNode = new ExprSubselectExistsNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private void leaveSubselectIn(Tree node) {
        log.debug((Object)".leaveSubselectIn");
        Tree nodeSubquery = node.getChild(1);
        boolean isNot = false;
        if (node.getType() == 229) {
            isNot = true;
        }
        ExprSubselectInNode subqueryNode = (ExprSubselectInNode)this.astExprNodeMap.remove(nodeSubquery);
        subqueryNode.setNotIn(isNot);
        this.astExprNodeMap.put(node, subqueryNode);
    }

    private void leaveSubselectQueryIn(Tree node) {
        log.debug((Object)".leaveSubselectQueryIn");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectInNode subselectNode = new ExprSubselectInNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private StatementSpecRaw popStacks() {
        log.debug((Object)".popStacks");
        StatementSpecRaw currentSpec = this.statementSpec;
        this.statementSpec = this.statementSpecStack.pop();
        if (currentSpec.isHasVariables()) {
            this.statementSpec.setHasVariables(true);
        }
        if (currentSpec.getReferencedVariables() != null) {
            for (String var : currentSpec.getReferencedVariables()) {
                this.addVariable(this.statementSpec, var);
            }
        }
        this.astExprNodeMap = this.astExprNodeMapStack.pop();
        return currentSpec;
    }

    @Override
    protected void endPattern() throws ASTWalkException {
        log.debug((Object)".endPattern");
        if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
        }
        EvalFactoryNode evalNode = this.astPatternNodeMap.values().iterator().next();
        PatternStreamSpecRaw streamSpec = new PatternStreamSpecRaw(evalNode, this.evalNodeExpressions, new LinkedList<ViewSpec>(), null, new StreamSpecOptions());
        if (this.evalNodeExpressions != null) {
            this.evalNodeExpressions = new HashMap<EvalFactoryNode, String>();
        }
        this.statementSpec.getStreamSpecs().add(streamSpec);
        this.statementSpec.setSubstitutionParameters(this.substitutionParamNodes);
        this.astPatternNodeMap.clear();
    }

    @Override
    protected void end() throws ASTWalkException {
        log.debug((Object)".end");
        if (this.astExprNodeMap.size() > 1) {
            throw new ASTWalkException("Unexpected AST tree contains left over child elements, not all expression nodes have been removed from AST-to-expression nodes map");
        }
        if (this.astPatternNodeMap.size() > 1) {
            throw new ASTWalkException("Unexpected AST tree contains left over child elements, not all pattern nodes have been removed from AST-to-pattern nodes map");
        }
        this.statementSpec.setSubstitutionParameters(this.substitutionParamNodes);
    }

    private void leaveSelectionElement(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveSelectionElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseExprRawSpec(exprNode, optionalName));
    }

    private void leavePropertySelectionElement(Tree node) throws ASTWalkException {
        log.debug((Object)".leavePropertySelectionElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        if (this.propertySelectRaw == null) {
            this.propertySelectRaw = new ArrayList<SelectClauseElementRaw>();
        }
        this.propertySelectRaw.add(new SelectClauseExprRawSpec(exprNode, optionalName));
    }

    private void leavePropertySelectionStream(Tree node) throws ASTWalkException {
        log.debug((Object)".leavePropertySelectionStream");
        String streamName = node.getChild(0).getText();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        if (this.propertySelectRaw == null) {
            this.propertySelectRaw = new ArrayList<SelectClauseElementRaw>();
        }
        this.propertySelectRaw.add(new SelectClauseStreamRawSpec(streamName, optionalName));
    }

    private void leaveSelectionStream(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveSelectionStream");
        String streamName = node.getChild(0).getText();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseStreamRawSpec(streamName, optionalName));
    }

    private void leaveWildcardSelect() {
        log.debug((Object)".leaveWildcardSelect");
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
    }

    private void leavePropertyWildcardSelect() {
        log.debug((Object)".leavePropertyWildcardSelect");
        if (this.propertySelectRaw == null) {
            this.propertySelectRaw = new ArrayList<SelectClauseElementRaw>();
        }
        this.propertySelectRaw.add(new SelectClauseElementWildcard());
    }

    private void leavePropertySelectAtom(Tree node) {
        log.debug((Object)".leavePropertySelectAtom");
        if (this.propertyEvalSpec == null) {
            this.propertyEvalSpec = new PropertyEvalSpec();
        }
        SelectClauseSpecRaw optionalSelectClause = new SelectClauseSpecRaw();
        if (this.propertySelectRaw != null) {
            optionalSelectClause.getSelectExprList().addAll(this.propertySelectRaw);
            this.propertySelectRaw = null;
        }
        ExprNode optionalWhereClause = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 158) continue;
            optionalWhereClause = this.astExprNodeMap.remove(node.getChild(i).getChild(0));
        }
        String propertyName = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 182) continue;
            propertyName = ASTFilterSpecHelper.getPropertyName(node.getChild(i), 0);
        }
        String optionalAsName = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 305) continue;
            optionalAsName = node.getChild(i).getText();
        }
        PropertyEvalAtom atom = new PropertyEvalAtom(propertyName, optionalAsName, optionalSelectClause, optionalWhereClause);
        this.propertyEvalSpec.add(atom);
    }

    private void leaveView(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveView");
        String objectNamespace = node.getChild(0).getText();
        String objectName = node.getChild(1).getText();
        List<ExprNode> viewParameters = ASTUtil.getExprNodes(node, 2, this.astExprNodeMap);
        this.viewSpecs.add(new ViewSpec(objectNamespace, objectName, viewParameters));
    }

    private void leaveMatchRecognizeMeasureItem(Tree node) throws ASTWalkException {
        Tree currentNode;
        ExprNode exprNode;
        log.debug((Object)".leaveMatchRecognizeMeasureItem");
        if (this.statementSpec.getMatchRecognizeSpec() == null) {
            this.statementSpec.setMatchRecognizeSpec(new MatchRecognizeSpec());
        }
        if ((exprNode = this.astExprNodeMap.get(currentNode = node.getChild(0))) == null) {
            throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
        }
        this.astExprNodeMap.remove(currentNode);
        String name = null;
        if (node.getChildCount() > 1) {
            name = node.getChild(1).getText();
        }
        this.statementSpec.getMatchRecognizeSpec().addMeasureItem(new MatchRecognizeMeasureItem(exprNode, name));
    }

    private void leaveMatchRecognizePatternAtom(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveMatchRecognizePatternAtom");
        String first = node.getChild(0).getText();
        RegexNFATypeEnum type = RegexNFATypeEnum.SINGLE;
        if (node.getChildCount() > 2) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), node.getChild(2).getText());
        } else if (node.getChildCount() > 1) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), null);
        }
        RowRegexExprNodeAtom item = new RowRegexExprNodeAtom(first, type);
        this.astRowRegexNodeMap.put(node, item);
    }

    private void leaveMatchRecognizePatternAlter(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveMatchRecognizePatternAlter");
        RowRegexExprNodeAlteration alterNode = new RowRegexExprNodeAlteration();
        this.astRowRegexNodeMap.put(node, alterNode);
    }

    private void leaveMatchRecognizePatternConcat(Tree node) throws ASTWalkException {
        RowRegexExprNodeConcatenation concatNode = new RowRegexExprNodeConcatenation();
        this.astRowRegexNodeMap.put(node, concatNode);
    }

    private void leaveMatchRecognizePatternNested(Tree node) throws ASTWalkException {
        RegexNFATypeEnum type = RegexNFATypeEnum.SINGLE;
        if (node.getChildCount() > 2) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), node.getChild(2).getText());
        } else if (node.getChildCount() > 1) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), null);
        }
        RowRegexExprNodeNested nestedNode = new RowRegexExprNodeNested(type);
        this.astRowRegexNodeMap.put(node, nestedNode);
    }

    private void leaveMatchRecognizePattern(Tree node) throws ASTWalkException {
        Tree currentNode = node.getChild(0);
        RowRegexExprNode exprNode = this.astRowRegexNodeMap.get(currentNode);
        if (exprNode == null) {
            throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
        }
        this.astRowRegexNodeMap.remove(currentNode);
        this.statementSpec.getMatchRecognizeSpec().setPattern(exprNode);
    }

    private void leaveMatchRecognizeDefineItem(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveMatchRecognizeDefineItem");
        String first = node.getChild(0).getText();
        Tree currentNode = node.getChild(1);
        ExprNode exprNode = this.astExprNodeMap.get(currentNode);
        if (exprNode == null) {
            throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
        }
        this.astExprNodeMap.remove(currentNode);
        this.statementSpec.getMatchRecognizeSpec().getDefines().add(new MatchRecognizeDefineItem(first, exprNode));
    }

    private void leaveMatchRecognize(Tree node) throws ASTWalkException {
        int i;
        log.debug((Object)".leaveMatchRecognize");
        boolean allMatches = false;
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            if (node.getChild(i2).getType() != 47) continue;
            allMatches = true;
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 299) continue;
            MatchRecognizeSkipEnum skip = ASTMatchRecognizeHelper.parseSkip(node.getChild(i));
            this.statementSpec.getMatchRecognizeSpec().getSkip().setSkip(skip);
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            ExprTimePeriod timePeriodExpr;
            if (node.getChild(i).getType() != 300) continue;
            Tree intervalParent = node.getChild(i);
            if (!intervalParent.getChild(0).getText().toLowerCase().equals("interval")) {
                throw new ASTWalkException("Invalid interval-clause within match-recognize, expecting keyword INTERVAL");
            }
            ExprNode expression = this.astExprNodeMap.remove(intervalParent.getChild(1));
            try {
                ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(this.engineURI, false), null, null, this.timeProvider, this.variableService, this.exprEvaluatorContext, null, null, null, null, null);
                timePeriodExpr = (ExprTimePeriod)ExprNodeUtility.getValidatedSubtree(expression, validationContext);
            }
            catch (ExprValidationException ex) {
                throw new ASTWalkException("Invalid interval-clause within match-recognize: " + ex.getMessage(), ex);
            }
            this.statementSpec.getMatchRecognizeSpec().setInterval(new MatchRecognizeInterval(timePeriodExpr));
        }
        this.statementSpec.getMatchRecognizeSpec().setAllMatches(allMatches);
    }

    private void leaveOnSelect(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveOnSelect");
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 46) continue;
            this.statementSpec.getSelectClauseSpec().setDistinct(true);
        }
    }

    private void leaveMatchRecognizePartition(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveMatchRecognizePartition");
        if (this.statementSpec.getMatchRecognizeSpec() == null) {
            this.statementSpec.setMatchRecognizeSpec(new MatchRecognizeSpec());
        }
        this.statementSpec.getMatchRecognizeSpec().getPartitionByExpressions().addAll(ASTUtil.getExprNodes(node, 0, this.astExprNodeMap));
    }

    private void leaveStreamExpr(Tree node) {
        StreamSpecBase streamSpec;
        log.debug((Object)".leaveStreamExpr");
        Tree streamNameNode = null;
        for (int i = 1; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() != 305) continue;
            streamNameNode = child;
            break;
        }
        String streamName = null;
        if (streamNameNode != null) {
            streamName = streamNameNode.getText();
        }
        boolean isUnidirectional = false;
        boolean isRetainUnion = false;
        boolean isRetainIntersection = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() == 63) {
                isUnidirectional = true;
                break;
            }
            if (node.getChild(i).getType() == 64) {
                isRetainUnion = true;
                break;
            }
            if (node.getChild(i).getType() != 65) continue;
            isRetainIntersection = true;
            break;
        }
        StreamSpecOptions options = new StreamSpecOptions(isUnidirectional, isRetainUnion, isRetainIntersection);
        if (node.getChild(0).getType() == 138) {
            streamSpec = new FilterStreamSpecRaw(this.filterSpec, this.viewSpecs, streamName, options);
        } else if (node.getChild(0).getType() == 156) {
            if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
                throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
            }
            EvalFactoryNode evalNode = this.astPatternNodeMap.values().iterator().next();
            streamSpec = new PatternStreamSpecRaw(evalNode, this.evalNodeExpressions, this.viewSpecs, streamName, options);
            if (this.evalNodeExpressions != null) {
                this.evalNodeExpressions = new HashMap<EvalFactoryNode, String>();
            }
            this.astPatternNodeMap.clear();
        } else if (node.getChild(0).getType() == 157) {
            Tree dbrootNode = node.getChild(0);
            String dbName = dbrootNode.getChild(0).getText();
            String sqlWithParams = StringValue.parseString(dbrootNode.getChild(1).getText().trim());
            try {
                List<PlaceholderParser.Fragment> sqlFragments = PlaceholderParser.parsePlaceholder(sqlWithParams);
                for (PlaceholderParser.Fragment fragment : sqlFragments) {
                    List<ExprNode> listExp;
                    String expression;
                    if (!(fragment instanceof PlaceholderParser.ParameterFragment) || (expression = fragment.getValue()).toUpperCase().equals("$ESPER-SAMPLE-WHERE")) continue;
                    if (expression.trim().length() == 0) {
                        throw new ASTWalkException("Missing expression within ${...} in SQL statement");
                    }
                    String toCompile = "select * from java.lang.Object where " + expression;
                    StatementSpecRaw raw = EPAdministratorHelper.compileEPL(toCompile, expression, false, null, SelectClauseStreamSelectorEnum.ISTREAM_ONLY, this.engineImportService, this.variableService, this.schedulingService, this.engineURI, this.configurationInformation, this.patternNodeFactory, this.contextManagementService);
                    if (raw.getSubstitutionParameters() != null && raw.getSubstitutionParameters().size() > 0) {
                        throw new ASTWalkException("EPL substitution parameters are not allowed in SQL ${...} expressions, consider using a variable instead");
                    }
                    if (raw.isHasVariables()) {
                        this.statementSpec.setHasVariables(true);
                    }
                    if (this.statementSpec.getSqlParameters() == null) {
                        this.statementSpec.setSqlParameters(new HashMap<Integer, List<ExprNode>>());
                    }
                    if ((listExp = this.statementSpec.getSqlParameters().get(this.statementSpec.getStreamSpecs().size())) == null) {
                        listExp = new ArrayList<ExprNode>();
                        this.statementSpec.getSqlParameters().put(this.statementSpec.getStreamSpecs().size(), listExp);
                    }
                    listExp.add(raw.getFilterRootNode());
                }
            }
            catch (PlaceholderParseException ex) {
                log.warn((Object)("Failed to parse SQL text '" + sqlWithParams + "' :" + ex.getMessage()));
            }
            String sampleSQL = null;
            if (dbrootNode.getChildCount() > 2) {
                sampleSQL = dbrootNode.getChild(2).getText();
                sampleSQL = StringValue.parseString(sampleSQL.trim());
            }
            streamSpec = new DBStatementStreamSpec(streamName, this.viewSpecs, dbName, sqlWithParams, sampleSQL);
        } else if (node.getChild(0).getType() == 249) {
            String methodNamePart;
            String classNamePart;
            Tree methodRootNode = node.getChild(0);
            String prefixIdent = methodRootNode.getChild(0).getText();
            String className = methodRootNode.getChild(1).getText();
            int indexDot = className.lastIndexOf(46);
            if (indexDot == -1) {
                classNamePart = className;
                methodNamePart = null;
            } else {
                classNamePart = className.substring(0, indexDot);
                methodNamePart = className.substring(indexDot + 1);
            }
            List<ExprNode> exprNodes = ASTUtil.getExprNodes(methodRootNode, 2, this.astExprNodeMap);
            streamSpec = new MethodStreamSpec(streamName, this.viewSpecs, prefixIdent, classNamePart, methodNamePart, exprNodes);
        } else {
            throw new ASTWalkException("Unexpected AST child node to stream expression, type=" + node.getChild(0).getType());
        }
        this.viewSpecs.clear();
        this.statementSpec.getStreamSpecs().add((StreamSpecRaw)((Object)streamSpec));
    }

    private void leaveEventPropertyExpr(Tree node) {
        ExprNodeBase exprNode;
        String propertyName;
        log.debug((Object)".leaveEventPropertyExpr");
        if (node.getChildCount() == 0) {
            throw new IllegalStateException("Empty event property expression encountered");
        }
        if (node.getChildCount() == 1 || node.getChild(0).getType() != 183) {
            propertyName = ASTFilterSpecHelper.getPropertyName(node, 0);
            exprNode = new ExprIdentNodeImpl(propertyName);
        } else {
            String leadingIdentifier = node.getChild(0).getChild(0).getText();
            String streamOrNestedPropertyName = ASTFilterSpecHelper.escapeDot(leadingIdentifier);
            propertyName = ASTFilterSpecHelper.getPropertyName(node, 1);
            if (this.variableService.getReader(leadingIdentifier) != null) {
                exprNode = new ExprVariableNode(leadingIdentifier + "." + propertyName);
                this.statementSpec.setHasVariables(true);
                this.addVariable(this.statementSpec, propertyName);
            } else {
                exprNode = this.contextDescriptor != null && this.contextDescriptor.getContextPropertyRegistry().isContextPropertyPrefix(streamOrNestedPropertyName) ? new ExprContextPropertyNode(propertyName) : new ExprIdentNodeImpl(propertyName, streamOrNestedPropertyName);
            }
        }
        if (this.variableService.getReader(propertyName) != null) {
            exprNode = new ExprVariableNode(propertyName);
            this.statementSpec.setHasVariables(true);
            this.addVariable(this.statementSpec, propertyName);
        }
        this.astExprNodeMap.put(node, exprNode);
    }

    private void addVariable(StatementSpecRaw statementSpec, String propertyName) {
        if (statementSpec.getReferencedVariables() == null) {
            statementSpec.setReferencedVariables(new HashSet<String>());
        }
        statementSpec.getReferencedVariables().add(propertyName);
    }

    private void leaveLibFunctionOld(Tree parent, Tree node) {
        log.debug((Object)".leaveLibFunctionOld");
        String childNodeText = node.getChild(0).getText();
        if (node.getChild(0).getType() == 152) {
            String className = node.getChild(0).getText();
            List<ExprChainedSpec> chained = this.getLibFuncChain(parent);
            chained.add(0, new ExprChainedSpec(className, Collections.<ExprNode>emptyList(), true));
            this.astExprNodeMap.put(node, new ExprDotNode(chained, this.configurationInformation.getEngineDefaults().getExpression().isDuckTyping(), this.configurationInformation.getEngineDefaults().getExpression().isUdfCache()));
            return;
        }
        boolean isDistinct = false;
        if (node.getChild(1) != null && node.getChild(1).getType() == 46) {
            isDistinct = true;
        }
        try {
            Pair<Class, EngineImportSingleRowDesc> classMethodPair = this.engineImportService.resolveSingleRow(childNodeText);
            ArrayList<ExprChainedSpec> spec = new ArrayList<ExprChainedSpec>();
            List<ExprNode> childExpressions = EPLTreeWalker.getExprNodesLibFunc(0, node, this.astExprNodeMap);
            spec.add(new ExprChainedSpec(classMethodPair.getSecond().getMethodName(), childExpressions, true));
            this.astExprNodeMap.put(node, new ExprPlugInSingleRowNode(childNodeText, classMethodPair.getFirst(), spec, classMethodPair.getSecond().getValueCache()));
            return;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving single-row function: " + e.getMessage(), e);
        }
        try {
            AggregationSupport aggregation = this.engineImportService.resolveAggregation(childNodeText);
            this.astExprNodeMap.put(node, new ExprPlugInAggFunctionNode(isDistinct, aggregation, childNodeText));
            return;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving aggregation: " + e.getMessage(), e);
        }
        if (childNodeText.toLowerCase().equals("max") || childNodeText.toLowerCase().equals("min") || childNodeText.toLowerCase().equals("fmax") || childNodeText.toLowerCase().equals("fmin")) {
            this.handleMinMax(node);
            return;
        }
        ExprNode extentedBuiltIn = this.engineImportService.resolveAggExtendedBuiltin(childNodeText, isDistinct);
        if (extentedBuiltIn != null) {
            this.astExprNodeMap.put(node, extentedBuiltIn);
            return;
        }
        if (this.statementSpec.getExpressionDeclDesc() != null) {
            String name = node.getChild(0).getText();
            List<ExprChainedSpec> chained = this.getLibFuncChain(parent);
            for (ExpressionDeclItem declNode : this.statementSpec.getExpressionDeclDesc().getExpressions()) {
                if (!declNode.getName().equals(name)) continue;
                this.astExprNodeMap.put(node, new ExprDeclaredNodeImpl(declNode, chained.get(0).getParameters()));
                return;
            }
        }
        ArrayList<ExprChainedSpec> spec = new ArrayList<ExprChainedSpec>();
        List<ExprNode> childExpressions = EPLTreeWalker.getExprNodesLibFunc(0, node, this.astExprNodeMap);
        spec.add(new ExprChainedSpec(childNodeText, childExpressions, false));
        this.astExprNodeMap.put(node, new ExprDotNode(spec, false, false));
    }

    private void leaveDotExpr(Tree node) {
        log.debug((Object)".leaveDotExpr");
        List<ExprChainedSpec> chainSpec = this.getLibFuncChain(node);
        this.astExprNodeMap.put(node, new ExprDotNode(chainSpec, this.configurationInformation.getEngineDefaults().getExpression().isDuckTyping(), this.configurationInformation.getEngineDefaults().getExpression().isUdfCache()));
    }

    private void leaveLibFunctionChain(Tree node) {
        log.debug((Object)".leaveLibFunctionChain");
        if (node.getChildCount() == 1) {
            this.leaveLibFunctionOld(node, node.getChild(0));
            this.mapChildASTToChildExprNode(node.getChild(0));
            ExprNode generated = this.astExprNodeMap.remove(node.getChild(0));
            this.astExprNodeMap.put(node, generated);
            return;
        }
        String className = node.getChild(0).getChild(0).getText();
        List<ExprChainedSpec> chained = this.getLibFuncChain(node);
        try {
            Pair<Class, EngineImportSingleRowDesc> classMethodPair = this.engineImportService.resolveSingleRow(className);
            chained.get(0).setName(classMethodPair.getSecond().getMethodName());
            this.astExprNodeMap.put(node, new ExprPlugInSingleRowNode(className, classMethodPair.getFirst(), chained, classMethodPair.getSecond().getValueCache()));
            return;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving single-row function: " + e.getMessage(), e);
        }
        boolean duckType = this.configurationInformation.getEngineDefaults().getExpression().isDuckTyping();
        boolean udfCache = this.configurationInformation.getEngineDefaults().getExpression().isUdfCache();
        if (!className.equals(chained.get(0).getName())) {
            chained.add(0, new ExprChainedSpec(className, Collections.<ExprNode>emptyList(), true));
        }
        ExprDotNode dotNode = new ExprDotNode(chained, duckType, udfCache);
        if (this.statementSpec.getExpressionDeclDesc() != null) {
            String name = chained.get(0).getName();
            for (ExpressionDeclItem declNode : this.statementSpec.getExpressionDeclDesc().getExpressions()) {
                if (!declNode.getName().equals(name)) continue;
                dotNode.addChildNode(new ExprDeclaredNodeImpl(declNode, chained.get(0).getParameters()));
                chained.remove(0);
                break;
            }
        }
        this.astExprNodeMap.put(node, dotNode);
    }

    private void leaveEqualsExpr(Tree node) {
        log.debug((Object)".leaveEqualsExpr");
        boolean isNot = false;
        if (node.getType() == 164 || node.getType() == 166) {
            isNot = true;
        }
        boolean isIs = false;
        if (node.getType() == 165 || node.getType() == 166) {
            isIs = true;
        }
        ExprEqualsNodeImpl identNode = new ExprEqualsNodeImpl(isNot, isIs);
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveEqualsGroupExpr(Tree node) {
        log.debug((Object)".leaveEqualsGroupExpr");
        boolean isNot = false;
        if (node.getType() == 168) {
            isNot = true;
        }
        boolean isAll = false;
        if (node.getChild(1).getType() == 47) {
            isAll = true;
        }
        if (node.getChildCount() > 2 && node.getChild(2).getType() == 226) {
            StatementSpecRaw currentSpec = this.popStacks();
            ExprSubselectAllSomeAnyNode subselectNode = new ExprSubselectAllSomeAnyNode(currentSpec, isNot, isAll, null);
            this.astExprNodeMap.put(node, subselectNode);
        } else {
            ExprEqualsAllAnyNode groupNode = new ExprEqualsAllAnyNode(isNot, isAll);
            this.astExprNodeMap.put(node, groupNode);
        }
    }

    private void leaveJoinAndExpr(Tree node) {
        log.debug((Object)".leaveJoinAndExpr");
        ExprAndNodeImpl identNode = new ExprAndNodeImpl();
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveJoinOrExpr(Tree node) {
        log.debug((Object)".leaveJoinOrExpr");
        ExprOrNode identNode = new ExprOrNode();
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveConstant(Tree node) {
        log.debug((Object)(".leaveConstant value '" + node.getText() + "'"));
        ExprConstantNodeImpl constantNode = new ExprConstantNodeImpl(ASTConstantHelper.parse(node));
        this.astExprNodeMap.put(node, constantNode);
    }

    private void leaveSubstitution(Tree node) {
        log.debug((Object)".leaveSubstitution");
        int currentSize = this.substitutionParamNodes.size();
        ExprSubstitutionNode substitutionNode = new ExprSubstitutionNode(currentSize + 1);
        this.substitutionParamNodes.add(substitutionNode);
        this.astExprNodeMap.put(node, substitutionNode);
    }

    private void leaveMath(Tree node) {
        MathArithTypeEnum mathArithTypeEnum;
        log.debug((Object)".leaveMath");
        switch (node.getType()) {
            case 333: {
                mathArithTypeEnum = MathArithTypeEnum.DIVIDE;
                break;
            }
            case 316: {
                mathArithTypeEnum = MathArithTypeEnum.MULTIPLY;
                break;
            }
            case 318: {
                mathArithTypeEnum = MathArithTypeEnum.ADD;
                break;
            }
            case 332: {
                mathArithTypeEnum = MathArithTypeEnum.SUBTRACT;
                break;
            }
            case 334: {
                mathArithTypeEnum = MathArithTypeEnum.MODULO;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized math node type");
            }
        }
        ExprMathNode mathNode = new ExprMathNode(mathArithTypeEnum, this.configurationInformation.getEngineDefaults().getExpression().isIntegerDivision(), this.configurationInformation.getEngineDefaults().getExpression().isDivisionByZeroReturnsNull());
        this.astExprNodeMap.put(node, mathNode);
    }

    private void handleMinMax(Tree libNode) {
        MinMaxTypeEnum minMaxTypeEnum;
        log.debug((Object)".handleMinMax");
        Tree childNode = libNode.getChild(0);
        String childNodeText = childNode.getText().toLowerCase();
        boolean filtered = childNodeText.startsWith("f");
        if (childNodeText.equals("min") || childNodeText.equals("fmin")) {
            minMaxTypeEnum = MinMaxTypeEnum.MIN;
        } else if (childNodeText.equals("max") || childNodeText.equals("fmax")) {
            minMaxTypeEnum = MinMaxTypeEnum.MAX;
        } else {
            throw new IllegalArgumentException("Node type " + childNode.getType() + ' ' + childNode.getText() + " not a recognized min max node");
        }
        Tree nextNode = libNode.getChild(1);
        boolean isDistinct = false;
        if (nextNode.getType() == 46) {
            isDistinct = true;
        }
        if (libNode.getChildCount() > 4 && isDistinct && !filtered) {
            throw new ASTWalkException("The distinct keyword is not valid in per-row min and max functions with multiple sub-expressions");
        }
        ExprNodeBase minMaxNode = !isDistinct && libNode.getChildCount() > 3 && !filtered ? new ExprMinMaxRowNode(minMaxTypeEnum) : new ExprMinMaxAggrNode(isDistinct, minMaxTypeEnum, filtered);
        this.astExprNodeMap.put(libNode, minMaxNode);
    }

    private void leaveCoalesce(Tree node) {
        log.debug((Object)".leaveCoalesce");
        ExprCoalesceNode coalesceNode = new ExprCoalesceNode();
        this.astExprNodeMap.put(node, coalesceNode);
    }

    private void leaveAggregate(Tree node) {
        ExprAggregateNodeBase aggregateNode;
        log.debug((Object)".leaveAggregate");
        boolean isDistinct = false;
        if (node.getChild(0) != null && node.getChild(0).getType() == 46) {
            isDistinct = true;
        }
        boolean hasFilter = ASTUtil.findFirstNode(node, 277) != null;
        ExprNode childNode = null;
        switch (node.getType()) {
            case 19: {
                aggregateNode = new ExprAvgNode(isDistinct, hasFilter);
                break;
            }
            case 18: {
                aggregateNode = new ExprSumNode(isDistinct, hasFilter);
                break;
            }
            case 26: {
                aggregateNode = new ExprCountNode(isDistinct, hasFilter);
                break;
            }
            case 23: {
                aggregateNode = new ExprMedianNode(isDistinct, hasFilter);
                break;
            }
            case 24: {
                aggregateNode = new ExprStddevNode(isDistinct, hasFilter);
                break;
            }
            case 25: {
                aggregateNode = new ExprAvedevNode(isDistinct, hasFilter);
                break;
            }
            case 261: 
            case 262: 
            case 263: {
                boolean isWildcard = false;
                String streamWildcard = null;
                if (node.getChildCount() > 0 && node.getChild(0).getType() == 264) {
                    Tree wildcardNode = ASTUtil.findFirstNode(node.getChild(0), 143);
                    Tree streamWCNode = ASTUtil.findFirstNode(node.getChild(0), 142);
                    if (wildcardNode != null) {
                        isWildcard = true;
                    } else if (streamWCNode != null) {
                        streamWildcard = streamWCNode.getChild(0).getText();
                    } else {
                        childNode = this.astExprNodeMap.remove(node.getChild(0).getChild(0));
                    }
                } else {
                    isWildcard = true;
                }
                if (node.getType() == 261) {
                    aggregateNode = new ExprAccessAggNode(AggregationAccessType.FIRST, isWildcard, streamWildcard);
                    break;
                }
                if (node.getType() == 263) {
                    aggregateNode = new ExprAccessAggNode(AggregationAccessType.WINDOW, isWildcard, streamWildcard);
                    break;
                }
                aggregateNode = new ExprAccessAggNode(AggregationAccessType.LAST, isWildcard, streamWildcard);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized aggregate node type");
            }
        }
        if (childNode != null) {
            aggregateNode.addChildNode(childNode);
        }
        this.astExprNodeMap.put(node, aggregateNode);
    }

    private void postLeaveAggregate(Tree node) {
        Tree optionalFilterNode = ASTUtil.findFirstNode(node, 277);
        if (optionalFilterNode == null) {
            return;
        }
        ExprNode currentAggNode = this.astExprNodeMap.get(node);
        ExprNode filter = this.astExprNodeMap.remove(optionalFilterNode.getChild(0));
        currentAggNode.addChildNode(filter);
    }

    private void leaveRelationalOp(Tree node) {
        ExprNodeBase result;
        RelationalOpEnum relationalOpEnum;
        log.debug((Object)".leaveRelationalOp");
        switch (node.getType()) {
            case 327: {
                relationalOpEnum = RelationalOpEnum.LT;
                break;
            }
            case 328: {
                relationalOpEnum = RelationalOpEnum.GT;
                break;
            }
            case 329: {
                relationalOpEnum = RelationalOpEnum.LE;
                break;
            }
            case 330: {
                relationalOpEnum = RelationalOpEnum.GE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized relational op node type");
            }
        }
        boolean isAll = false;
        boolean isAny = false;
        if (node.getChild(1).getType() == 47) {
            isAll = true;
        }
        if (node.getChild(1).getType() == 48 || node.getChild(1).getType() == 49) {
            isAny = true;
        }
        if (isAll || isAny) {
            if (node.getChildCount() > 2 && node.getChild(2).getType() == 226) {
                StatementSpecRaw currentSpec = this.popStacks();
                result = new ExprSubselectAllSomeAnyNode(currentSpec, false, isAll, relationalOpEnum);
            } else {
                result = new ExprRelationalOpAllAnyNode(relationalOpEnum, isAll);
            }
        } else {
            result = new ExprRelationalOpNodeImpl(relationalOpEnum);
        }
        this.astExprNodeMap.put(node, result);
    }

    private void leaveBitWise(Tree node) {
        BitWiseOpEnum bitWiseOpEnum;
        log.debug((Object)".leaveBitWise");
        switch (node.getType()) {
            case 323: {
                bitWiseOpEnum = BitWiseOpEnum.BAND;
                break;
            }
            case 317: {
                bitWiseOpEnum = BitWiseOpEnum.BOR;
                break;
            }
            case 324: {
                bitWiseOpEnum = BitWiseOpEnum.BXOR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized bit wise node type");
            }
        }
        ExprBitWiseNode bwNode = new ExprBitWiseNode(bitWiseOpEnum);
        this.astExprNodeMap.put(node, bwNode);
    }

    private void leaveWhereClause() {
        log.debug((Object)".leaveWhereClause");
        if (this.astExprNodeMap.size() != 1) {
            throw new IllegalStateException("Where clause generated zero or more then one expression nodes");
        }
        this.statementSpec.setFilterRootNode(this.astExprNodeMap.values().iterator().next());
        this.astExprNodeMap.clear();
    }

    private void leaveHavingClause() {
        log.debug((Object)".leaveHavingClause");
        if (this.astExprNodeMap.size() != 1) {
            throw new IllegalStateException("Having clause generated zero or more then one expression nodes");
        }
        this.statementSpec.setHavingExprRootNode(this.astExprNodeMap.values().iterator().next());
        this.astExprNodeMap.clear();
    }

    private void leaveOutputLimit(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveOutputLimit");
        OutputLimitSpec spec = ASTOutputLimitHelper.buildOutputLimitSpec(node, this.astExprNodeMap, this.variableService, this.engineURI, this.timeProvider, this.exprEvaluatorContext);
        this.statementSpec.setOutputLimitSpec(spec);
        if (spec.getVariableName() != null) {
            this.statementSpec.setHasVariables(true);
            this.addVariable(this.statementSpec, spec.getVariableName());
        }
    }

    private void leaveRowLimit(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveRowLimit");
        RowLimitSpec spec = ASTOutputLimitHelper.buildRowLimitSpec(node);
        this.statementSpec.setRowLimitSpec(spec);
        if (spec.getNumRowsVariable() != null || spec.getOptionalOffsetVariable() != null) {
            this.statementSpec.setHasVariables(true);
            this.addVariable(this.statementSpec, spec.getOptionalOffsetVariable());
        }
    }

    private void leaveOuterInnerJoin(Tree node) {
        OuterJoinType joinType;
        log.debug((Object)".leaveOuterInnerJoin");
        switch (node.getType()) {
            case 176: {
                joinType = OuterJoinType.LEFT;
                break;
            }
            case 177: {
                joinType = OuterJoinType.RIGHT;
                break;
            }
            case 178: {
                joinType = OuterJoinType.FULL;
                break;
            }
            case 175: {
                joinType = OuterJoinType.INNER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized outer join node type");
            }
        }
        ExprIdentNode left = (ExprIdentNode)this.astExprNodeMap.get(node.getChild(0));
        ExprIdentNode right = (ExprIdentNode)this.astExprNodeMap.get(node.getChild(1));
        this.astExprNodeMap.remove(node.getChild(0));
        this.astExprNodeMap.remove(node.getChild(1));
        ExprIdentNode[] addLeftArr = null;
        ExprIdentNode[] addRightArr = null;
        if (node.getChildCount() > 2) {
            ArrayList<ExprIdentNode> addLeft = new ArrayList<ExprIdentNode>();
            ArrayList<ExprIdentNode> addRight = new ArrayList<ExprIdentNode>();
            for (int i = 2; i < node.getChildCount(); i += 2) {
                Tree child = node.getChild(i);
                addLeft.add((ExprIdentNode)this.astExprNodeMap.remove(child));
                addRight.add((ExprIdentNode)this.astExprNodeMap.remove(node.getChild(i + 1)));
            }
            addLeftArr = addLeft.toArray(new ExprIdentNode[addLeft.size()]);
            addRightArr = addRight.toArray(new ExprIdentNode[addRight.size()]);
        }
        OuterJoinDesc outerJoinDesc = new OuterJoinDesc(joinType, left, right, addLeftArr, addRightArr);
        this.statementSpec.getOuterJoinDescList().add(outerJoinDesc);
    }

    private void leaveGroupBy(Tree node) {
        log.debug((Object)".leaveGroupBy");
        if (this.astExprNodeMap.size() < 1) {
            throw new IllegalStateException("Group-by clause generated no expression nodes");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            ExprNode exprNode = this.astExprNodeMap.get(child);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node as a result of group-by child node not found in collection");
            }
            this.statementSpec.getGroupByExpressions().add(exprNode);
        }
        this.astExprNodeMap.clear();
    }

    private void leaveInsertInto(Tree node) {
        log.debug((Object)".leaveInsertInto");
        int count = 0;
        Tree child = node.getChild(count);
        boolean isIStream = true;
        if (child.getType() == 59) {
            isIStream = false;
            child = node.getChild(++count);
        }
        if (child.getType() == 60) {
            child = node.getChild(++count);
        }
        String eventTypeName = child.getText();
        InsertIntoDesc insertIntoDesc = new InsertIntoDesc(isIStream, eventTypeName);
        if ((child = node.getChild(++count)) != null && child.getType() == 197) {
            for (int i = 0; i < child.getChildCount(); ++i) {
                Tree childNode = child.getChild(i);
                insertIntoDesc.add(childNode.getText());
            }
        }
        this.statementSpec.setInsertIntoDesc(insertIntoDesc);
    }

    private void leaveOrderByElement(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveOrderByElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        boolean descending = false;
        if (node.getChildCount() > 1) {
            descending = node.getChild(1).getType() == 58;
        }
        this.statementSpec.getOrderByList().add(new OrderByItem(exprNode, descending));
    }

    private void leaveConcat(Tree node) {
        ExprConcatNode concatNode = new ExprConcatNode();
        this.astExprNodeMap.put(node, concatNode);
    }

    private void leaveEvery(Tree node) {
        log.debug((Object)".leaveEvery");
        EvalFactoryNode everyNode = this.patternNodeFactory.makeEveryNode();
        this.addEvalNodeExpression(everyNode, node);
    }

    private void leaveEveryDistinct(Tree node) {
        log.debug((Object)".leaveEveryDistinct");
        List<ExprNode> exprNodes = ASTUtil.getExprNodes(node.getChild(0), 0, this.astExprNodeMap);
        EvalFactoryNode everyNode = this.patternNodeFactory.makeEveryDistinctNode(exprNodes);
        this.addEvalNodeExpression(everyNode, node);
    }

    private void leaveStreamFilter(Tree node) {
        log.debug((Object)".leaveStreamFilter");
        this.filterSpec = ASTUtil.walkFilterSpec(node, this.propertyEvalSpec, this.astExprNodeMap);
        this.propertyEvalSpec = null;
        this.astExprNodeMap.clear();
    }

    private void leavePatternFilter(Tree node) {
        log.debug((Object)".leavePatternFilter");
        int count = 0;
        Tree startNode = node.getChild(0);
        String optionalPatternTagName = null;
        if (startNode.getType() == 305) {
            optionalPatternTagName = startNode.getText();
            startNode = node.getChild(++count);
        }
        String eventName = startNode.getText();
        if (node.getChildCount() > ++count && node.getChild(count).getType() == 139) {
            ++count;
        }
        Integer consumption = null;
        if (node.getChildCount() > count && node.getChild(count).getType() == 339) {
            Tree filterConsumeAnno = node.getChild(count);
            String name = filterConsumeAnno.getChild(0).getText();
            if (!name.toUpperCase().equals("CONSUME")) {
                throw new EPException("Unexpected pattern filter @ annotation, expecting 'consume' but received '" + name + "'");
            }
            Object number = filterConsumeAnno.getChildCount() < 2 ? null : ASTConstantHelper.parse(filterConsumeAnno.getChild(1));
            consumption = number != null ? Integer.valueOf(((Number)number).intValue()) : Integer.valueOf(1);
            ++count;
        }
        List<ExprNode> exprNodes = ASTUtil.getExprNodes(node, count, this.astExprNodeMap);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, exprNodes, this.propertyEvalSpec);
        this.propertyEvalSpec = null;
        EvalFactoryNode filterNode = this.patternNodeFactory.makeFilterNode(rawFilterSpec, optionalPatternTagName, consumption);
        this.addEvalNodeExpression(filterNode, node);
    }

    private void leaveFollowedBy(Tree node) {
        log.debug((Object)".leaveFollowedBy");
        ExprNode[] maxExpressions = new ExprNode[node.getChildCount() - 1];
        ArrayList<EvalFactoryNode> childNodes = new ArrayList<EvalFactoryNode>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() != 134) {
                throw new ASTWalkException("Unexpected child node for followed-by item");
            }
            if (i == 0) {
                childNodes.add(this.astPatternNodeMap.remove(child.getChild(0)));
                continue;
            }
            int current = 0;
            if (child.getChildCount() == 2) {
                maxExpressions[i - 1] = this.astExprNodeMap.remove(child.getChild(current));
                ++current;
            }
            childNodes.add(this.astPatternNodeMap.remove(child.getChild(current)));
        }
        List<ExprNode> expressions = Collections.emptyList();
        if (!CollectionUtil.isAllNullArray(maxExpressions)) {
            expressions = Arrays.asList(maxExpressions);
        }
        EvalFactoryNode fbNode = this.patternNodeFactory.makeFollowedByNode(expressions, this.configurationInformation.getEngineDefaults().getPatterns().getMaxSubexpressions() != null);
        fbNode.addChildNodes(childNodes);
        this.addEvalNodeExpression(fbNode, node);
    }

    private void addEvalNodeExpression(EvalFactoryNode evalNode, Tree node) {
        this.astPatternNodeMap.put(node, evalNode);
        if (this.evalNodeExpressions == null) {
            this.evalNodeExpressions = new HashMap<EvalFactoryNode, String>();
        }
        this.evalNodeExpressions.put(evalNode, ASTUtil.getExpressionText(this.tokenStream, node));
    }

    private void leaveAnd(Tree node) {
        log.debug((Object)".leaveAnd");
        EvalFactoryNode andNode = this.patternNodeFactory.makeAndNode();
        this.addEvalNodeExpression(andNode, node);
    }

    private void leaveOr(Tree node) {
        log.debug((Object)".leaveOr");
        EvalFactoryNode orNode = this.patternNodeFactory.makeOrNode();
        this.addEvalNodeExpression(orNode, node);
    }

    private void leaveInSet(Tree node) {
        log.debug((Object)".leaveInSet");
        ExprInNodeImpl inNode = new ExprInNodeImpl(node.getType() == 214);
        this.astExprNodeMap.put(node, inNode);
    }

    private void leaveInRange(Tree node) {
        log.debug((Object)".leaveInRange");
        Tree bracesNode = node.getChild(1);
        if (bracesNode.getType() != 314 && bracesNode.getType() != 308) {
            throw new IllegalStateException("Invalid in-range syntax, no braces but type '" + bracesNode.getType() + "'");
        }
        boolean isLowInclude = bracesNode.getType() == 314;
        bracesNode = node.getChild(4);
        if (bracesNode.getType() != 315 && bracesNode.getType() != 309) {
            throw new IllegalStateException("Invalid in-range syntax, no braces but type '" + bracesNode.getType() + "'");
        }
        boolean isHighInclude = bracesNode.getType() == 315;
        ExprBetweenNodeImpl betweenNode = new ExprBetweenNodeImpl(isLowInclude, isHighInclude, node.getType() == 224);
        this.astExprNodeMap.put(node, betweenNode);
    }

    private void leaveBetween(Tree node) {
        log.debug((Object)".leaveBetween");
        ExprBetweenNodeImpl betweenNode = new ExprBetweenNodeImpl(true, true, node.getType() == 215);
        this.astExprNodeMap.put(node, betweenNode);
    }

    private void leaveLike(Tree node) {
        log.debug((Object)".leaveLike");
        boolean isNot = node.getType() == 216;
        ExprLikeNode likeNode = new ExprLikeNode(isNot);
        this.astExprNodeMap.put(node, likeNode);
    }

    private void leaveRegexp(Tree node) {
        log.debug((Object)".leaveRegexp");
        boolean isNot = node.getType() == 217;
        ExprRegexpNode regExpNode = new ExprRegexpNode(isNot);
        this.astExprNodeMap.put(node, regExpNode);
    }

    private void leaveExprNot(Tree node) {
        log.debug((Object)".leaveExprNot");
        ExprNotNode notNode = new ExprNotNode();
        this.astExprNodeMap.put(node, notNode);
    }

    private void leavePatternNot(Tree node) {
        log.debug((Object)".leavePatternNot");
        EvalFactoryNode notNode = this.patternNodeFactory.makeNotNode();
        this.addEvalNodeExpression(notNode, node);
    }

    private void leaveGuard(Tree node) throws ASTWalkException {
        List<ExprNode> obsParameters;
        String objectName;
        String objectNamespace;
        log.debug((Object)".leaveGuard");
        if (node.getChild(1).getType() == 305 && node.getChild(2).getType() == 305) {
            objectNamespace = node.getChild(1).getText();
            objectName = node.getChild(2).getText();
            obsParameters = ASTUtil.getExprNodes(node, 3, this.astExprNodeMap);
        } else {
            objectNamespace = GuardEnum.WHILE_GUARD.getNamespace();
            objectName = GuardEnum.WHILE_GUARD.getName();
            obsParameters = ASTUtil.getExprNodes(node, 1, this.astExprNodeMap);
        }
        PatternGuardSpec guardSpec = new PatternGuardSpec(objectNamespace, objectName, obsParameters);
        EvalFactoryNode guardNode = this.patternNodeFactory.makeGuardNode(guardSpec);
        this.addEvalNodeExpression(guardNode, node);
    }

    private void leaveCaseNode(Tree node, boolean inCase2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(".leaveCase2Node inCase2=" + inCase2));
        }
        if (this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero child element for case node");
        }
        if (this.astExprNodeMap.size() == 1) {
            throw new ASTWalkException("AST tree doesn not contain at least when node for case node");
        }
        ExprCaseNode caseNode = new ExprCaseNode(inCase2);
        this.astExprNodeMap.put(node, caseNode);
    }

    private void leaveExpressionDecl(Tree node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)".leaveExpressionEval");
        }
        String name = node.getChild(0).getText();
        ExprNode inner = ASTUtil.getRemoveExpr(node.getChild(1), this.astExprNodeMap);
        List<String> parametersNames = Collections.emptyList();
        if (node.getChildCount() > 2 && node.getChild(2).getType() == 310) {
            Tree paramParent = node.getChild(2);
            parametersNames = paramParent.getChild(0).getType() == 197 ? EPLTreeWalker.getIdentList(paramParent.getChild(0)) : Collections.singletonList(paramParent.getChild(0).getText());
        }
        ExpressionDeclItem declNode = new ExpressionDeclItem(name, parametersNames, inner);
        if (this.statementSpec.getExpressionDeclDesc() == null) {
            this.statementSpec.setExpressionDeclDesc(new ExpressionDeclDesc());
        }
        this.statementSpec.getExpressionDeclDesc().getExpressions().add(declNode);
    }

    private void leaveNewKeyword(Tree node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)".leaveNewKeyword");
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ExprIdentNodeImpl> expressions = new ArrayList<ExprIdentNodeImpl>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() != 276) {
                throw new IllegalStateException("Expected new-item node not found");
            }
            String property = ASTFilterSpecHelper.getPropertyName(child.getChild(0), 0);
            columnNames.add(property);
            ExprNode expr = child.getChildCount() > 1 ? this.astExprNodeMap.remove(child.getChild(1)) : new ExprIdentNodeImpl(property);
            expressions.add((ExprIdentNodeImpl)expr);
        }
        String[] columns = columnNames.toArray(new String[columnNames.size()]);
        ExprNewNode newNode = new ExprNewNode(columns);
        newNode.getChildNodes().addAll(expressions);
        this.astExprNodeMap.put(node, newNode);
    }

    private void leaveContext(Tree node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)".leaveContext");
        }
        String contextName = node.getChild(0).getText();
        this.statementSpec.setOptionalContextName(contextName);
        this.contextDescriptor = this.contextManagementService.getContextDescriptor(contextName);
    }

    private void leaveCreateContext(Tree node) {
        ContextDetail contextDetail;
        if (log.isDebugEnabled()) {
            log.debug((Object)".leaveCreateContext");
        }
        String contextName = node.getChild(0).getText();
        Tree detailParent = node.getChild(1);
        if (detailParent.getType() == 279) {
            List<ExprNode> crontabStart = ASTUtil.getRemoveAllChildExpr(detailParent.getChild(0), this.astExprNodeMap);
            List<ExprNode> crontabEnd = ASTUtil.getRemoveAllChildExpr(detailParent.getChild(1), this.astExprNodeMap);
            contextDetail = new ContextDetailTemporalFixed(crontabStart, crontabEnd);
        } else if (detailParent.getType() == 281) {
            ArrayList<ContextDetailCategoryItem> items = new ArrayList<ContextDetailCategoryItem>();
            for (int i = 0; i < detailParent.getChildCount() - 1; ++i) {
                Tree categoryParent = detailParent.getChild(i);
                ExprNode exprNode = this.astExprNodeMap.remove(categoryParent.getChild(0));
                String name = categoryParent.getChild(1).getText();
                items.add(new ContextDetailCategoryItem(exprNode, name));
            }
            this.filterSpec = ASTUtil.walkFilterSpec(detailParent.getChild(detailParent.getChildCount() - 1), this.propertyEvalSpec, this.astExprNodeMap);
            contextDetail = new ContextDetailCategory(items, this.filterSpec);
        } else if (detailParent.getType() == 280) {
            ArrayList<ContextDetailPartitionItem> rawSpecs = new ArrayList<ContextDetailPartitionItem>();
            for (int i = 0; i < detailParent.getChildCount(); ++i) {
                Tree partitionParent = detailParent.getChild(i);
                this.filterSpec = ASTUtil.walkFilterSpec(partitionParent.getChild(0), this.propertyEvalSpec, this.astExprNodeMap);
                this.propertyEvalSpec = null;
                ArrayList<String> propertyNames = new ArrayList<String>();
                for (int j = 1; j < partitionParent.getChildCount(); ++j) {
                    String propertyName = ASTFilterSpecHelper.getPropertyName(partitionParent.getChild(j), 0);
                    propertyNames.add(propertyName);
                }
                rawSpecs.add(new ContextDetailPartitionItem(this.filterSpec, propertyNames));
            }
            contextDetail = new ContextDetailPartitioned(rawSpecs);
        } else if (detailParent.getType() == 282) {
            FilterSpecRaw filterSpecRaw;
            String asName;
            EvalFactoryNode evalNode;
            if (detailParent.getChild(0).getType() == 156) {
                evalNode = this.astPatternNodeMap.values().iterator().next();
                this.astPatternNodeMap.clear();
                asName = null;
                filterSpecRaw = null;
            } else {
                evalNode = null;
                filterSpecRaw = ASTUtil.walkFilterSpec(detailParent.getChild(0).getChild(0), this.propertyEvalSpec, this.astExprNodeMap);
                asName = detailParent.getChild(0).getChild(1).getText();
            }
            ExprTimePeriod timePeriod = (ExprTimePeriod)this.astExprNodeMap.remove(detailParent.getChild(1));
            contextDetail = new ContextDetailInitiatedTerminated(evalNode, filterSpecRaw, asName, timePeriod);
        } else {
            throw new IllegalStateException("Unrecognized context detail type '" + detailParent.getType() + "'");
        }
        CreateContextDesc contextDesc = new CreateContextDesc(contextName, contextDetail);
        this.statementSpec.setCreateContextDesc(contextDesc);
    }

    private void leaveObserver(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveObserver");
        String objectNamespace = node.getChild(0).getText();
        String objectName = node.getChild(1).getText();
        List<ExprNode> obsParameters = ASTUtil.getExprNodes(node, 2, this.astExprNodeMap);
        PatternObserverSpec observerSpec = new PatternObserverSpec(objectNamespace, objectName, obsParameters);
        EvalFactoryNode observerNode = this.patternNodeFactory.makeObserverNode(observerSpec);
        this.addEvalNodeExpression(observerNode, node);
    }

    private void leaveMatch(Tree node) throws ASTWalkException {
        log.debug((Object)".leaveMatch");
        boolean hasRange = true;
        int type = node.getChild(0).getType();
        ExprNode low = null;
        ExprNode high = null;
        boolean allowZeroLowerBounds = false;
        if (type == 251) {
            low = this.astExprNodeMap.remove(node.getChild(0).getChild(0));
        } else if (type == 252) {
            high = this.astExprNodeMap.remove(node.getChild(0).getChild(0));
        } else if (type == 254) {
            high = low = this.astExprNodeMap.remove(node.getChild(0).getChild(0));
        } else if (type == 253) {
            low = this.astExprNodeMap.remove(node.getChild(0).getChild(0));
            high = this.astExprNodeMap.remove(node.getChild(0).getChild(1));
            allowZeroLowerBounds = true;
        } else {
            hasRange = false;
        }
        boolean tightlyBound = ASTMatchUntilHelper.validate(low, high, allowZeroLowerBounds);
        if (node.getChildCount() == 2 && hasRange && !tightlyBound) {
            throw new ASTWalkException("Variable bounds repeat operator requires an until-expression");
        }
        EvalFactoryNode fbNode = this.patternNodeFactory.makeMatchUntilNode(low, high);
        this.addEvalNodeExpression(fbNode, node);
    }

    private void leaveSelectClause(Tree node) {
        log.debug((Object)".leaveSelectClause");
        int nodeType = node.getChild(0).getType();
        if (nodeType == 59) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ONLY);
        }
        if (nodeType == 60) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        }
        if (nodeType == 61) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        }
        boolean isDistinct = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 46) continue;
            isDistinct = true;
        }
        this.statementSpec.getSelectClauseSpec().setDistinct(isDistinct);
    }

    private ExprNode getRemoveFirstByType(Tree parent, int type) {
        ExprNode exprNode = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i).getType() != type) continue;
            exprNode = this.astExprNodeMap.get(parent.getChild(i).getChild(0));
            if (exprNode == null) {
                throw new IllegalStateException("Expression node for AST node not found for type " + parent.getChild(i).getType() + " and text " + parent.getChild(i).getText());
            }
            this.astExprNodeMap.remove(parent.getChild(i));
        }
        return exprNode;
    }

    private boolean isSelectInsertFirst(Tree child) {
        for (int i = 0; i < child.getChildCount(); ++i) {
            if (child.getChild(i).getType() != 245 || child.getChild(i).getChild(0).getType() != 47) continue;
            return false;
        }
        return true;
    }

    private List<ExprChainedSpec> getLibFuncChain(Tree parent) {
        ArrayList<ExprChainedSpec> chained = new ArrayList<ExprChainedSpec>();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Tree chainElement = parent.getChild(i);
            if (chainElement.getType() != 200) continue;
            int count = 0;
            if (chainElement.getChild(0).getType() == 152) {
                ++count;
            }
            String methodName = ASTConstantHelper.removeTicks(chainElement.getChild(count).getText());
            List<ExprNode> parameters = EPLTreeWalker.getExprNodesLibFunc(++count, chainElement, this.astExprNodeMap);
            boolean isProperty = chainElement.getChildCount() > 0 && chainElement.getChild(chainElement.getChildCount() - 1).getType() != 308;
            chained.add(new ExprChainedSpec(methodName, parameters, isProperty));
        }
        return chained;
    }

    private static ExprLambdaGoesNode getLambdaGoes(Tree child) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (child.getChild(0).getType() == 305) {
            parameters.add(child.getChild(0).getText());
        } else {
            parameters = EPLTreeWalker.getIdentList(child.getChild(0));
        }
        return new ExprLambdaGoesNode(parameters);
    }

    private static List<String> getIdentList(Tree node) {
        ArrayList<String> columsList = new ArrayList<String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 305) continue;
            columsList.add(node.getChild(i).getText());
        }
        return columsList;
    }

    private static List<ExprNode> getExprNodesLibFunc(int start, Tree parent, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<ExprNode> parameters = new ArrayList<ExprNode>();
        for (int exprNum = start; exprNum < parent.getChildCount(); ++exprNum) {
            if (parent.getChild(exprNum).getType() == 310) {
                ExprLambdaGoesNode goes = EPLTreeWalker.getLambdaGoes(parent.getChild(exprNum));
                ExprNode lambdaExpr = astExprNodeMap.remove(parent.getChild(++exprNum));
                goes.addChildNode(lambdaExpr);
                parameters.add(goes);
                continue;
            }
            ExprNode parameter = astExprNodeMap.remove(parent.getChild(exprNum));
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }
}

