/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.epl.parse.ParseResult;
import com.espertech.esper.epl.parse.ParseRuleSelector;
import com.espertech.esper.epl.parse.WalkRuleSelector;
import java.io.IOException;
import java.io.StringReader;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParseHelper {
    public static final String newline = System.getProperty("line.separator");
    private static Log log = LogFactory.getLog(ParseHelper.class);

    public static void walk(Tree ast, EPLTreeWalker walker, WalkRuleSelector walkRuleSelector, String expression, String eplStatementForErrorMsg) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(".walk Walking AST using walker " + ((Object)((Object)walker)).getClass().getName()));
            }
            walkRuleSelector.invokeWalkRule(walker);
            if (log.isDebugEnabled()) {
                log.debug((Object)".walk AST tree after walking");
                ASTUtil.dumpAST(ast);
            }
        }
        catch (RuntimeException e) {
            log.info((Object)("Error walking statement [" + expression + "]"), (Throwable)e);
            if (e.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convert((RecognitionException)e.getCause(), eplStatementForErrorMsg, walker);
            }
            throw e;
        }
        catch (RecognitionException e) {
            log.info((Object)("Error walking statement [" + expression + "]"), (Throwable)e);
            throw ExceptionConvertor.convert(e, eplStatementForErrorMsg, walker);
        }
    }

    public static ParseResult parse(String expression, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector) throws EPException {
        Tree tree;
        NoCaseSensitiveStream input;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".parse Parsing expr=" + expression));
        }
        try {
            input = new NoCaseSensitiveStream(new StringReader(expression));
        }
        catch (IOException ex) {
            throw new EPException("IOException parsing expression '" + expression + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        EsperEPL2GrammarParser parser = new EsperEPL2GrammarParser((TokenStream)tokens);
        try {
            tree = parseRuleSelector.invokeParseRule(parser);
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error parsing statement [" + eplStatementErrorMsg + "]"), (Throwable)e);
            }
            if (e.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convertStatement((RecognitionException)e.getCause(), eplStatementErrorMsg, addPleaseCheck, parser);
            }
            throw e;
        }
        catch (RecognitionException ex) {
            log.debug((Object)("Error parsing statement [" + expression + "]"), (Throwable)ex);
            throw ExceptionConvertor.convertStatement(ex, eplStatementErrorMsg, addPleaseCheck, parser);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)".parse Dumping AST...");
            ASTUtil.dumpAST(tree);
        }
        return new ParseResult(tree, ParseHelper.getNoAnnotation(expression, tree, tokens), tokens);
    }

    private static String getNoAnnotation(String expression, Tree tree, CommonTokenStream tokens) {
        Token lastAnnotationToken = null;
        for (int i = 0; i < tree.getChildCount() && tree.getChild(i).getType() == 258; ++i) {
            lastAnnotationToken = tokens.get(tree.getChild(i).getTokenStopIndex());
        }
        if (lastAnnotationToken == null) {
            return null;
        }
        try {
            int line = lastAnnotationToken.getLine();
            int charpos = lastAnnotationToken.getCharPositionInLine();
            int fromChar = charpos + lastAnnotationToken.getText().length();
            if (line == 1) {
                return expression.substring(fromChar).trim();
            }
            String[] lines = expression.split("\r\n|\r|\n");
            StringBuilder buf = new StringBuilder();
            buf.append(lines[line - 1].substring(fromChar));
            for (int i = line; i < lines.length; ++i) {
                buf.append(lines[i]);
                if (i >= lines.length - 1) continue;
                buf.append(newline);
            }
            return buf.toString().trim();
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error determining non-annotated expression sting: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }
}

