/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyEvaluatorAccumulative {
    private static final Log log = LogFactory.getLog(PropertyEvaluatorAccumulative.class);
    private final EventPropertyGetter[] getter;
    private final FragmentEventType[] fragmentEventType;
    private final ExprEvaluator[] whereClauses;
    private final EventBean[] eventsPerStream;
    private final int lastLevel;
    private final int levels;
    private final List<String> propertyNames;

    public PropertyEvaluatorAccumulative(EventPropertyGetter[] getter, FragmentEventType[] fragmentEventType, ExprEvaluator[] whereClauses, List<String> propertyNames) {
        this.fragmentEventType = fragmentEventType;
        this.getter = getter;
        this.whereClauses = whereClauses;
        this.lastLevel = fragmentEventType.length - 1;
        this.levels = fragmentEventType.length + 1;
        this.eventsPerStream = new EventBean[this.levels];
        this.propertyNames = propertyNames;
    }

    public ArrayDeque<EventBean[]> getAccumulative(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDeque<EventBean[]> resultEvents = new ArrayDeque<EventBean[]>();
        this.eventsPerStream[0] = event;
        this.populateEvents(event, 0, resultEvents, exprEvaluatorContext);
        if (resultEvents.isEmpty()) {
            return null;
        }
        return resultEvents;
    }

    private void populateEvents(EventBean branch, int level, Collection<EventBean[]> events, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.getter[level].getFragment(branch);
            if (this.fragmentEventType[level].isIndexed()) {
                EventBean[] fragments = (EventBean[])result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        EventBean[] arr$ = fragments;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            EventBean event;
                            this.eventsPerStream[level + 1] = event = arr$[i$];
                            if (!ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                            EventBean[] eventsPerRow = new EventBean[this.levels];
                            System.arraycopy(this.eventsPerStream, 0, eventsPerRow, 0, this.levels);
                            events.add(eventsPerRow);
                        }
                    } else {
                        EventBean[] arr$ = fragments;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            EventBean event;
                            this.eventsPerStream[level + 1] = event = arr$[i$];
                            EventBean[] eventsPerRow = new EventBean[this.levels];
                            System.arraycopy(this.eventsPerStream, 0, eventsPerRow, 0, this.levels);
                            events.add(eventsPerRow);
                        }
                    }
                } else if (this.whereClauses[level] != null) {
                    EventBean[] arr$ = fragments;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = arr$[i$];
                        if (!ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    EventBean[] arr$ = fragments;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = arr$[i$];
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                }
            } else {
                EventBean fragment = (EventBean)result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        this.eventsPerStream[level + 1] = fragment;
                        if (ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                            EventBean[] eventsPerRow = new EventBean[this.levels];
                            System.arraycopy(this.eventsPerStream, 0, eventsPerRow, 0, this.levels);
                            events.add(eventsPerRow);
                        }
                    } else {
                        this.eventsPerStream[level + 1] = fragment;
                        EventBean[] eventsPerRow = new EventBean[this.levels];
                        System.arraycopy(this.eventsPerStream, 0, eventsPerRow, 0, this.levels);
                        events.add(eventsPerRow);
                    }
                } else if (this.whereClauses[level] != null) {
                    this.eventsPerStream[level + 1] = fragment;
                    if (ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                        this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    this.eventsPerStream[level + 1] = fragment;
                    this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)("Unexpected error evaluating property expression for event of type '" + branch.getEventType().getName() + "' and property '" + this.propertyNames.get(level + 1) + "': " + ex.getMessage()), (Throwable)ex);
        }
    }
}

