/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContextTimeOnly;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.epl.property.PropertyEvaluatorAccumulative;
import com.espertech.esper.epl.property.PropertyEvaluatorNested;
import com.espertech.esper.epl.property.PropertyEvaluatorSelect;
import com.espertech.esper.epl.property.PropertyEvaluatorSimple;
import com.espertech.esper.epl.spec.PropertyEvalAtom;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.UuidGenerator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class PropertyEvaluatorFactory {
    public static PropertyEvaluator makeEvaluator(PropertyEvalSpec spec, EventType sourceEventType, String optionalSourceStreamName, EventAdapterService eventAdapterService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService, String engineURI, String statementId, String statementName, Annotation[] annotations, Collection<Integer> assignedTypeNumberStack) throws ExprValidationException {
        int length = spec.getAtoms().size();
        EventPropertyGetter[] getters = new EventPropertyGetter[length];
        FragmentEventType[] types = new FragmentEventType[length];
        EventType currentEventType = sourceEventType;
        ExprEvaluator[] whereClauses = new ExprEvaluator[length];
        ArrayList<EventType> streamEventTypes = new ArrayList<EventType>();
        ArrayList<String> streamNames = new ArrayList<String>();
        HashMap<String, Integer> streamNameAndNumber = new HashMap<String, Integer>();
        ArrayList<String> propertyNames = new ArrayList<String>();
        ExprEvaluatorContextTimeOnly validateContext = new ExprEvaluatorContextTimeOnly(timeProvider);
        streamEventTypes.add(sourceEventType);
        streamNames.add(optionalSourceStreamName);
        streamNameAndNumber.put(optionalSourceStreamName, 0);
        propertyNames.add(sourceEventType.getName());
        ArrayList<SelectClauseElementCompiled> cumulativeSelectClause = new ArrayList<SelectClauseElementCompiled>();
        for (int i = 0; i < length; ++i) {
            ExprValidationContext validationContext;
            StreamTypeServiceImpl streamTypeService;
            boolean[] isIStreamOnly;
            String[] whereStreamNames;
            EventType[] whereTypes;
            PropertyEvalAtom atom = spec.getAtoms().get(i);
            String propertyName = atom.getPropertyName();
            FragmentEventType fragmentEventType = currentEventType.getFragmentType(propertyName);
            if (fragmentEventType == null) {
                throw new ExprValidationException("Property expression '" + propertyName + "' against type '" + currentEventType.getName() + "' does not return a fragmentable property value");
            }
            EventPropertyGetter getter = currentEventType.getGetter(propertyName);
            if (getter == null) {
                throw new ExprValidationException("Property expression '" + propertyName + "' against type '" + currentEventType.getName() + "' does not return a fragmentable property value");
            }
            streamEventTypes.add(fragmentEventType.getFragmentType());
            streamNames.add(atom.getOptionalAsName());
            streamNameAndNumber.put(atom.getOptionalAsName(), i + 1);
            propertyNames.add(atom.getPropertyName());
            if (atom.getOptionalWhereClause() != null) {
                whereTypes = streamEventTypes.toArray(new EventType[streamEventTypes.size()]);
                whereStreamNames = streamNames.toArray(new String[streamNames.size()]);
                isIStreamOnly = new boolean[streamNames.size()];
                Arrays.fill(isIStreamOnly, true);
                streamTypeService = new StreamTypeServiceImpl(whereTypes, whereStreamNames, isIStreamOnly, engineURI, false);
                validationContext = new ExprValidationContext(streamTypeService, methodResolutionService, null, timeProvider, variableService, validateContext, eventAdapterService, statementName, statementId, annotations, null);
                whereClauses[i] = ExprNodeUtility.getValidatedSubtree(atom.getOptionalWhereClause(), validationContext).getExprEvaluator();
            }
            if (atom.getOptionalSelectClause() != null) {
                whereTypes = streamEventTypes.toArray(new EventType[streamEventTypes.size()]);
                whereStreamNames = streamNames.toArray(new String[streamNames.size()]);
                isIStreamOnly = new boolean[streamNames.size()];
                Arrays.fill(isIStreamOnly, true);
                streamTypeService = new StreamTypeServiceImpl(whereTypes, whereStreamNames, isIStreamOnly, engineURI, false);
                validationContext = new ExprValidationContext(streamTypeService, methodResolutionService, null, timeProvider, variableService, validateContext, eventAdapterService, statementName, statementId, annotations, null);
                for (SelectClauseElementRaw raw : atom.getOptionalSelectClause().getSelectExprList()) {
                    int streamNumber;
                    SelectClauseStreamCompiledSpec streamSpec;
                    if (raw instanceof SelectClauseStreamRawSpec) {
                        SelectClauseStreamRawSpec rawStreamSpec = (SelectClauseStreamRawSpec)raw;
                        if (!streamNames.contains(rawStreamSpec.getStreamName())) {
                            throw new ExprValidationException("Property rename '" + rawStreamSpec.getStreamName() + "' not found in path");
                        }
                        streamSpec = new SelectClauseStreamCompiledSpec(rawStreamSpec.getStreamName(), rawStreamSpec.getOptionalAsName());
                        streamNumber = (Integer)streamNameAndNumber.get(rawStreamSpec.getStreamName());
                        streamSpec.setStreamNumber(streamNumber);
                        cumulativeSelectClause.add(streamSpec);
                        continue;
                    }
                    if (raw instanceof SelectClauseExprRawSpec) {
                        SelectClauseExprRawSpec exprSpec = (SelectClauseExprRawSpec)raw;
                        ExprNode exprCompiled = ExprNodeUtility.getValidatedSubtree(exprSpec.getSelectExpression(), validationContext);
                        String resultName = exprSpec.getOptionalAsName();
                        if (resultName == null) {
                            resultName = exprCompiled.toExpressionString();
                        }
                        cumulativeSelectClause.add(new SelectClauseExprCompiledSpec(exprCompiled, resultName, exprSpec.getOptionalAsName()));
                        String isMinimal = ExprNodeUtility.isMinimalExpression(exprCompiled);
                        if (isMinimal == null) continue;
                        throw new ExprValidationException("Expression in a property-selection may not utilize " + isMinimal);
                    }
                    if (raw instanceof SelectClauseElementWildcard) {
                        String streamNameAtom = atom.getOptionalAsName();
                        if (streamNameAtom == null) {
                            streamNameAtom = UuidGenerator.generate();
                        }
                        streamSpec = new SelectClauseStreamCompiledSpec(streamNameAtom, atom.getOptionalAsName());
                        streamNumber = i + 1;
                        streamSpec.setStreamNumber(streamNumber);
                        cumulativeSelectClause.add(streamSpec);
                        continue;
                    }
                    throw new IllegalStateException("Unknown select clause item:" + raw);
                }
            }
            currentEventType = fragmentEventType.getFragmentType();
            types[i] = fragmentEventType;
            getters[i] = getter;
        }
        if (cumulativeSelectClause.isEmpty()) {
            if (length == 1) {
                return new PropertyEvaluatorSimple(getters[0], types[0], whereClauses[0], (String)propertyNames.get(0));
            }
            return new PropertyEvaluatorNested(getters, types, whereClauses, propertyNames);
        }
        PropertyEvaluatorAccumulative accumulative = new PropertyEvaluatorAccumulative(getters, types, whereClauses, propertyNames);
        EventType[] whereTypes = streamEventTypes.toArray(new EventType[streamEventTypes.size()]);
        String[] whereStreamNames = streamNames.toArray(new String[streamNames.size()]);
        boolean[] isIStreamOnly = new boolean[streamNames.size()];
        Arrays.fill(isIStreamOnly, true);
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(whereTypes, whereStreamNames, isIStreamOnly, engineURI, false);
        SelectExprProcessor selectExpr = SelectExprProcessorFactory.getProcessor(assignedTypeNumberStack, cumulativeSelectClause, false, null, null, streamTypeService, eventAdapterService, null, null, null, methodResolutionService, validateContext, variableService, timeProvider, engineURI, statementId, statementName, annotations, null);
        return new PropertyEvaluatorSelect(selectExpr, accumulative);
    }
}

