/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.property.PropertyEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyEvaluatorSimple
implements PropertyEvaluator {
    private static final Log log = LogFactory.getLog(PropertyEvaluatorSimple.class);
    private final EventPropertyGetter getter;
    private final FragmentEventType fragmentEventType;
    private final ExprEvaluator filter;
    private final String propertyName;

    public PropertyEvaluatorSimple(EventPropertyGetter getter, FragmentEventType fragmentEventType, ExprEvaluator filter, String propertyName) {
        this.fragmentEventType = fragmentEventType;
        this.getter = getter;
        this.filter = filter;
        this.propertyName = propertyName;
    }

    @Override
    public EventBean[] getProperty(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.getter.getFragment(event);
            EventBean[] rows = this.fragmentEventType.isIndexed() ? (EventBean[])result : new EventBean[]{(EventBean)result};
            if (this.filter == null) {
                return rows;
            }
            return ExprNodeUtility.applyFilterExpression(this.filter, event, (EventBean[])result, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            log.error((Object)("Unexpected error evaluating property expression for event of type '" + event.getEventType().getName() + "' and property '" + this.propertyName + "': " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public EventType getFragmentEventType() {
        return this.fragmentEventType.getFragmentType();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ExprEvaluator getFilter() {
        return this.filter;
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        if (!(otherEval instanceof PropertyEvaluatorSimple)) {
            return false;
        }
        PropertyEvaluatorSimple other = (PropertyEvaluatorSimple)otherEval;
        if (!other.getPropertyName().equals(this.getPropertyName())) {
            return false;
        }
        return other.getFilter() == null && this.getFilter() == null;
    }
}

