/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.epl.expression.ExprAndNodeImpl;
import com.espertech.esper.epl.expression.ExprEqualsNodeImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

public class OuterJoinDesc
implements MetaDefItem,
Serializable {
    private OuterJoinType outerJoinType;
    private ExprIdentNode leftNode;
    private ExprIdentNode rightNode;
    private ExprIdentNode[] addLeftNode;
    private ExprIdentNode[] addRightNode;
    private static final long serialVersionUID = -2616847070429124382L;

    public OuterJoinDesc(OuterJoinType outerJoinType, ExprIdentNode leftNode, ExprIdentNode rightNode, ExprIdentNode[] addLeftNode, ExprIdentNode[] addRightNode) {
        this.outerJoinType = outerJoinType;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.addLeftNode = addLeftNode;
        this.addRightNode = addRightNode;
    }

    public OuterJoinType getOuterJoinType() {
        return this.outerJoinType;
    }

    public ExprIdentNode getLeftNode() {
        return this.leftNode;
    }

    public ExprIdentNode getRightNode() {
        return this.rightNode;
    }

    public ExprIdentNode[] getAdditionalLeftNodes() {
        return this.addLeftNode;
    }

    public ExprIdentNode[] getAdditionalRightNodes() {
        return this.addRightNode;
    }

    public ExprNode makeExprNode(ExprEvaluatorContext exprEvaluatorContext) {
        ExprNodeBase representativeNode = new ExprEqualsNodeImpl(false, false);
        representativeNode.addChildNode(this.leftNode);
        representativeNode.addChildNode(this.rightNode);
        if (this.addLeftNode == null) {
            this.topValidate(representativeNode, exprEvaluatorContext);
            return representativeNode;
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        this.topValidate(representativeNode, exprEvaluatorContext);
        andNode.addChildNode(representativeNode);
        representativeNode = andNode;
        for (int i = 0; i < this.addLeftNode.length; ++i) {
            ExprEqualsNodeImpl eqNode = new ExprEqualsNodeImpl(false, false);
            eqNode.addChildNode(this.addLeftNode[i]);
            eqNode.addChildNode(this.addRightNode[i]);
            this.topValidate(eqNode, exprEvaluatorContext);
            andNode.addChildNode(eqNode);
        }
        this.topValidate(andNode, exprEvaluatorContext);
        return representativeNode;
    }

    public static boolean consistsOfAllInnerJoins(List<OuterJoinDesc> outerJoinDescList) {
        for (OuterJoinDesc desc : outerJoinDescList) {
            if (desc.getOuterJoinType() == OuterJoinType.INNER) continue;
            return false;
        }
        return true;
    }

    private void topValidate(ExprNode exprNode, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            ExprValidationContext validationContext = new ExprValidationContext(null, null, null, null, null, exprEvaluatorContext, null, null, null, null, null);
            exprNode.validate(validationContext);
        }
        catch (ExprValidationException e) {
            throw new IllegalStateException("Failed to make representative node for outer join criteria");
        }
    }
}

