/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec.util;

import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtil;
import java.util.ArrayList;
import java.util.List;

public class StatementSpecCompiledAnalyzer {
    public static StatementSpecCompiledAnalyzerResult analyzeFilters(StatementSpecCompiled spec) {
        ArrayList<FilterSpecCompiled> filters = new ArrayList<FilterSpecCompiled>();
        ArrayList<NamedWindowConsumerStreamSpec> namedWindows = new ArrayList<NamedWindowConsumerStreamSpec>();
        StatementSpecCompiledAnalyzer.addFilters(spec.getStreamSpecs(), filters, namedWindows);
        for (ExprSubselectNode subselect : spec.getSubSelectExpressions()) {
            StatementSpecCompiledAnalyzer.addFilters(subselect.getStatementSpecCompiled().getStreamSpecs(), filters, namedWindows);
        }
        return new StatementSpecCompiledAnalyzerResult(filters, namedWindows);
    }

    private static void addFilters(List<StreamSpecCompiled> streams, List<FilterSpecCompiled> filters, List<NamedWindowConsumerStreamSpec> namedWindows) {
        for (StreamSpecCompiled compiled : streams) {
            if (compiled instanceof FilterStreamSpecCompiled) {
                FilterStreamSpecCompiled c = (FilterStreamSpecCompiled)compiled;
                filters.add(c.getFilterSpec());
            }
            if (compiled instanceof PatternStreamSpecCompiled) {
                PatternStreamSpecCompiled r = (PatternStreamSpecCompiled)compiled;
                EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(r.getEvalFactoryNode());
                List<EvalFilterFactoryNode> filterNodes = evalNodeAnalysisResult.getFilterNodes();
                for (EvalFilterFactoryNode filterNode : filterNodes) {
                    filters.add(filterNode.getFilterSpec());
                }
            }
            if (!(compiled instanceof NamedWindowConsumerStreamSpec)) continue;
            namedWindows.add((NamedWindowConsumerStreamSpec)compiled);
        }
    }
}

