/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.view.ViewSupport;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateVariableView
extends ViewSupport
implements VariableChangeCallback {
    private static final Log log = LogFactory.getLog(CreateVariableView.class);
    private final EventAdapterService eventAdapterService;
    private final VariableReader reader;
    private final EventType eventType;
    private final String variableName;
    private final StatementResultService statementResultService;

    public CreateVariableView(String statementId, EventAdapterService eventAdapterService, VariableService variableService, String variableName, StatementResultService statementResultService) {
        this.eventAdapterService = eventAdapterService;
        this.variableName = variableName;
        this.statementResultService = statementResultService;
        this.reader = variableService.getReader(variableName);
        HashMap<String, Object> variableTypes = new HashMap<String, Object>();
        variableTypes.put(variableName, this.reader.getType());
        String outputEventTypeName = statementId + "_outcreatevar";
        this.eventType = eventAdapterService.createAnonymousMapType(outputEventTypeName, variableTypes);
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic()) {
            HashMap<String, Object> valuesOld = new HashMap<String, Object>();
            valuesOld.put(this.variableName, oldValue);
            EventBean eventOld = this.eventAdapterService.adapterForTypedMap(valuesOld, this.eventType);
            HashMap<String, Object> valuesNew = new HashMap<String, Object>();
            valuesNew.put(this.variableName, newValue);
            EventBean eventNew = this.eventAdapterService.adapterForTypedMap(valuesNew, this.eventType);
            this.updateChildren(new EventBean[]{eventNew}, new EventBean[]{eventOld});
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        throw new UnsupportedOperationException("Update not supported");
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        Object value = this.reader.getValue();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(this.variableName, value);
        EventBean event = this.eventAdapterService.adapterForTypedMap(values, this.eventType);
        return new SingleEventIterator(event);
    }
}

