/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.VariableValueException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.StatementExtensionSvcContext;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableStateHandler;
import com.espertech.esper.epl.variable.VariableTypeException;
import com.espertech.esper.epl.variable.VariableVersionThreadEntry;
import com.espertech.esper.epl.variable.VariableVersionThreadLocal;
import com.espertech.esper.epl.variable.VersionedValueList;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableServiceImpl
implements VariableService {
    private static Log log = LogFactory.getLog(VariableServiceImpl.class);
    protected static final int ROLLOVER_READER_BOUNDARY = 2147383647;
    protected static final int ROLLOVER_WRITER_BOUNDARY = 2147393647;
    protected static final int HIGH_WATERMARK_VERSIONS = 50;
    private final Map<String, VariableReader> variables;
    private final ArrayList<VersionedValueList<Object>> variableVersions;
    private final ArrayList<Set<VariableChangeCallback>> changeCallbacks;
    private final ReadWriteLock readWriteLock;
    private final VariableVersionThreadLocal versionThreadLocal = new VariableVersionThreadLocal();
    private final long millisecondLifetimeOldVersions;
    private final TimeProvider timeProvider;
    private final EventAdapterService eventAdapterService;
    private final VariableStateHandler optionalStateHandler;
    private volatile int currentVersionNumber;
    private int currentVariableNumber;

    public VariableServiceImpl(long millisecondLifetimeOldVersions, TimeProvider timeProvider, EventAdapterService eventAdapterService, VariableStateHandler optionalStateHandler) {
        this(0, millisecondLifetimeOldVersions, timeProvider, eventAdapterService, optionalStateHandler);
    }

    protected VariableServiceImpl(int startVersion, long millisecondLifetimeOldVersions, TimeProvider timeProvider, EventAdapterService eventAdapterService, VariableStateHandler optionalStateHandler) {
        this.millisecondLifetimeOldVersions = millisecondLifetimeOldVersions;
        this.timeProvider = timeProvider;
        this.eventAdapterService = eventAdapterService;
        this.optionalStateHandler = optionalStateHandler;
        this.variables = new HashMap<String, VariableReader>();
        this.variableVersions = new ArrayList();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.changeCallbacks = new ArrayList();
        this.currentVersionNumber = startVersion;
    }

    @Override
    public synchronized void removeVariable(String name) {
        VariableReader reader = this.variables.get(name);
        if (reader == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing variable '" + name + "'"));
        }
        this.variables.remove(name);
        int number = reader.getVariableNumber();
        this.variableVersions.set(number, null);
        this.changeCallbacks.set(number, null);
    }

    @Override
    public String getVariableName(int variableNum) {
        VersionedValueList<Object> versionedValue = this.variableVersions.get(variableNum);
        if (versionedValue == null) {
            return null;
        }
        return versionedValue.getName();
    }

    @Override
    public void setLocalVersion() {
        this.versionThreadLocal.getCurrentThread().setVersion(this.currentVersionNumber);
    }

    @Override
    public void registerCallback(int variableNumber, VariableChangeCallback variableChangeCallback) {
        Set<VariableChangeCallback> callbacks = this.changeCallbacks.get(variableNumber);
        if (callbacks == null) {
            callbacks = new CopyOnWriteArraySet<VariableChangeCallback>();
            this.changeCallbacks.set(variableNumber, callbacks);
        }
        callbacks.add(variableChangeCallback);
    }

    @Override
    public void unregisterCallback(int variableNumber, VariableChangeCallback variableChangeCallback) {
        Set<VariableChangeCallback> callbacks = this.changeCallbacks.get(variableNumber);
        if (callbacks != null) {
            callbacks.remove(variableChangeCallback);
        }
    }

    @Override
    public void createNewVariable(String variableName, String variableType, Object value, StatementExtensionSvcContext extensionServicesContext) throws VariableExistsException, VariableTypeException {
        Class type = JavaClassHelper.getClassForSimpleName(variableType);
        EventType eventType = null;
        if (type == null) {
            if (variableType.toLowerCase().equals("object")) {
                type = Object.class;
            }
            if (type == null && (eventType = this.eventAdapterService.getExistsTypeByName(variableType)) != null) {
                type = eventType.getUnderlyingType();
            }
            if (type == null) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableType + "' is not a recognized type");
            }
        }
        if (eventType == null && !JavaClassHelper.isJavaBuiltinDataType(type) && type != Object.class) {
            eventType = this.eventAdapterService.addBeanType(type.getName(), type, false, false, false);
        }
        this.createNewVariable(variableName, type, eventType, value, extensionServicesContext);
    }

    private synchronized void createNewVariable(String variableName, Class type, EventType eventType, Object value, StatementExtensionSvcContext extensionServicesContext) throws VariableExistsException, VariableTypeException {
        int variableNumber;
        Pair<Boolean, Object> priorValue;
        Object coercedValue = value;
        Class variableType = JavaClassHelper.getBoxedType(type);
        if (eventType != null) {
            if (value != null && !JavaClassHelper.isSubclassOrImplementsInterface(value.getClass(), eventType.getUnderlyingType())) {
                throw new VariableTypeException("Variable '" + variableName + "' of declared event type '" + eventType.getName() + "' underlying type '" + eventType.getUnderlyingType().getName() + "' cannot be assigned a value of type '" + value.getClass().getName() + "'");
            }
            coercedValue = this.eventAdapterService.adapterForType(value, eventType);
        } else if (type != Object.class) {
            if (coercedValue != null && coercedValue instanceof String) {
                try {
                    coercedValue = JavaClassHelper.parse(type, (String)coercedValue);
                }
                catch (Exception ex) {
                    throw new VariableTypeException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be initialized by value '" + coercedValue + "': " + ex.toString());
                }
            }
            if (coercedValue != null && variableType != coercedValue.getClass()) {
                if (!JavaClassHelper.isNumeric(variableType) || !(coercedValue instanceof Number)) {
                    throw new VariableTypeException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be initialized by a value of type '" + coercedValue.getClass().getName() + "'");
                }
                if (!JavaClassHelper.canCoerce(coercedValue.getClass(), variableType)) {
                    throw new VariableTypeException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be initialized by a value of type '" + coercedValue.getClass().getName() + "'");
                }
                coercedValue = JavaClassHelper.coerceBoxed((Number)coercedValue, variableType);
            }
        }
        VariableReader reader = this.variables.get(variableName);
        if (reader != null) {
            throw new VariableExistsException("Variable by name '" + variableName + "' has already been created");
        }
        long timestamp = this.timeProvider.getTime();
        if (this.optionalStateHandler != null && (priorValue = this.optionalStateHandler.getHasState(variableName, this.currentVariableNumber, variableType, eventType, extensionServicesContext)).getFirst().booleanValue()) {
            coercedValue = priorValue.getSecond();
        }
        VersionedValueList<Object> valuePerVersion = new VersionedValueList<Object>(variableName, this.currentVersionNumber, coercedValue, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
        int emptySpot = -1;
        int count = 0;
        for (VersionedValueList<Object> entry : this.variableVersions) {
            if (entry == null) {
                emptySpot = count;
                break;
            }
            ++count;
        }
        if (emptySpot != -1) {
            this.variableVersions.set(emptySpot, valuePerVersion);
            this.changeCallbacks.set(emptySpot, null);
            variableNumber = emptySpot;
        } else {
            this.variableVersions.add(valuePerVersion);
            this.changeCallbacks.add(null);
            variableNumber = this.currentVariableNumber++;
        }
        reader = new VariableReader(this.versionThreadLocal, variableType, eventType, variableName, variableNumber, valuePerVersion);
        this.variables.put(variableName, reader);
    }

    @Override
    public VariableReader getReader(String variableName) {
        return this.variables.get(variableName);
    }

    @Override
    public void write(int variableNumber, Object newValue) {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            entry.setUncommitted(new HashMap<Integer, Object>());
        }
        entry.getUncommitted().put(variableNumber, newValue);
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    @Override
    public void commit() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            return;
        }
        int newVersion = this.currentVersionNumber + 1;
        if (this.currentVersionNumber == 2147383647) {
            this.rollOver();
            newVersion = 2;
        }
        long timestamp = this.timeProvider.getTime();
        for (Map.Entry<Integer, Object> uncommittedEntry : entry.getUncommitted().entrySet()) {
            VersionedValueList<Object> versions = this.variableVersions.get(uncommittedEntry.getKey());
            Object oldValue = versions.addValue(newVersion, uncommittedEntry.getValue(), timestamp);
            Set<VariableChangeCallback> callbacks = this.changeCallbacks.get(uncommittedEntry.getKey());
            if (callbacks != null) {
                for (VariableChangeCallback callback : callbacks) {
                    callback.update(uncommittedEntry.getValue(), oldValue);
                }
            }
            if (this.optionalStateHandler == null) continue;
            String name = versions.getName();
            this.optionalStateHandler.setState(name, uncommittedEntry.getKey(), uncommittedEntry.getValue());
        }
        this.currentVersionNumber = newVersion;
        entry.setUncommitted(null);
    }

    @Override
    public void rollback() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        entry.setUncommitted(null);
    }

    private void rollOver() {
        for (Map.Entry<String, VariableReader> entry : this.variables.entrySet()) {
            int variableNum = entry.getValue().getVariableNumber();
            String name = entry.getKey();
            long timestamp = this.timeProvider.getTime();
            VersionedValueList<Object> versionsOld = this.variableVersions.get(variableNum);
            Object currentValue = versionsOld.getCurrentAndPriorValue().getCurrentVersion().getValue();
            VersionedValueList<Object> versionsNew = new VersionedValueList<Object>(name, 1, currentValue, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
            entry.getValue().setVersionsHigh(versionsOld);
            entry.getValue().setVersionsLow(versionsNew);
            this.variableVersions.set(variableNum, versionsNew);
        }
    }

    @Override
    public void checkAndWrite(int variableNumber, Object newValue) throws VariableValueException {
        if (newValue == null) {
            this.write(variableNumber, null);
            return;
        }
        Class<?> valueType = newValue.getClass();
        String variableName = this.variableVersions.get(variableNumber).getName();
        VariableReader variableReader = this.variables.get(variableName);
        if (variableReader.getEventType() != null) {
            if (newValue != null && !JavaClassHelper.isSubclassOrImplementsInterface(newValue.getClass(), variableReader.getEventType().getUnderlyingType())) {
                throw new VariableValueException("Variable '" + variableName + "' of declared event type '" + variableReader.getEventType().getName() + "' underlying type '" + variableReader.getEventType().getUnderlyingType().getName() + "' cannot be assigned a value of type '" + valueType.getName() + "'");
            }
            EventBean eventBean = this.eventAdapterService.adapterForType(newValue, variableReader.getEventType());
            this.write(variableNumber, eventBean);
            return;
        }
        Class variableType = variableReader.getType();
        if (valueType.equals(variableType) || variableType == Object.class) {
            this.write(variableNumber, newValue);
            return;
        }
        if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(valueType)) {
            throw new VariableValueException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be assigned a value of type '" + valueType.getName() + "'");
        }
        if (!JavaClassHelper.canCoerce(valueType, variableType)) {
            throw new VariableValueException("Variable '" + variableName + "' of declared type '" + variableType.getName() + "' cannot be assigned a value of type '" + valueType.getName() + "'");
        }
        Number valueCoerced = JavaClassHelper.coerceBoxed((Number)newValue, variableType);
        this.write(variableNumber, valueCoerced);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        for (Map.Entry<String, VariableReader> entry : this.variables.entrySet()) {
            int variableNum = entry.getValue().getVariableNumber();
            VersionedValueList<Object> list = this.variableVersions.get(variableNum);
            writer.write("Variable '" + entry.getKey() + "' : " + list.toString() + "\n");
        }
        return writer.toString();
    }

    @Override
    public Map<String, VariableReader> getVariables() {
        HashMap<String, VariableReader> variables = new HashMap<String, VariableReader>();
        variables.putAll(this.variables);
        return variables;
    }
}

