/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterExprViewIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ExprEvaluator filter;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final EventBean[] evalEventArr;
    private EventBean nextResult;

    public FilterExprViewIterator(Iterator<EventBean> sourceIterator, ExprEvaluator filter, ExprEvaluatorContext exprEvaluatorContext) {
        this.sourceIterator = sourceIterator;
        this.filter = filter;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.evalEventArr = new EventBean[1];
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            EventBean candidate;
            this.evalEventArr[0] = candidate = this.sourceIterator.next();
            Boolean pass = (Boolean)this.filter.evaluate(this.evalEventArr, true, this.exprEvaluatorContext);
            if (pass == null || !pass.booleanValue()) continue;
            this.nextResult = candidate;
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

