/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.epl.view.OutputConditionCountFactory;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionCount
extends OutputConditionBase
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = false;
    private final OutputConditionCountFactory parent;
    private long eventRate;
    private int newEventsCount;
    private int oldEventsCount;
    private static final Log log = LogFactory.getLog(OutputConditionCount.class);

    public OutputConditionCount(OutputCallback outputCallback, OutputConditionCountFactory parent) {
        super(outputCallback);
        this.parent = parent;
        this.eventRate = parent.getEventRate();
    }

    public int getNewEventsCount() {
        return this.newEventsCount;
    }

    public int getOldEventsCount() {
        return this.oldEventsCount;
    }

    @Override
    public final void updateOutputCondition(int newDataCount, int oldDataCount) {
        Object value;
        if (this.parent.getVariableReader() != null && (value = this.parent.getVariableReader().getValue()) != null) {
            this.eventRate = ((Number)value).longValue();
        }
        this.newEventsCount += newDataCount;
        this.oldEventsCount += oldDataCount;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".updateBatchCondition,   newEventsCount==" + this.newEventsCount + "  oldEventsCount==" + this.oldEventsCount));
        }
        if (this.isSatisfied()) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug((Object)".updateOutputCondition() condition satisfied");
            }
            this.newEventsCount = 0;
            this.oldEventsCount = 0;
            this.outputCallback.continueOutputProcessing(true, false);
        }
    }

    public final String toString() {
        return this.getClass().getName() + " eventRate=" + this.eventRate;
    }

    private boolean isSatisfied() {
        return (long)this.newEventsCount >= this.eventRate || (long)this.oldEventsCount >= this.eventRate;
    }

    @Override
    public void terminated() {
        this.outputCallback.continueOutputProcessing(true, true);
    }
}

