/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.epl.view.OutputConditionCrontabFactory;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionCrontab
extends OutputConditionBase
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final AgentInstanceContext context;
    private final OutputConditionCrontabFactory factory;
    private final ScheduleSlot scheduleSlot;
    private Long currentReferencePoint;
    private boolean isCallbackScheduled;
    private static final Log log = LogFactory.getLog(OutputConditionCrontab.class);

    public OutputConditionCrontab(OutputCallback outputCallback, AgentInstanceContext context, OutputConditionCrontabFactory factory) {
        super(outputCallback);
        this.context = context;
        this.factory = factory;
        this.scheduleSlot = context.getStatementContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount));
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getStatementContext().getSchedulingService().getTime();
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " spec=" + this.factory.getScheduleSpec();
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.context.getStatementContext().getSchedulingService().getTime();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".scheduleCallback Scheduled new callback for  now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " spec=" + this.factory.getScheduleSpec()));
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionCrontab.this.isCallbackScheduled = false;
                OutputConditionCrontab.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionCrontab.this.scheduleCallback();
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(this.context.getEpStatementAgentInstanceHandle(), callback);
        this.context.getStatementContext().getSchedulingService().add(this.factory.getScheduleSpec(), (ScheduleHandle)handle, this.scheduleSlot);
    }

    @Override
    public void terminated() {
        this.outputCallback.continueOutputProcessing(true, true);
    }
}

