/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.ExtensionServicesContext;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.epl.view.OutputConditionExpressionFactory;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.StopCallback;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionExpression
extends OutputConditionBase
implements OutputCondition,
VariableChangeCallback,
StopCallback {
    private static final Log log = LogFactory.getLog(OutputConditionExpression.class);
    private final AgentInstanceContext agentInstanceContext;
    private final OutputConditionExpressionFactory parent;
    private final ScheduleSlot scheduleSlot;
    private boolean isCallbackScheduled;
    private boolean ignoreVariableCallbacks;
    private Map<String, Object> builtinProperties;
    private EventBean[] eventsPerStream;
    private int totalNewEventsCount;
    private int totalOldEventsCount;
    private Long lastOutputTimestamp;
    private EPStatementHandleCallback scheduleHandle;

    public OutputConditionExpression(OutputCallback outputCallback, final AgentInstanceContext agentInstanceContext, OutputConditionExpressionFactory parent) {
        super(outputCallback);
        this.agentInstanceContext = agentInstanceContext;
        this.parent = parent;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.eventsPerStream = new EventBean[1];
        if (parent.getBuiltinPropertiesEventType() != null) {
            this.builtinProperties = new HashMap<String, Object>();
            this.lastOutputTimestamp = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
        if (parent.getVariableNames() != null) {
            for (String variableName : parent.getVariableNames()) {
                final VariableReader reader = agentInstanceContext.getStatementContext().getVariableService().getReader(variableName);
                agentInstanceContext.getStatementContext().getVariableService().registerCallback(reader.getVariableNumber(), this);
                agentInstanceContext.getTerminationCallbacks().add(new StopCallback(){

                    @Override
                    public void stop() {
                        agentInstanceContext.getStatementContext().getVariableService().unregisterCallback(reader.getVariableNumber(), OutputConditionExpression.this);
                    }
                });
            }
        }
    }

    @Override
    public void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.totalNewEventsCount += newEventsCount;
        this.totalOldEventsCount += oldEventsCount;
        boolean isOutput = this.evaluate();
        if (isOutput) {
            this.outputCallback.continueOutputProcessing(true, true);
            this.resetBuiltinProperties();
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (this.ignoreVariableCallbacks) {
            log.debug((Object)".update Ignoring variable callback");
            return;
        }
        this.agentInstanceContext.getStatementContext().getVariableService().setLocalVersion();
        boolean isOutput = this.evaluate();
        if (isOutput && !this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    @Override
    public void stop() {
        if (this.scheduleHandle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.scheduleHandle = null;
        }
    }

    private boolean evaluate() {
        if (this.builtinProperties != null) {
            this.builtinProperties.put("count_insert", this.totalNewEventsCount);
            this.builtinProperties.put("count_remove", this.totalOldEventsCount);
            this.builtinProperties.put("last_output_timestamp", this.lastOutputTimestamp);
            this.eventsPerStream[0] = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(this.builtinProperties, this.parent.getBuiltinPropertiesEventType());
        }
        boolean result = false;
        Boolean output = (Boolean)this.parent.getWhenExpressionNodeEval().evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".scheduleCallback Scheduled new callback for  afterMsec=0 now=" + current));
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionExpression.this.isCallbackScheduled = false;
                OutputConditionExpression.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionExpression.this.resetBuiltinProperties();
            }
        };
        this.scheduleHandle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, (ScheduleHandle)this.scheduleHandle, this.scheduleSlot);
        this.agentInstanceContext.getTerminationCallbacks().add(this);
        if (this.parent.getVariableReadWritePackage() != null) {
            if (this.builtinProperties != null) {
                this.builtinProperties.put("count_insert", this.totalNewEventsCount);
                this.builtinProperties.put("count_remove", this.totalOldEventsCount);
                this.builtinProperties.put("last_output_timestamp", this.lastOutputTimestamp);
                this.eventsPerStream[0] = this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(this.builtinProperties, this.parent.getBuiltinPropertiesEventType());
            }
            this.ignoreVariableCallbacks = true;
            try {
                this.parent.getVariableReadWritePackage().writeVariables(this.agentInstanceContext.getStatementContext().getVariableService(), this.eventsPerStream, null, this.agentInstanceContext);
            }
            finally {
                this.ignoreVariableCallbacks = false;
            }
        }
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.totalNewEventsCount = 0;
            this.totalOldEventsCount = 0;
            this.lastOutputTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
    }
}

