/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprNodeVariableVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionExpression;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.event.EventAdapterService;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class OutputConditionExpressionFactory
implements OutputConditionFactory {
    private final ExprEvaluator whenExpressionNodeEval;
    private final VariableReadWritePackage variableReadWritePackage;
    private final Set<String> variableNames;
    private EventType builtinPropertiesEventType;

    public OutputConditionExpressionFactory(ExprNode whenExpressionNode, List<OnTriggerSetAssignment> assignments, StatementContext statementContext) throws ExprValidationException {
        this.whenExpressionNodeEval = whenExpressionNode.getExprEvaluator();
        ExprNodeVariableVisitor variableVisitor = new ExprNodeVariableVisitor();
        whenExpressionNode.accept(variableVisitor);
        this.variableNames = variableVisitor.getVariableNames();
        boolean containsBuiltinProperties = false;
        if (this.containsBuiltinProperties(whenExpressionNode)) {
            containsBuiltinProperties = true;
        } else if (assignments != null) {
            for (OnTriggerSetAssignment assignment : assignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (containsBuiltinProperties) {
            this.builtinPropertiesEventType = OutputConditionExpressionFactory.getBuiltInEventType(statementContext.getEventAdapterService());
        }
        this.variableReadWritePackage = assignments != null ? new VariableReadWritePackage(assignments, statementContext.getVariableService(), statementContext.getEventAdapterService()) : null;
    }

    @Override
    public OutputCondition make(AgentInstanceContext agentInstanceContext, OutputCallback outputCallback) {
        return new OutputConditionExpression(outputCallback, agentInstanceContext, this);
    }

    public ExprEvaluator getWhenExpressionNodeEval() {
        return this.whenExpressionNodeEval;
    }

    public VariableReadWritePackage getVariableReadWritePackage() {
        return this.variableReadWritePackage;
    }

    public EventType getBuiltinPropertiesEventType() {
        return this.builtinPropertiesEventType;
    }

    public Set<String> getVariableNames() {
        return this.variableNames;
    }

    public static EventType getBuiltInEventType(EventAdapterService eventAdapterService) {
        HashMap<String, Object> outputLimitProperties = new HashMap<String, Object>();
        outputLimitProperties.put("count_insert", Integer.class);
        outputLimitProperties.put("count_remove", Integer.class);
        outputLimitProperties.put("last_output_timestamp", Long.class);
        return eventAdapterService.createAnonymousMapType(OutputConditionExpressionFactory.class.getName(), outputLimitProperties);
    }

    private boolean containsBuiltinProperties(ExprNode expr) {
        ExprNodeIdentifierVisitor propertyVisitor = new ExprNodeIdentifierVisitor(false);
        expr.accept(propertyVisitor);
        return !propertyVisitor.getExprProperties().isEmpty();
    }
}

