/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputConditionCountFactory;
import com.espertech.esper.epl.view.OutputConditionCrontabFactory;
import com.espertech.esper.epl.view.OutputConditionExpressionFactory;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputConditionFirstFactory;
import com.espertech.esper.epl.view.OutputConditionNullFactory;
import com.espertech.esper.epl.view.OutputConditionTermFactory;
import com.espertech.esper.epl.view.OutputConditionTimeFactory;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionFactoryFactory {
    private static final Log log = LogFactory.getLog(OutputConditionFactoryFactory.class);

    public static OutputConditionFactory createCondition(OutputLimitSpec outputLimitSpec, StatementContext statementContext, boolean isGrouped, boolean isWithHavingClause) throws ExprValidationException {
        if (outputLimitSpec == null) {
            return new OutputConditionNullFactory();
        }
        VariableReader reader = null;
        if (outputLimitSpec.getVariableName() != null && (reader = statementContext.getVariableService().getReader(outputLimitSpec.getVariableName())) == null) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            if (isGrouped) {
                return new OutputConditionNullFactory();
            }
            if (!isWithHavingClause) {
                return new OutputConditionFirstFactory(outputLimitSpec, statementContext, isGrouped, isWithHavingClause);
            }
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            return new OutputConditionCrontabFactory(outputLimitSpec.getCrontabAtSchedule(), statementContext);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            return new OutputConditionExpressionFactory(outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), statementContext);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(".createCondition creating OutputConditionCount with event rate " + outputLimitSpec));
            }
            if (reader != null && !JavaClassHelper.isNumericNonFP(reader.getType())) {
                throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be type integer, long or short");
            }
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionCountFactory(rate, reader);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.TERM) {
            return new OutputConditionTermFactory();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(".createCondition creating OutputConditionTime with interval length " + outputLimitSpec.getRate()));
        }
        if (reader != null && !JavaClassHelper.isNumeric(reader.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        return new OutputConditionTimeFactory(outputLimitSpec.getTimePeriodExpr(), statementContext);
    }
}

