/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledCount;
import com.espertech.esper.epl.view.OutputConditionPolledCrontab;
import com.espertech.esper.epl.view.OutputConditionPolledExpression;
import com.espertech.esper.epl.view.OutputConditionPolledTime;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionPolledFactory {
    private static final Log log = LogFactory.getLog(OutputConditionPolledFactory.class);

    public static OutputConditionPolled createCondition(OutputLimitSpec outputLimitSpec, AgentInstanceContext agentInstanceContext) throws ExprValidationException {
        if (outputLimitSpec == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        VariableReader reader = null;
        if (outputLimitSpec.getVariableName() != null && (reader = agentInstanceContext.getStatementContext().getVariableService().getReader(outputLimitSpec.getVariableName())) == null) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            return new OutputConditionPolledCrontab(outputLimitSpec.getCrontabAtSchedule(), agentInstanceContext);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            return new OutputConditionPolledExpression(outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), agentInstanceContext);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(".createCondition creating OutputConditionCount with event rate " + outputLimitSpec));
            }
            if (reader != null && !JavaClassHelper.isNumericNonFP(reader.getType())) {
                throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be type integer, long or short");
            }
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionPolledCount(rate, reader);
        }
        if (reader != null && !JavaClassHelper.isNumeric(reader.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        return new OutputConditionPolledTime(outputLimitSpec.getTimePeriodExpr(), agentInstanceContext);
    }
}

