/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputConditionTime;

public final class OutputConditionTimeFactory
implements OutputConditionFactory {
    private final ExprTimePeriod timePeriod;
    private final long msecIntervalSize;

    public OutputConditionTimeFactory(ExprTimePeriod timePeriod, StatementContext statementContext) {
        this.timePeriod = timePeriod;
        Double numSeconds = (Double)timePeriod.evaluate(null, true, new ExprEvaluatorContextStatement(statementContext));
        if (numSeconds == null) {
            throw new IllegalArgumentException("Output condition by time returned a null value for the interval size");
        }
        if (numSeconds < 0.001 && !timePeriod.hasVariable()) {
            throw new IllegalArgumentException("Output condition by time requires a interval size of at least 1 msec or a variable");
        }
        this.msecIntervalSize = Math.round(1000.0 * numSeconds);
    }

    @Override
    public OutputCondition make(AgentInstanceContext agentInstanceContext, OutputCallback outputCallback) {
        return new OutputConditionTime(outputCallback, agentInstanceContext, this);
    }

    public ExprTimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }
}

