/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OutputProcessViewBaseWAfter
extends OutputProcessViewBase {
    private static final Log log = LogFactory.getLog(OutputProcessViewBaseWAfter.class);
    private final Long afterConditionTime;
    private final Integer afterConditionNumberOfEvents;
    protected boolean isAfterConditionSatisfied;
    private int afterConditionEventsFound;

    protected OutputProcessViewBaseWAfter(ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied) {
        super(resultSetProcessor);
        this.afterConditionTime = afterConditionTime;
        this.afterConditionNumberOfEvents = afterConditionNumberOfEvents;
        this.isAfterConditionSatisfied = afterConditionSatisfied;
    }

    public boolean checkAfterCondition(EventBean[] newEvents, StatementContext statementContext) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newEvents == null ? 0 : newEvents.length, statementContext);
    }

    public boolean checkAfterCondition(Set<MultiKey<EventBean>> newEvents, StatementContext statementContext) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newEvents == null ? 0 : newEvents.size(), statementContext);
    }

    public boolean checkAfterCondition(UniformPair<EventBean[]> newOldEvents, StatementContext statementContext) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newOldEvents == null ? 0 : (newOldEvents.getFirst() == null ? 0 : newOldEvents.getFirst().length), statementContext);
    }

    private boolean checkAfterCondition(int numOutputEvents, StatementContext statementContext) {
        if (this.afterConditionTime != null) {
            long time = statementContext.getTimeProvider().getTime();
            if (time < this.afterConditionTime) {
                return false;
            }
            this.isAfterConditionSatisfied = true;
            return true;
        }
        if (this.afterConditionNumberOfEvents != null) {
            this.afterConditionEventsFound += numOutputEvents;
            if (this.afterConditionEventsFound <= this.afterConditionNumberOfEvents) {
                return false;
            }
            this.isAfterConditionSatisfied = true;
            return true;
        }
        this.isAfterConditionSatisfied = true;
        return true;
    }
}

