/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewConditionDefault;
import com.espertech.esper.epl.view.OutputProcessViewConditionDefaultPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewConditionFirst;
import com.espertech.esper.epl.view.OutputProcessViewConditionFirstPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewConditionSnapshot;
import com.espertech.esper.epl.view.OutputProcessViewConditionSnapshotPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewDirectDistinctOrAfterFactory;
import com.espertech.esper.epl.view.OutputStrategyPostProcess;
import com.espertech.esper.epl.view.OutputStrategyPostProcessFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewConditionFactory
extends OutputProcessViewDirectDistinctOrAfterFactory {
    private static final Log log = LogFactory.getLog(OutputProcessViewConditionFactory.class);
    private final OutputConditionFactory outputConditionFactory;
    private final int streamCount;
    private final ConditionType conditionType;
    private final OutputLimitLimitType outputLimitLimitType;
    private final boolean terminable;

    public OutputProcessViewConditionFactory(StatementContext statementContext, OutputStrategyPostProcessFactory postProcessFactory, boolean distinct, ExprTimePeriod afterTimePeriod, Integer afterConditionNumberOfEvents, EventType resultEventType, OutputConditionFactory outputConditionFactory, int streamCount, ConditionType conditionType, OutputLimitLimitType outputLimitLimitType, boolean terminable) {
        super(statementContext, postProcessFactory, distinct, afterTimePeriod, afterConditionNumberOfEvents, resultEventType);
        this.outputConditionFactory = outputConditionFactory;
        this.streamCount = streamCount;
        this.conditionType = conditionType;
        this.outputLimitLimitType = outputLimitLimitType;
        this.terminable = terminable;
    }

    @Override
    public OutputProcessViewBase makeView(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        OutputStrategyPostProcess postProcess;
        boolean isAfterConditionSatisfied = true;
        Long afterConditionTime = null;
        if (this.afterConditionNumberOfEvents != null) {
            isAfterConditionSatisfied = false;
        } else if (this.afterTimePeriod != null) {
            isAfterConditionSatisfied = false;
            Object result = this.afterTimePeriod.evaluate(null, true, agentInstanceContext);
            if (result == null) {
                log.warn((Object)"The expression in the 'after' clause time period has returned a null value, ignoring after-clause");
                isAfterConditionSatisfied = true;
            } else {
                double sec = ((Number)result).doubleValue();
                long msec = (long)(sec * 1000.0);
                afterConditionTime = agentInstanceContext.getStatementContext().getTimeProvider().getTime() + msec;
            }
        }
        if (this.conditionType == ConditionType.SNAPSHOT) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionSnapshot(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionSnapshotPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.conditionType == ConditionType.POLICY_FIRST) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionFirst(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionFirstPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.postProcessFactory == null) {
            return new OutputProcessViewConditionDefault(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
        }
        postProcess = this.postProcessFactory.make(agentInstanceContext);
        return new OutputProcessViewConditionDefaultPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
    }

    public OutputConditionFactory getOutputConditionFactory() {
        return this.outputConditionFactory;
    }

    public int getStreamCount() {
        return this.streamCount;
    }

    public OutputLimitLimitType getOutputLimitLimitType() {
        return this.outputLimitLimitType;
    }

    public boolean isTerminable() {
        return this.terminable;
    }

    public static enum ConditionType {
        SNAPSHOT,
        POLICY_FIRST,
        POLICY_NONFIRST;

    }
}

