/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputConditionFactoryFactory;
import com.espertech.esper.epl.view.OutputProcessViewConditionFactory;
import com.espertech.esper.epl.view.OutputProcessViewDirectDistinctOrAfterFactory;
import com.espertech.esper.epl.view.OutputProcessViewDirectFactory;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputStrategyPostProcessFactory;

public class OutputProcessViewFactoryFactory {
    public static OutputProcessViewFactory make(StatementSpecCompiled statementSpec, InternalEventRouter internalEventRouter, StatementContext statementContext, EventType resultEventType) throws ExprValidationException {
        OutputProcessViewDirectFactory outputProcessViewFactory;
        boolean isGrouped;
        boolean isRouted = false;
        boolean routeToFront = false;
        if (statementSpec.getInsertIntoDesc() != null) {
            isRouted = true;
            routeToFront = statementContext.getNamedWindowService().isNamedWindow(statementSpec.getInsertIntoDesc().getEventTypeName());
        }
        OutputStrategyPostProcessFactory outputStrategyPostProcessFactory = null;
        if (statementSpec.getInsertIntoDesc() != null || statementSpec.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY) {
            boolean isRouteRStream = false;
            if (statementSpec.getInsertIntoDesc() != null) {
                isRouteRStream = !statementSpec.getInsertIntoDesc().isIStream();
            }
            outputStrategyPostProcessFactory = new OutputStrategyPostProcessFactory(isRouted, isRouteRStream, statementSpec.getSelectStreamSelectorEnum(), internalEventRouter, statementContext.getEpStatementHandle(), routeToFront);
        }
        int streamCount = statementSpec.getStreamSpecs().size();
        OutputLimitSpec outputLimitSpec = statementSpec.getOutputLimitSpec();
        boolean isDistinct = statementSpec.getSelectClauseSpec().isDistinct();
        boolean bl = isGrouped = statementSpec.getGroupByExpressions() != null && !statementSpec.getGroupByExpressions().isEmpty();
        if (outputLimitSpec != null) {
            ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext);
            ExprValidationContext validationContext = new ExprValidationContext(null, statementContext.getMethodResolutionService(), null, statementContext.getTimeProvider(), statementContext.getVariableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor());
            if (outputLimitSpec.getAfterTimePeriodExpr() != null) {
                outputLimitSpec.getAfterTimePeriodExpr().validate(validationContext);
            }
            if (outputLimitSpec.getTimePeriodExpr() != null) {
                outputLimitSpec.getTimePeriodExpr().validate(validationContext);
            }
        }
        if (outputLimitSpec == null) {
            outputProcessViewFactory = !isDistinct ? new OutputProcessViewDirectFactory(statementContext, outputStrategyPostProcessFactory) : new OutputProcessViewDirectDistinctOrAfterFactory(statementContext, outputStrategyPostProcessFactory, isDistinct, null, null, resultEventType);
        } else if (outputLimitSpec.getRateType() == OutputLimitRateType.AFTER) {
            outputProcessViewFactory = new OutputProcessViewDirectDistinctOrAfterFactory(statementContext, outputStrategyPostProcessFactory, isDistinct, outputLimitSpec.getAfterTimePeriodExpr(), outputLimitSpec.getAfterNumberOfEvents(), resultEventType);
        } else {
            try {
                boolean isWithHavingClause = statementSpec.getHavingExprRootNode() != null;
                OutputConditionFactory outputConditionFactory = OutputConditionFactoryFactory.createCondition(outputLimitSpec, statementContext, isGrouped, isWithHavingClause);
                OutputProcessViewConditionFactory.ConditionType conditionType = outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT ? OutputProcessViewConditionFactory.ConditionType.SNAPSHOT : (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST && statementSpec.getGroupByExpressions().isEmpty() && isWithHavingClause ? OutputProcessViewConditionFactory.ConditionType.POLICY_FIRST : OutputProcessViewConditionFactory.ConditionType.POLICY_NONFIRST);
                boolean terminable = outputLimitSpec.getRateType() == OutputLimitRateType.TERM || outputLimitSpec.isAndAfterTerminate();
                outputProcessViewFactory = new OutputProcessViewConditionFactory(statementContext, outputStrategyPostProcessFactory, isDistinct, outputLimitSpec.getAfterTimePeriodExpr(), outputLimitSpec.getAfterNumberOfEvents(), resultEventType, outputConditionFactory, streamCount, conditionType, outputLimitSpec.getDisplayLimit(), terminable);
            }
            catch (RuntimeException ex) {
                throw new ExprValidationException("Error in the output rate limiting clause: " + ex.getMessage(), ex);
            }
        }
        return outputProcessViewFactory;
    }
}

