/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.virtualdw;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.hook.VirtualDataWindowKeyRange;
import com.espertech.esper.client.hook.VirtualDataWindowLookup;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubordTableLookupStrategyVirtualDW
implements SubordTableLookupStrategy {
    private static final Log log = LogFactory.getLog(SubordTableLookupStrategyVirtualDW.class);
    private final String namedWindowName;
    private final VirtualDataWindowLookup externalIndex;
    private final ExternalEvaluator[] evaluators;
    private final boolean nwOnTrigger;
    private final EventBean[] eventsLocal;

    public SubordTableLookupStrategyVirtualDW(String namedWindowName, VirtualDataWindowLookup externalIndex, List<SubordPropHashKey> hashKeys, CoercionDesc hashKeyCoercionTypes, List<SubordPropRangeKey> rangeKeys, CoercionDesc rangeKeyCoercionTypes, boolean nwOnTrigger, int numOuterStreams) {
        this.namedWindowName = namedWindowName;
        this.externalIndex = externalIndex;
        this.evaluators = new ExternalEvaluator[hashKeys.size() + rangeKeys.size()];
        this.nwOnTrigger = nwOnTrigger;
        this.eventsLocal = new EventBean[numOuterStreams + 1];
        int count = 0;
        for (SubordPropHashKey hashKey : hashKeys) {
            ExprEvaluator evaluator = hashKey.getHashKey().getKeyExpr().getExprEvaluator();
            this.evaluators[count] = new ExternalEvaluatorHashRelOp(evaluator, hashKeyCoercionTypes.getCoercionTypes()[count]);
            ++count;
        }
        for (int i = 0; i < rangeKeys.size(); ++i) {
            SubordPropRangeKey rangeKey = rangeKeys.get(i);
            if (rangeKey.getRangeInfo().getType().isRange()) {
                QueryGraphValueEntryRangeIn range = (QueryGraphValueEntryRangeIn)rangeKey.getRangeInfo();
                ExprEvaluator evaluatorStart = range.getExprStart().getExprEvaluator();
                ExprEvaluator evaluatorEnd = range.getExprEnd().getExprEvaluator();
                this.evaluators[count] = new ExternalEvaluatorBtreeRange(evaluatorStart, evaluatorEnd, rangeKeyCoercionTypes.getCoercionTypes()[i]);
            } else {
                QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeKey.getRangeInfo();
                ExprEvaluator evaluator = relOp.getExpression().getExprEvaluator();
                this.evaluators[count] = new ExternalEvaluatorHashRelOp(evaluator, hashKeyCoercionTypes.getCoercionTypes()[i]);
            }
            ++count;
        }
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        EventBean[] events;
        if (this.nwOnTrigger) {
            events = eventsPerStream;
        } else {
            System.arraycopy(eventsPerStream, 0, this.eventsLocal, 1, eventsPerStream.length);
            events = this.eventsLocal;
        }
        Object[] keys = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            keys[i] = this.evaluators[i].evaluate(events, context);
        }
        Set<EventBean> data = null;
        try {
            data = this.externalIndex.lookup(keys, eventsPerStream);
        }
        catch (RuntimeException ex) {
            log.warn((Object)("Exception encountered invoking virtual data window external index for window '" + this.namedWindowName + "': " + ex.getMessage()), (Throwable)ex);
        }
        return data;
    }

    @Override
    public Collection<EventBean> lookup(Object[] keys) {
        Set<EventBean> data = null;
        try {
            data = this.externalIndex.lookup(keys, null);
        }
        catch (RuntimeException ex) {
            log.warn((Object)("Exception encountered invoking virtual data window external index for window '" + this.namedWindowName + "': " + ex.getMessage()), (Throwable)ex);
        }
        return data;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " external index " + this.externalIndex;
    }

    private static class ExternalEvaluatorBtreeRange
    implements ExternalEvaluator {
        private final ExprEvaluator startEval;
        private final ExprEvaluator endEval;
        private final Class coercionType;

        private ExternalEvaluatorBtreeRange(ExprEvaluator startEval, ExprEvaluator endEval, Class coercionType) {
            this.startEval = startEval;
            this.endEval = endEval;
            this.coercionType = coercionType;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            Object start = EventBeanUtility.coerce(this.startEval.evaluate(events, true, context), this.coercionType);
            Object end = EventBeanUtility.coerce(this.endEval.evaluate(events, true, context), this.coercionType);
            return new VirtualDataWindowKeyRange(start, end);
        }
    }

    private static class ExternalEvaluatorHashRelOp
    implements ExternalEvaluator {
        private final ExprEvaluator hashKeysEval;
        private final Class coercionType;

        private ExternalEvaluatorHashRelOp(ExprEvaluator hashKeysEval, Class coercionType) {
            this.hashKeysEval = hashKeysEval;
            this.coercionType = coercionType;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            return EventBeanUtility.coerce(this.hashKeysEval.evaluate(events, true, context), this.coercionType);
        }
    }

    private static interface ExternalEvaluator {
        public Object evaluate(EventBean[] var1, ExprEvaluatorContext var2);
    }
}

