/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventBeanFactory;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.event.BaseConfigurableEventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanFactoryBean;
import com.espertech.esper.event.EventBeanFactoryBeanWrapped;
import com.espertech.esper.event.EventBeanFactoryMap;
import com.espertech.esper.event.EventBeanFactoryXML;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventBeanManufacturerMap;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.EventBeanManufacturerBean;
import com.espertech.esper.event.bean.PropertyHelper;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.reflect.FastClass;
import org.w3c.dom.Node;

public class EventAdapterServiceHelper {
    public static EventBeanFactory getFactoryForType(EventType type, EventAdapterService eventAdapterService) {
        if (type instanceof WrapperEventType) {
            WrapperEventType wrapperType = (WrapperEventType)type;
            if (wrapperType.getUnderlyingEventType() instanceof BeanEventType) {
                // empty if block
            }
            return new EventBeanFactoryBeanWrapped(wrapperType.getUnderlyingEventType(), wrapperType, eventAdapterService);
        }
        if (type instanceof BeanEventType) {
            return new EventBeanFactoryBean(type, eventAdapterService);
        }
        if (type instanceof MapEventType) {
            return new EventBeanFactoryMap(type, eventAdapterService);
        }
        if (type instanceof BaseXMLEventType) {
            return new EventBeanFactoryXML(type, eventAdapterService);
        }
        throw new IllegalArgumentException("Cannot create event bean factory for event type '" + type.getName() + "': " + type.getClass().getName() + " not a recognized type");
    }

    public static Set<WriteablePropertyDescriptor> getWriteableProperties(EventType eventType) {
        if (!(eventType instanceof EventTypeSPI)) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            BeanEventType beanEventType = (BeanEventType)eventType;
            FastClass fastClass = beanEventType.getFastClass();
            return PropertyHelper.getWritableProperties(fastClass.getJavaClass());
        }
        EventTypeSPI typeSPI = (EventTypeSPI)eventType;
        if (!typeSPI.getMetadata().isApplicationConfigured()) {
            return null;
        }
        if (eventType instanceof MapEventType) {
            Map<String, Object> mapdef = ((MapEventType)eventType).getTypes();
            HashSet<WriteablePropertyDescriptor> writables = new HashSet<WriteablePropertyDescriptor>();
            for (Map.Entry<String, Object> types : mapdef.entrySet()) {
                String typeName;
                Class clazz;
                if (types.getValue() instanceof Class) {
                    writables.add(new WriteablePropertyDescriptor(types.getKey(), (Class)types.getValue(), null));
                }
                if (!(types.getValue() instanceof String) || (clazz = JavaClassHelper.getPrimitiveClassForName(typeName = types.getValue().toString())) == null) continue;
                writables.add(new WriteablePropertyDescriptor(types.getKey(), clazz, null));
            }
            return writables;
        }
        return null;
    }

    public static EventBean adapterForType(Object event, EventType eventType, EventAdapterService eventAdapterService) {
        if (event == null) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            return eventAdapterService.adapterForTypedBean(event, (BeanEventType)eventType);
        }
        if (eventType instanceof MapEventType) {
            return eventAdapterService.adapterForTypedMap((Map)event, eventType);
        }
        if (eventType instanceof BaseConfigurableEventType) {
            return eventAdapterService.adapterForTypedDOM((Node)event, eventType);
        }
        return null;
    }

    public static EventBeanManufacturer getManufacturer(EventAdapterService eventAdapterService, EventType eventType, WriteablePropertyDescriptor[] properties, MethodResolutionService methodResolutionService) throws EventBeanManufactureException {
        if (!(eventType instanceof EventTypeSPI)) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            BeanEventType beanEventType = (BeanEventType)eventType;
            return new EventBeanManufacturerBean(beanEventType, eventAdapterService, properties, methodResolutionService);
        }
        EventTypeSPI typeSPI = (EventTypeSPI)eventType;
        if (!typeSPI.getMetadata().isApplicationConfigured()) {
            return null;
        }
        if (eventType instanceof MapEventType) {
            MapEventType mapEventType = (MapEventType)eventType;
            return new EventBeanManufacturerMap(mapEventType, eventAdapterService, properties);
        }
        return null;
    }
}

