/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventSenderURIDesc;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventSenderImpl
implements EventSender {
    private static Log log = LogFactory.getLog(EventSenderImpl.class);
    private final List<EventSenderURIDesc> handlingFactories;
    private final EPRuntimeEventSender epRuntime;
    private final ThreadingService threadingService;

    public EventSenderImpl(List<EventSenderURIDesc> handlingFactories, EPRuntimeEventSender epRuntime, ThreadingService threadingService) {
        this.handlingFactories = handlingFactories;
        this.epRuntime = epRuntime;
        this.threadingService = threadingService;
    }

    @Override
    public void sendEvent(Object event) throws EPException {
        this.sendIn(event, false);
    }

    @Override
    public void route(Object event) throws EPException {
        this.sendIn(event, true);
    }

    private void sendIn(Object event, boolean isRoute) throws EPException {
        for (EventSenderURIDesc entry : this.handlingFactories) {
            EventBean eventBean = null;
            try {
                eventBean = entry.getBeanFactory().create(event, entry.getResolutionURI());
            }
            catch (RuntimeException ex) {
                log.warn((Object)("Unexpected exception thrown by plug-in event bean factory '" + entry.getBeanFactory() + "' processing event " + event), (Throwable)ex);
            }
            if (eventBean == null) continue;
            if (isRoute) {
                this.epRuntime.routeEventBean(eventBean);
            } else if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
                this.threadingService.submitInbound(new InboundUnitSendWrapped(eventBean, this.epRuntime));
            } else {
                this.epRuntime.processWrappedEvent(eventBean);
            }
            return;
        }
    }
}

