/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventTypeUtility {
    public static Map<String, Object> buildType(List<ColumnDesc> columns, EventAdapterService eventAdapterService, Set<String> copyFrom) throws ExprValidationException {
        HashMap<String, Object> typing = new HashMap<String, Object>();
        HashSet<String> columnNames = new HashSet<String>();
        for (ColumnDesc column : columns) {
            boolean added = columnNames.add(column.getName());
            if (!added) {
                throw new ExprValidationException("Duplicate column name '" + column.getName() + "'");
            }
            Class<?> plain = JavaClassHelper.getClassForSimpleName(column.getType());
            if (plain != null) {
                if (column.isArray()) {
                    plain = Array.newInstance(plain, 0).getClass();
                }
                typing.put(column.getName(), plain);
                continue;
            }
            if (column.isArray()) {
                typing.put(column.getName(), column.getType() + "[]");
                continue;
            }
            typing.put(column.getName(), column.getType());
        }
        if (copyFrom != null && !copyFrom.isEmpty()) {
            for (String copyFromName : copyFrom) {
                EventType type = eventAdapterService.getExistsTypeByName(copyFromName);
                if (type == null) {
                    throw new ExprValidationException("Type by name '" + copyFromName + "' could not be located");
                }
                EventTypeUtility.mergeType(typing, type);
            }
        }
        return typing;
    }

    private static void mergeType(Map<String, Object> typing, EventType typeToMerge) throws ExprValidationException {
        for (EventPropertyDescriptor prop : typeToMerge.getPropertyDescriptors()) {
            Object existing = typing.get(prop.getPropertyName());
            if (!prop.isFragment()) {
                Class assigned = prop.getPropertyType();
                if (existing != null && existing instanceof Class && JavaClassHelper.getBoxedType((Class)existing) != JavaClassHelper.getBoxedType(assigned)) {
                    throw new ExprValidationException("Type by name '" + typeToMerge.getName() + "' contributes property '" + prop.getPropertyName() + "' defined as '" + JavaClassHelper.getClassNameFullyQualPretty(assigned) + "' which overides the same property of type '" + JavaClassHelper.getClassNameFullyQualPretty((Class)existing) + "'");
                }
                typing.put(prop.getPropertyName(), prop.getPropertyType());
                continue;
            }
            if (existing != null) {
                throw new ExprValidationException("Property by name '" + prop.getPropertyName() + "' is defined twice by adding type '" + typeToMerge.getName() + "'");
            }
            FragmentEventType fragment = typeToMerge.getFragmentType(prop.getPropertyName());
            if (fragment == null) continue;
            if (fragment.isIndexed()) {
                typing.put(prop.getPropertyName(), new EventType[]{fragment.getFragmentType()});
                continue;
            }
            typing.put(prop.getPropertyName(), fragment.getFragmentType());
        }
    }

    public static void validateTimestampProperties(EventType eventType, String startTimestampProperty, String endTimestampProperty) throws ConfigurationException {
        Class type;
        if (startTimestampProperty != null) {
            if (eventType.getGetter(startTimestampProperty) == null) {
                throw new ConfigurationException("Declared start timestamp property name '" + startTimestampProperty + "' was not found");
            }
            type = eventType.getPropertyType(startTimestampProperty);
            if (!JavaClassHelper.isDatetimeClass(type)) {
                throw new ConfigurationException("Declared start timestamp property '" + startTimestampProperty + "' is expected to return a Date, Calendar or long-typed value but returns '" + type.getName() + "'");
            }
        }
        if (endTimestampProperty != null) {
            if (startTimestampProperty == null) {
                throw new ConfigurationException("Declared end timestamp property requires that a start timestamp property is also declared");
            }
            if (eventType.getGetter(endTimestampProperty) == null) {
                throw new ConfigurationException("Declared end timestamp property name '" + endTimestampProperty + "' was not found");
            }
            type = eventType.getPropertyType(endTimestampProperty);
            if (!JavaClassHelper.isDatetimeClass(type)) {
                throw new ConfigurationException("Declared end timestamp property '" + endTimestampProperty + "' is expected to return a Date, Calendar or long-typed value but returns '" + type.getName() + "'");
            }
            Class startType = eventType.getPropertyType(startTimestampProperty);
            if (JavaClassHelper.getBoxedType(startType) != JavaClassHelper.getBoxedType(type)) {
                throw new ConfigurationException("Declared end timestamp property '" + endTimestampProperty + "' is expected to have the same property type as the start-timestamp property '" + startTimestampProperty + "'");
            }
        }
    }

    public static boolean isTypeOrSubTypeOf(EventType candidate, EventType superType) {
        if (candidate == superType) {
            return true;
        }
        if (candidate.getSuperTypes() != null) {
            Iterator<EventType> it = candidate.getDeepSuperTypes();
            while (it.hasNext()) {
                if (it.next() != superType) continue;
                return true;
            }
        }
        return false;
    }
}

