/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;

public class ArrayFastPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final FastMethod fastMethod;
    private final int index;

    public ArrayFastPropertyGetter(FastMethod fastMethod, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, fastMethod.getReturnType().getComponentType(), null);
        this.index = index;
        this.fastMethod = fastMethod;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.index);
    }

    private Object getBeanPropInternal(Object object, int index) throws PropertyAccessException {
        try {
            Object value = this.fastMethod.invoke(object, null);
            if (Array.getLength(value) <= index) {
                return null;
            }
            return Array.get(value, index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        return this.getBeanProp(obj.getUnderlying());
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    public String toString() {
        return "ArrayFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

