/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventPropertyWriter;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanEventPropertyWriter
implements EventPropertyWriter {
    private static final Log log = LogFactory.getLog(BeanEventPropertyWriter.class);
    private final Class clazz;
    private final FastMethod writerMethod;

    public BeanEventPropertyWriter(Class clazz, FastMethod writerMethod) {
        this.clazz = clazz;
        this.writerMethod = writerMethod;
    }

    @Override
    public void write(Object value, EventBean target) {
        try {
            this.writerMethod.invoke(target.getUnderlying(), new Object[]{value});
        }
        catch (InvocationTargetException e) {
            String message = "Unexpected exception encountered invoking setter-method '" + this.writerMethod.getJavaMethod() + "' on class '" + this.clazz.getName() + "' : " + e.getTargetException().getMessage();
            log.error((Object)message, (Throwable)e);
        }
    }
}

