/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.sf.cglib.reflect.FastMethod;

public class IterableFastPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final FastMethod fastMethod;
    private final int index;

    public IterableFastPropertyGetter(Method method, FastMethod fastMethod, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, JavaClassHelper.getGenericReturnType(method, false), null);
        this.index = index;
        this.fastMethod = fastMethod;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object value = this.fastMethod.invoke(object, null);
            return IterableFastPropertyGetter.getIterable(value, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return IterableFastPropertyGetter.getIterable(eventBean.getUnderlying(), index);
    }

    protected static Object getIterable(Object value, int index) {
        if (!(value instanceof Iterable)) {
            return null;
        }
        Iterator it = ((Iterable)value).iterator();
        if (index == 0) {
            if (it.hasNext()) {
                return it.next();
            }
            return null;
        }
        int count = 0;
        while (it.hasNext()) {
            if (count >= index) {
                return it.next();
            }
            it.next();
            ++count;
        }
        return null;
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ListFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

