/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.EventPropertyGetterAndMapped;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;

public class KeyedFastPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndMapped,
EventPropertyGetterAndIndexed {
    private final FastMethod fastMethod;
    private final Object key;

    public KeyedFastPropertyGetter(FastMethod fastMethod, Object key, EventAdapterService eventAdapterService) {
        super(eventAdapterService, fastMethod.getReturnType(), null);
        this.key = key;
        this.fastMethod = fastMethod;
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        return this.getBeanProp(obj.getUnderlying());
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.key);
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), mapKey);
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    public Object getBeanPropInternal(Object object, Object key) throws PropertyAccessException {
        try {
            return this.fastMethod.invoke(object, new Object[]{key});
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    public String toString() {
        return "KeyedFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " key=" + this.key;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

