/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndIndexed;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.util.List;

public class ListFieldPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter,
EventPropertyGetterAndIndexed {
    private final Field field;
    private final int index;

    public ListFieldPropertyGetter(Field field, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, JavaClassHelper.getGenericFieldType(field, false), null);
        this.index = index;
        this.field = field;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        return this.getBeanPropInternal(eventBean.getUnderlying(), index);
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        return this.getBeanPropInternal(object, this.index);
    }

    private Object getBeanPropInternal(Object object, int index) throws PropertyAccessException {
        try {
            Object value = this.field.get(object);
            if (!(value instanceof List)) {
                return null;
            }
            List valueList = (List)value;
            if (valueList.size() <= index) {
                return null;
            }
            return valueList.get(index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ListFieldPropertyGetter  field=" + this.field.toString() + " index=" + this.index;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

