/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionPropMethodGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Method method;

    public ReflectionPropMethodGetter(Method method, EventAdapterService eventAdapterService) {
        super(eventAdapterService, method.getReturnType(), JavaClassHelper.getGenericReturnType(method, false));
        this.method = method;
    }

    @Override
    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            return this.method.invoke(object, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    @Override
    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ReflectionPropMethodGetter method=" + this.method.toGenericString();
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

