/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetterAndIndexed;
import java.lang.reflect.Array;
import java.util.Map;

public class MapArrayMaptypedUndPropertyGetter
implements MapEventPropertyGetter,
MapEventPropertyGetterAndIndexed {
    private final String propertyName;
    private final int index;
    private final EventAdapterService eventAdapterService;
    private final EventType fragmentType;

    public MapArrayMaptypedUndPropertyGetter(String propertyNameAtomic, int index, EventAdapterService eventAdapterService, EventType fragmentType) {
        this.propertyName = propertyNameAtomic;
        this.index = index;
        this.fragmentType = fragmentType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return this.getMapInternal(map, this.index);
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMapInternal(map, index);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    private Object getMapInternal(Map<String, Object> map, int index) throws PropertyAccessException {
        Object value = map.get(this.propertyName);
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (Array.getLength(value) <= index) {
            return null;
        }
        return Array.get(value, index);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) throws PropertyAccessException {
        Map value = (Map)this.get(obj);
        if (value == null) {
            return null;
        }
        return this.eventAdapterService.adapterForTypedMap(value, this.fragmentType);
    }
}

