/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.lang.reflect.Array;
import java.util.Map;

public class MapEventBeanArrayPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final Class underlyingType;

    public MapEventBeanArrayPropertyGetter(String propertyName, Class underlyingType) {
        this.propertyName = propertyName;
        this.underlyingType = underlyingType;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object mapValue = map.get(this.propertyName);
        EventBean[] wrapper = (EventBean[])mapValue;
        if (wrapper != null) {
            Object array = Array.newInstance(this.underlyingType, wrapper.length);
            for (int i = 0; i < wrapper.length; ++i) {
                Array.set(array, i, wrapper[i].getUnderlying());
            }
            return array;
        }
        return null;
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        if (!(obj.getUnderlying() instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)obj.getUnderlying();
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) {
        if (!(obj.getUnderlying() instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)obj.getUnderlying();
        return map.get(this.propertyName);
    }
}

