/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.lang.reflect.Array;
import java.util.Map;

public class MapIndexedPropertyGetter
implements MapEventPropertyGetter {
    private final int index;
    private final String fieldName;

    public MapIndexedPropertyGetter(String fieldName, int index) {
        this.index = index;
        this.fieldName = fieldName;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.fieldName);
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (this.index >= Array.getLength(value)) {
            return null;
        }
        return Array.get(value, this.index);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        Object value = map.get(this.fieldName);
        if (value == null) {
            return false;
        }
        if (!value.getClass().isArray()) {
            return false;
        }
        return this.index < Array.getLength(value);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            return null;
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object underlying = eventBean.getUnderlying();
        if (!(underlying instanceof Map)) {
            return false;
        }
        Map map = (Map)underlying;
        return this.isMapExistsProperty(map);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }
}

