/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapMaptypedArrayPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final EventType fragmentEventType;
    private final EventAdapterService eventAdapterService;

    public MapMaptypedArrayPropertyGetter(String propertyNameAtomic, EventType fragmentEventType, EventAdapterService eventAdapterService) {
        this.propertyName = propertyNameAtomic;
        this.fragmentEventType = fragmentEventType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return map.get(this.propertyName);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        Object value = this.get(eventBean);
        if (!(value instanceof Map[])) {
            return null;
        }
        Map[] mapTypedSubEvents = (Map[])value;
        int countNull = 0;
        for (Map map : mapTypedSubEvents) {
            if (map == null) continue;
            ++countNull;
        }
        EventBean[] mapEvents = new EventBean[countNull];
        int count = 0;
        for (Map map : mapTypedSubEvents) {
            if (map == null) continue;
            mapEvents[count++] = this.eventAdapterService.adapterForTypedMap(map, this.fragmentEventType);
        }
        return mapEvents;
    }
}

