/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapMaptypedUndPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyName;
    private final EventAdapterService eventAdapterService;
    private final EventType fragmentType;

    public MapMaptypedUndPropertyGetter(String propertyNameAtomic, EventAdapterService eventAdapterService, EventType fragmentType) {
        this.propertyName = propertyNameAtomic;
        this.fragmentType = fragmentType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return map.get(this.propertyName);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return map.get(this.propertyName);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) throws PropertyAccessException {
        Map value = (Map)this.get(obj);
        if (value == null) {
            return null;
        }
        return this.eventAdapterService.adapterForTypedMap(value, this.fragmentType);
    }
}

