/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

public class MapPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyMap;
    private final EventPropertyGetter getter;

    public MapPropertyGetter(String propertyMap, EventPropertyGetter getter) {
        if (getter == null) {
            throw new IllegalArgumentException("Getter is a required parameter");
        }
        this.propertyMap = propertyMap;
        this.getter = getter;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object valueTopObj = map.get(this.propertyMap);
        if (!(valueTopObj instanceof Map)) {
            return null;
        }
        Map valueTop = (Map)valueTopObj;
        MapEventBean event = new MapEventBean(valueTop, null);
        return this.getter.get(event);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        Object valueTopObj = map.get(this.propertyMap);
        if (!(valueTopObj instanceof Map)) {
            return false;
        }
        Map valueTop = (Map)valueTopObj;
        MapEventBean event = new MapEventBean(valueTop, null);
        return this.getter.isExistsProperty(event);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object result = eventBean.getUnderlying();
        if (!(result instanceof Map)) {
            return null;
        }
        Map map = (Map)result;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object result = eventBean.getUnderlying();
        if (!(result instanceof Map)) {
            return false;
        }
        Map map = (Map)result;
        return this.isMapExistsProperty(map);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }
}

