/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterAndMapped;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.InternalEventPropDescriptor;
import com.espertech.esper.event.bean.KeyedFastPropertyGetter;
import com.espertech.esper.event.bean.KeyedMapFastPropertyGetter;
import com.espertech.esper.event.bean.KeyedMapFieldPropertyGetter;
import com.espertech.esper.event.bean.KeyedMapMethodPropertyGetter;
import com.espertech.esper.event.bean.KeyedMethodPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetterAndMapped;
import com.espertech.esper.event.map.MapMappedPropertyGetter;
import com.espertech.esper.event.property.GenericPropertyDesc;
import com.espertech.esper.event.property.PropertyBase;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.DOMMapGetter;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class MappedProperty
extends PropertyBase {
    private String key;

    public MappedProperty(String propertyName) {
        super(propertyName);
    }

    public MappedProperty(String propertyName, String key) {
        super(propertyName);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public EventPropertyGetterAndMapped getGetter(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor propertyDesc = eventType.getMappedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            Method method = propertyDesc.getReadMethod();
            FastClass fastClass = eventType.getFastClass();
            if (fastClass != null) {
                FastMethod fastMethod = fastClass.getMethod(method);
                return new KeyedFastPropertyGetter(fastMethod, this.key, eventAdapterService);
            }
            return new KeyedMethodPropertyGetter(method, this.key, eventAdapterService);
        }
        propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        Class returnType = propertyDesc.getReturnType();
        if (!JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
            return null;
        }
        if (propertyDesc.getReadMethod() != null) {
            FastClass fastClass = eventType.getFastClass();
            Method method = propertyDesc.getReadMethod();
            if (fastClass != null) {
                FastMethod fastMethod = fastClass.getMethod(method);
                return new KeyedMapFastPropertyGetter(method, fastMethod, this.key, eventAdapterService);
            }
            return new KeyedMapMethodPropertyGetter(method, this.key, eventAdapterService);
        }
        Field field = propertyDesc.getAccessorField();
        return new KeyedMapFieldPropertyGetter(field, this.key, eventAdapterService);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor propertyDesc = eventType.getMappedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            return propertyDesc.getReadMethod().getReturnType();
        }
        InternalEventPropDescriptor descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (!JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
            return null;
        }
        if (descriptor.getReadMethod() != null) {
            return JavaClassHelper.getGenericReturnTypeMap(descriptor.getReadMethod(), false);
        }
        if (descriptor.getAccessorField() != null) {
            return JavaClassHelper.getGenericFieldTypeMap(descriptor.getAccessorField(), false);
        }
        return null;
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor propertyDesc = eventType.getMappedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            return new GenericPropertyDesc(propertyDesc.getReadMethod().getReturnType());
        }
        InternalEventPropDescriptor descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (!JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
            return null;
        }
        if (descriptor.getReadMethod() != null) {
            Class genericType = JavaClassHelper.getGenericReturnTypeMap(descriptor.getReadMethod(), false);
            return new GenericPropertyDesc(genericType);
        }
        if (descriptor.getAccessorField() != null) {
            Class genericType = JavaClassHelper.getGenericFieldTypeMap(descriptor.getAccessorField(), false);
            return new GenericPropertyDesc(genericType);
        }
        return null;
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        Object type = optionalMapPropTypes.get(this.getPropertyNameAtomic());
        if (type == null) {
            return null;
        }
        if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
            return Object.class;
        }
        return null;
    }

    @Override
    public MapEventPropertyGetterAndMapped getGetterMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        Object type = optionalMapPropTypes.get(this.getPropertyNameAtomic());
        if (type == null) {
            return null;
        }
        if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
            return new MapMappedPropertyGetter(this.getPropertyNameAtomic(), this.getKey());
        }
        if (type instanceof Map) {
            return new MapMappedPropertyGetter(this.getPropertyNameAtomic(), this.getKey());
        }
        return null;
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
        writer.append("('");
        writer.append(this.key);
        writer.append("')");
    }

    @Override
    public EventPropertyGetter getGetterDOM(SchemaElementComplex complexProperty, EventAdapterService eventAdapterService, BaseXMLEventType eventType, String propertyExpression) {
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.getName().equals(this.propertyNameAtomic)) continue;
            for (SchemaItemAttribute attribute : complex.getAttributes()) {
                if (attribute.getName().toLowerCase().equals("id")) continue;
            }
            return new DOMMapGetter(this.propertyNameAtomic, this.key, null);
        }
        return null;
    }

    @Override
    public EventPropertyGetter getGetterDOM() {
        return new DOMMapGetter(this.propertyNameAtomic, this.key, null);
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty, EventAdapterService eventAdapterService) {
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.getName().equals(this.propertyNameAtomic)) continue;
            for (SchemaItemAttribute attribute : complex.getAttributes()) {
                if (attribute.getName().toLowerCase().equals("id")) continue;
            }
            return complex;
        }
        return null;
    }
}

