/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.EventRenderer;
import com.espertech.esper.client.util.JSONEventRenderer;
import com.espertech.esper.client.util.JSONRenderingOptions;
import com.espertech.esper.client.util.XMLEventRenderer;
import com.espertech.esper.client.util.XMLRenderingOptions;
import com.espertech.esper.event.util.JSONRendererImpl;
import com.espertech.esper.event.util.XMLRendererImpl;

public class EventRendererImpl
implements EventRenderer {
    @Override
    public JSONEventRenderer getJSONRenderer(EventType eventType, JSONRenderingOptions options) {
        return new JSONRendererImpl(eventType, options);
    }

    @Override
    public JSONEventRenderer getJSONRenderer(EventType eventType) {
        return new JSONRendererImpl(eventType, new JSONRenderingOptions());
    }

    @Override
    public String renderJSON(String title, EventBean event) {
        return this.renderJSON(title, event, new JSONRenderingOptions());
    }

    @Override
    public String renderJSON(String title, EventBean event, JSONRenderingOptions options) {
        if (event == null) {
            return null;
        }
        return this.getJSONRenderer(event.getEventType(), options).render(title, event);
    }

    @Override
    public XMLEventRenderer getXMLRenderer(EventType eventType) {
        return new XMLRendererImpl(eventType, new XMLRenderingOptions());
    }

    @Override
    public XMLEventRenderer getXMLRenderer(EventType eventType, XMLRenderingOptions options) {
        return new XMLRendererImpl(eventType, options);
    }

    @Override
    public String renderXML(String rootElementName, EventBean event) {
        return this.renderXML(rootElementName, event, new XMLRenderingOptions());
    }

    @Override
    public String renderXML(String rootElementName, EventBean event, XMLRenderingOptions options) {
        if (event == null) {
            return null;
        }
        return this.getXMLRenderer(event.getEventType(), options).render(rootElementName, event);
    }
}

