/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.JSONEventRenderer;
import com.espertech.esper.client.util.JSONRenderingOptions;
import com.espertech.esper.event.util.EventTypePropertyPair;
import com.espertech.esper.event.util.GetterPair;
import com.espertech.esper.event.util.NestedGetterPair;
import com.espertech.esper.event.util.OutputValueRenderer;
import com.espertech.esper.event.util.OutputValueRendererFactory;
import com.espertech.esper.event.util.RendererMeta;
import com.espertech.esper.event.util.RendererMetaOptions;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSONRendererImpl
implements JSONEventRenderer {
    private static final Log log = LogFactory.getLog(JSONRendererImpl.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String COMMA_DELIMITER_NEWLINE = "," + NEWLINE;
    private final RendererMeta meta;
    private final RendererMetaOptions rendererOptions;

    public JSONRendererImpl(EventType eventType, JSONRenderingOptions options) {
        this.rendererOptions = new RendererMetaOptions(options.isPreventLooping(), false);
        this.meta = new RendererMeta(eventType, new Stack<EventTypePropertyPair>(), this.rendererOptions);
    }

    @Override
    public String render(String title, EventBean event) {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        buf.append(NEWLINE);
        JSONRendererImpl.ident(buf, 1);
        buf.append('\"');
        buf.append(title);
        buf.append("\": {");
        buf.append(NEWLINE);
        JSONRendererImpl.recursiveRender(event, buf, 2, this.meta, this.rendererOptions);
        JSONRendererImpl.ident(buf, 1);
        buf.append('}');
        buf.append(NEWLINE);
        buf.append('}');
        buf.append(NEWLINE);
        return buf.toString();
    }

    private static void ident(StringBuilder buf, int level) {
        for (int i = 0; i < level; ++i) {
            JSONRendererImpl.indentChar(buf);
        }
    }

    private static void indentChar(StringBuilder buf) {
        buf.append(' ');
        buf.append(' ');
    }

    private static void recursiveRender(EventBean event, StringBuilder buf, int level, RendererMeta meta, RendererMetaOptions rendererOptions) {
        NestedGetterPair[] nestedProps;
        GetterPair[] mappedProps;
        GetterPair[] indexProps;
        GetterPair[] simpleProps;
        String delimiter = "";
        for (GetterPair simpleProp : simpleProps = meta.getSimpleProperties()) {
            Object value = simpleProp.getGetter().get(event);
            buf.append(delimiter);
            JSONRendererImpl.ident(buf, level);
            buf.append('\"');
            buf.append(simpleProp.getName());
            buf.append("\": ");
            simpleProp.getOutput().render(value, buf);
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        for (GetterPair indexProp : indexProps = meta.getIndexProperties()) {
            Object value = indexProp.getGetter().get(event);
            buf.append(delimiter);
            JSONRendererImpl.ident(buf, level);
            buf.append('\"');
            buf.append(indexProp.getName());
            buf.append("\": ");
            if (value == null) {
                buf.append("null");
            } else if (!value.getClass().isArray()) {
                buf.append("[]");
            } else {
                buf.append('[');
                String arrayDelimiter = "";
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object arrayItem = Array.get(value, i);
                    buf.append(arrayDelimiter);
                    indexProp.getOutput().render(arrayItem, buf);
                    arrayDelimiter = ", ";
                }
                buf.append(']');
            }
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        for (GetterPair mappedProp : mappedProps = meta.getMappedProperties()) {
            Object value = mappedProp.getGetter().get(event);
            if (value != null && !(value instanceof Map)) {
                log.warn((Object)("Property '" + mappedProp.getName() + "' expected to return Map and returned " + value.getClass() + " instead"));
                continue;
            }
            buf.append(delimiter);
            JSONRendererImpl.ident(buf, level);
            buf.append('\"');
            buf.append(mappedProp.getName());
            buf.append("\": ");
            if (value == null) {
                buf.append("null");
                buf.append(NEWLINE);
            } else {
                Map map = (Map)value;
                if (map.isEmpty()) {
                    buf.append("{}");
                    buf.append(NEWLINE);
                } else {
                    buf.append('{');
                    buf.append(NEWLINE);
                    String localDelimiter = "";
                    for (Map.Entry entry : map.entrySet()) {
                        if (entry.getKey() == null) continue;
                        buf.append(localDelimiter);
                        JSONRendererImpl.ident(buf, level + 1);
                        buf.append('\"');
                        buf.append(entry.getKey().toString());
                        buf.append("\": ");
                        if (entry.getValue() == null) {
                            buf.append("null");
                        } else {
                            OutputValueRenderer out = OutputValueRendererFactory.getOutputValueRenderer(entry.getValue().getClass(), rendererOptions);
                            out.render(entry.getValue(), buf);
                        }
                        localDelimiter = COMMA_DELIMITER_NEWLINE;
                    }
                    buf.append(NEWLINE);
                    JSONRendererImpl.ident(buf, level);
                    buf.append('}');
                }
            }
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        for (NestedGetterPair nestedProp : nestedProps = meta.getNestedProperties()) {
            Object value = nestedProp.getGetter().getFragment(event);
            buf.append(delimiter);
            JSONRendererImpl.ident(buf, level);
            buf.append('\"');
            buf.append(nestedProp.getName());
            buf.append("\": ");
            if (value == null) {
                buf.append("null");
            } else if (!nestedProp.isArray()) {
                if (!(value instanceof EventBean)) {
                    log.warn((Object)("Property '" + nestedProp.getName() + "' expected to return EventBean and returned " + value.getClass() + " instead"));
                    buf.append("null");
                    continue;
                }
                EventBean nestedEventBean = (EventBean)value;
                buf.append('{');
                buf.append(NEWLINE);
                JSONRendererImpl.recursiveRender(nestedEventBean, buf, level + 1, nestedProp.getMetadata(), rendererOptions);
                JSONRendererImpl.ident(buf, level);
                buf.append('}');
            } else {
                if (!(value instanceof EventBean[])) {
                    log.warn((Object)("Property '" + nestedProp.getName() + "' expected to return EventBean[] and returned " + value.getClass() + " instead"));
                    buf.append("null");
                    continue;
                }
                StringBuilder arrayDelimiterBuf = new StringBuilder();
                arrayDelimiterBuf.append(',');
                arrayDelimiterBuf.append(NEWLINE);
                JSONRendererImpl.ident(arrayDelimiterBuf, level + 1);
                EventBean[] nestedEventArray = (EventBean[])value;
                String arrayDelimiter = "";
                buf.append('[');
                for (int i = 0; i < nestedEventArray.length; ++i) {
                    EventBean arrayItem = nestedEventArray[i];
                    buf.append(arrayDelimiter);
                    arrayDelimiter = arrayDelimiterBuf.toString();
                    buf.append('{');
                    buf.append(NEWLINE);
                    JSONRendererImpl.recursiveRender(arrayItem, buf, level + 2, nestedProp.getMetadata(), rendererOptions);
                    JSONRendererImpl.ident(buf, level + 1);
                    buf.append('}');
                }
                buf.append(']');
            }
            delimiter = COMMA_DELIMITER_NEWLINE;
        }
        buf.append(NEWLINE);
    }
}

