/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.util.XMLEventRenderer;
import com.espertech.esper.client.util.XMLRenderingOptions;
import com.espertech.esper.event.util.EventTypePropertyPair;
import com.espertech.esper.event.util.GetterPair;
import com.espertech.esper.event.util.NestedGetterPair;
import com.espertech.esper.event.util.OutputValueRenderer;
import com.espertech.esper.event.util.OutputValueRendererFactory;
import com.espertech.esper.event.util.RendererMeta;
import com.espertech.esper.event.util.RendererMetaOptions;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLRendererImpl
implements XMLEventRenderer {
    private static final Log log = LogFactory.getLog(XMLRendererImpl.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private final RendererMeta meta;
    private final XMLRenderingOptions options;
    private final RendererMetaOptions rendererMetaOptions;

    public XMLRendererImpl(EventType eventType, XMLRenderingOptions options) {
        this.rendererMetaOptions = new RendererMetaOptions(options.isPreventLooping(), true);
        this.meta = new RendererMeta(eventType, new Stack<EventTypePropertyPair>(), this.rendererMetaOptions);
        this.options = options;
    }

    @Override
    public String render(String rootElementName, EventBean event) {
        if (this.options.isDefaultAsAttribute()) {
            return this.renderAttributeXML(rootElementName, event);
        }
        return this.renderElementXML(rootElementName, event);
    }

    private String renderElementXML(String rootElementName, EventBean event) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append(NEWLINE);
        buf.append('<');
        buf.append(rootElementName);
        buf.append('>');
        buf.append(NEWLINE);
        XMLRendererImpl.recursiveRender(event, buf, 1, this.meta, this.rendererMetaOptions);
        buf.append("</");
        buf.append(this.getFirstWord(rootElementName));
        buf.append('>');
        return buf.toString();
    }

    private String renderAttributeXML(String rootElementName, EventBean event) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buf.append(NEWLINE);
        buf.append('<');
        buf.append(rootElementName);
        this.renderAttributes(event, buf, this.meta);
        String inner = this.renderAttElements(event, 1, this.meta);
        if (inner == null || inner.trim().length() == 0) {
            buf.append("/>");
            buf.append(NEWLINE);
        } else {
            buf.append(">");
            buf.append(NEWLINE);
            buf.append(inner);
            buf.append("</");
            buf.append(this.getFirstWord(rootElementName));
            buf.append('>');
        }
        return buf.toString();
    }

    private String renderAttElements(EventBean event, int level, RendererMeta meta) {
        NestedGetterPair[] nestedProps;
        GetterPair[] mappedProps;
        GetterPair[] indexProps;
        StringBuilder buf = new StringBuilder();
        for (GetterPair indexProp : indexProps = meta.getIndexProperties()) {
            Object value = indexProp.getGetter().get(event);
            if (value == null) continue;
            if (!value.getClass().isArray()) {
                log.warn((Object)("Property '" + indexProp.getName() + "' returned a non-array object"));
                continue;
            }
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object arrayItem = Array.get(value, i);
                if (arrayItem == null) continue;
                XMLRendererImpl.ident(buf, level);
                buf.append('<');
                buf.append(indexProp.getName());
                buf.append('>');
                indexProp.getOutput().render(arrayItem, buf);
                buf.append("</");
                buf.append(indexProp.getName());
                buf.append('>');
                buf.append(NEWLINE);
            }
        }
        for (GetterPair mappedProp : mappedProps = meta.getMappedProperties()) {
            Map map;
            Object value = mappedProp.getGetter().get(event);
            if (value != null && !(value instanceof Map)) {
                log.warn((Object)("Property '" + mappedProp.getName() + "' expected to return Map and returned " + value.getClass() + " instead"));
                continue;
            }
            XMLRendererImpl.ident(buf, level);
            buf.append('<');
            buf.append(mappedProp.getName());
            if (value != null && !(map = (Map)value).isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    buf.append(" ");
                    buf.append(entry.getKey().toString());
                    buf.append("=\"");
                    OutputValueRenderer out = OutputValueRendererFactory.getOutputValueRenderer(entry.getValue().getClass(), this.rendererMetaOptions);
                    out.render(entry.getValue(), buf);
                    buf.append("\"");
                }
            }
            buf.append("/>");
            buf.append(NEWLINE);
        }
        for (NestedGetterPair nestedProp : nestedProps = meta.getNestedProperties()) {
            Object value = nestedProp.getGetter().getFragment(event);
            if (value == null) continue;
            if (!nestedProp.isArray()) {
                if (!(value instanceof EventBean)) {
                    log.warn((Object)("Property '" + nestedProp.getName() + "' expected to return EventBean and returned " + value.getClass() + " instead"));
                    buf.append("null");
                    continue;
                }
                EventBean nestedEventBean = (EventBean)value;
                this.renderAttInner(buf, level, nestedEventBean, nestedProp);
                continue;
            }
            if (!(value instanceof EventBean[])) {
                log.warn((Object)("Property '" + nestedProp.getName() + "' expected to return EventBean[] and returned " + value.getClass() + " instead"));
                buf.append("null");
                continue;
            }
            EventBean[] nestedEventArray = (EventBean[])value;
            for (int i = 0; i < nestedEventArray.length; ++i) {
                EventBean arrayItem = nestedEventArray[i];
                this.renderAttInner(buf, level, arrayItem, nestedProp);
            }
        }
        return buf.toString();
    }

    private void renderAttributes(EventBean event, StringBuilder buf, RendererMeta meta) {
        GetterPair[] simpleProps;
        String delimiter = " ";
        for (GetterPair simpleProp : simpleProps = meta.getSimpleProperties()) {
            Object value = simpleProp.getGetter().get(event);
            if (value == null) continue;
            buf.append(delimiter);
            buf.append(simpleProp.getName());
            buf.append("=\"");
            simpleProp.getOutput().render(value, buf);
            buf.append('\"');
        }
    }

    private static void ident(StringBuilder buf, int level) {
        for (int i = 0; i < level; ++i) {
            XMLRendererImpl.indentChar(buf);
        }
    }

    private static void indentChar(StringBuilder buf) {
        buf.append(' ');
        buf.append(' ');
    }

    private static void recursiveRender(EventBean event, StringBuilder buf, int level, RendererMeta meta, RendererMetaOptions rendererMetaOptions) {
        NestedGetterPair[] nestedProps;
        GetterPair[] mappedProps;
        GetterPair[] indexProps;
        GetterPair[] simpleProps;
        for (GetterPair simpleProp : simpleProps = meta.getSimpleProperties()) {
            Object value = simpleProp.getGetter().get(event);
            if (value == null) continue;
            XMLRendererImpl.ident(buf, level);
            buf.append('<');
            buf.append(simpleProp.getName());
            buf.append('>');
            simpleProp.getOutput().render(value, buf);
            buf.append("</");
            buf.append(simpleProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
        }
        for (GetterPair indexProp : indexProps = meta.getIndexProperties()) {
            Object value = indexProp.getGetter().get(event);
            if (value == null) continue;
            if (!value.getClass().isArray()) {
                log.warn((Object)("Property '" + indexProp.getName() + "' returned a non-array object"));
                continue;
            }
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object arrayItem = Array.get(value, i);
                if (arrayItem == null) continue;
                XMLRendererImpl.ident(buf, level);
                buf.append('<');
                buf.append(indexProp.getName());
                buf.append('>');
                indexProp.getOutput().render(arrayItem, buf);
                buf.append("</");
                buf.append(indexProp.getName());
                buf.append('>');
                buf.append(NEWLINE);
            }
        }
        for (GetterPair mappedProp : mappedProps = meta.getMappedProperties()) {
            Map map;
            Object value = mappedProp.getGetter().get(event);
            if (value != null && !(value instanceof Map)) {
                log.warn((Object)("Property '" + mappedProp.getName() + "' expected to return Map and returned " + value.getClass() + " instead"));
                continue;
            }
            XMLRendererImpl.ident(buf, level);
            buf.append('<');
            buf.append(mappedProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
            if (value != null && !(map = (Map)value).isEmpty()) {
                String localDelimiter = "";
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null) continue;
                    buf.append(localDelimiter);
                    XMLRendererImpl.ident(buf, level + 1);
                    buf.append('<');
                    buf.append(entry.getKey().toString());
                    buf.append('>');
                    if (entry.getValue() != null) {
                        OutputValueRenderer out = OutputValueRendererFactory.getOutputValueRenderer(entry.getValue().getClass(), rendererMetaOptions);
                        out.render(entry.getValue(), buf);
                    }
                    buf.append('<');
                    buf.append(entry.getKey().toString());
                    buf.append('>');
                    localDelimiter = NEWLINE;
                }
            }
            buf.append(NEWLINE);
            XMLRendererImpl.ident(buf, level);
            buf.append("</");
            buf.append(mappedProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
        }
        for (NestedGetterPair nestedProp : nestedProps = meta.getNestedProperties()) {
            Object value = nestedProp.getGetter().getFragment(event);
            if (value == null) continue;
            if (!nestedProp.isArray()) {
                if (!(value instanceof EventBean)) {
                    log.warn((Object)("Property '" + nestedProp.getName() + "' expected to return EventBean and returned " + value.getClass() + " instead"));
                    buf.append("null");
                    continue;
                }
                XMLRendererImpl.renderElementFragment((EventBean)value, buf, level, nestedProp, rendererMetaOptions);
                continue;
            }
            if (!(value instanceof EventBean[])) {
                log.warn((Object)("Property '" + nestedProp.getName() + "' expected to return EventBean[] and returned " + value.getClass() + " instead"));
                buf.append("null");
                continue;
            }
            EventBean[] nestedEventArray = (EventBean[])value;
            for (int i = 0; i < nestedEventArray.length; ++i) {
                EventBean arrayItem = nestedEventArray[i];
                if (arrayItem == null) continue;
                XMLRendererImpl.renderElementFragment(arrayItem, buf, level, nestedProp, rendererMetaOptions);
            }
        }
    }

    private static void renderElementFragment(EventBean eventBean, StringBuilder buf, int level, NestedGetterPair nestedProp, RendererMetaOptions rendererMetaOptions) {
        XMLRendererImpl.ident(buf, level);
        buf.append('<');
        buf.append(nestedProp.getName());
        buf.append('>');
        buf.append(NEWLINE);
        XMLRendererImpl.recursiveRender(eventBean, buf, level + 1, nestedProp.getMetadata(), rendererMetaOptions);
        XMLRendererImpl.ident(buf, level);
        buf.append("</");
        buf.append(nestedProp.getName());
        buf.append('>');
        buf.append(NEWLINE);
    }

    private void renderAttInner(StringBuilder buf, int level, EventBean nestedEventBean, NestedGetterPair nestedProp) {
        XMLRendererImpl.ident(buf, level);
        buf.append('<');
        buf.append(nestedProp.getName());
        this.renderAttributes(nestedEventBean, buf, nestedProp.getMetadata());
        String inner = this.renderAttElements(nestedEventBean, level + 1, nestedProp.getMetadata());
        if (inner == null || inner.trim().length() == 0) {
            buf.append("/>");
            buf.append(NEWLINE);
        } else {
            buf.append(">");
            buf.append(NEWLINE);
            buf.append(inner);
            XMLRendererImpl.ident(buf, level);
            buf.append("</");
            buf.append(nestedProp.getName());
            buf.append('>');
            buf.append(NEWLINE);
        }
    }

    private String getFirstWord(String rootElementName) {
        if (rootElementName == null || rootElementName.trim().length() == 0) {
            return rootElementName;
        }
        int index = rootElementName.indexOf(32);
        if (index < 0) {
            return rootElementName;
        }
        return rootElementName.substring(0, index);
    }
}

