/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.named.NamedWindowIndexRepository;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.vaevent.PropertyUtility;
import com.espertech.esper.event.vaevent.RevisionEventBeanMerge;
import com.espertech.esper.event.vaevent.RevisionEventType;
import com.espertech.esper.event.vaevent.RevisionGetterParameters;
import com.espertech.esper.event.vaevent.RevisionPropertyTypeDesc;
import com.espertech.esper.event.vaevent.RevisionSpec;
import com.espertech.esper.event.vaevent.RevisionStateMerge;
import com.espertech.esper.event.vaevent.RevisionTypeDesc;
import com.espertech.esper.event.vaevent.UpdateStrategy;
import com.espertech.esper.event.vaevent.UpdateStrategyDeclared;
import com.espertech.esper.event.vaevent.UpdateStrategyExists;
import com.espertech.esper.event.vaevent.UpdateStrategyNonNull;
import com.espertech.esper.event.vaevent.VAERevisionProcessorBase;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VAERevisionProcessorMerge
extends VAERevisionProcessorBase
implements ValueAddEventProcessor {
    private static final Log log = LogFactory.getLog(VAERevisionProcessorMerge.class);
    private final RevisionTypeDesc infoFullType;
    private final Map<MultiKeyUntyped, RevisionStateMerge> statePerKey;
    private final UpdateStrategy updateStrategy;

    public VAERevisionProcessorMerge(String revisioneventTypeName, RevisionSpec spec, StatementStopService statementStopService, EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator) {
        super(spec, revisioneventTypeName, eventAdapterService);
        statementStopService.addSubscriber(new StatementStopCallback(){

            @Override
            public void statementStopped() {
                VAERevisionProcessorMerge.this.statePerKey.clear();
            }
        });
        this.statePerKey = new HashMap<MultiKeyUntyped, RevisionStateMerge>();
        HashMap<String, RevisionPropertyTypeDesc> propertyDesc = new HashMap<String, RevisionPropertyTypeDesc>();
        int count = 0;
        for (String property : spec.getChangesetPropertyNames()) {
            EventPropertyGetter fullGetter = spec.getBaseEventType().getGetter(property);
            int propertyNumber = count;
            final RevisionGetterParameters params = new RevisionGetterParameters(property, propertyNumber, fullGetter, null);
            EventPropertyGetter revisionGetter = new EventPropertyGetter(){

                @Override
                public Object get(EventBean eventBean) throws PropertyAccessException {
                    RevisionEventBeanMerge riv = (RevisionEventBeanMerge)eventBean;
                    return riv.getVersionedValue(params);
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean eventBean) {
                    return null;
                }
            };
            Class type = spec.getBaseEventType().getPropertyType(property);
            if (type == null) {
                for (EventType deltaType : spec.getDeltaTypes()) {
                    Class dtype = deltaType.getPropertyType(property);
                    if (dtype == null) continue;
                    type = dtype;
                    break;
                }
            }
            RevisionPropertyTypeDesc propertyTypeDesc = new RevisionPropertyTypeDesc(revisionGetter, params, type);
            propertyDesc.put(property, propertyTypeDesc);
            ++count;
        }
        count = 0;
        for (String property : spec.getKeyPropertyNames()) {
            final int keyPropertyNumber = count;
            EventPropertyGetter revisionGetter = new EventPropertyGetter(){

                @Override
                public Object get(EventBean eventBean) throws PropertyAccessException {
                    RevisionEventBeanMerge riv = (RevisionEventBeanMerge)eventBean;
                    return riv.getKey().getKeys()[keyPropertyNumber];
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean eventBean) {
                    return null;
                }
            };
            Class type = spec.getBaseEventType().getPropertyType(property);
            if (type == null) {
                for (EventType deltaType : spec.getDeltaTypes()) {
                    Class dtype = deltaType.getPropertyType(property);
                    if (dtype == null) continue;
                    type = dtype;
                    break;
                }
            }
            RevisionPropertyTypeDesc propertyTypeDesc = new RevisionPropertyTypeDesc(revisionGetter, null, type);
            propertyDesc.put(property, propertyTypeDesc);
            ++count;
        }
        for (EventType deltaType : spec.getDeltaTypes()) {
            RevisionTypeDesc typeDesc = this.makeTypeDesc(deltaType, spec.getPropertyRevision());
            this.typeDescriptors.put(deltaType, typeDesc);
        }
        this.infoFullType = this.makeTypeDesc(spec.getBaseEventType(), spec.getPropertyRevision());
        if (spec.getPropertyRevision() == ConfigurationRevisionEventType.PropertyRevision.MERGE_DECLARED) {
            this.updateStrategy = new UpdateStrategyDeclared(spec);
        } else if (spec.getPropertyRevision() == ConfigurationRevisionEventType.PropertyRevision.MERGE_NON_NULL) {
            this.updateStrategy = new UpdateStrategyNonNull(spec);
        } else if (spec.getPropertyRevision() == ConfigurationRevisionEventType.PropertyRevision.MERGE_EXISTS) {
            this.updateStrategy = new UpdateStrategyExists(spec);
        } else {
            throw new IllegalArgumentException("Unknown revision type '" + (Object)((Object)spec.getPropertyRevision()) + "'");
        }
        EventTypeMetadata metadata = EventTypeMetadata.createValueAdd(revisioneventTypeName, EventTypeMetadata.TypeClass.REVISION);
        this.revisionEventType = new RevisionEventType(metadata, eventTypeIdGenerator.getTypeId(revisioneventTypeName), propertyDesc, eventAdapterService);
    }

    @Override
    public EventBean getValueAddEventBean(EventBean event) {
        return new RevisionEventBeanMerge(this.revisionEventType, event);
    }

    @Override
    public void onUpdate(EventBean[] newData, EventBean[] oldData, NamedWindowRootViewInstance namedWindowRootView, NamedWindowIndexRepository indexRepository) {
        RevisionTypeDesc typesDesc;
        if (newData == null || newData.length == 0) {
            RevisionEventBeanMerge revisionEvent = (RevisionEventBeanMerge)oldData[0];
            MultiKeyUntyped key = revisionEvent.getKey();
            this.statePerKey.remove(key);
            for (EventTable table : indexRepository.getTables()) {
                table.remove(oldData);
            }
            revisionEvent.setLatest(false);
            namedWindowRootView.updateChildren(null, oldData);
            return;
        }
        RevisionEventBeanMerge revisionEvent = (RevisionEventBeanMerge)newData[0];
        EventBean underlyingEvent = revisionEvent.getUnderlyingFullOrDelta();
        EventType underyingEventType = underlyingEvent.getEventType();
        MultiKeyUntyped key = null;
        boolean isBaseEventType = false;
        if (underyingEventType == this.revisionSpec.getBaseEventType()) {
            typesDesc = this.infoFullType;
            key = PropertyUtility.getKeys(underlyingEvent, this.infoFullType.getKeyPropertyGetters());
            isBaseEventType = true;
        } else {
            typesDesc = (RevisionTypeDesc)this.typeDescriptors.get(underyingEventType);
            if (typesDesc == null) {
                Iterator<EventType> superTypes = underyingEventType.getDeepSuperTypes();
                if (superTypes != null) {
                    while (superTypes.hasNext()) {
                        EventType superType = superTypes.next();
                        if (superType == this.revisionSpec.getBaseEventType()) {
                            typesDesc = this.infoFullType;
                            key = PropertyUtility.getKeys(underlyingEvent, this.infoFullType.getKeyPropertyGetters());
                            isBaseEventType = true;
                        } else {
                            typesDesc = (RevisionTypeDesc)this.typeDescriptors.get(superType);
                            if (typesDesc == null) continue;
                            this.typeDescriptors.put(underyingEventType, typesDesc);
                            key = PropertyUtility.getKeys(underlyingEvent, typesDesc.getKeyPropertyGetters());
                        }
                        break;
                    }
                }
            } else {
                key = PropertyUtility.getKeys(underlyingEvent, typesDesc.getKeyPropertyGetters());
            }
            if (key == null) {
                log.warn((Object)("Ignoring event of event type '" + underyingEventType + "' for revision processing type '" + this.revisionEventTypeName));
                return;
            }
        }
        RevisionStateMerge revisionState = this.statePerKey.get(key);
        if (!isBaseEventType && revisionState == null) {
            return;
        }
        if (revisionState == null) {
            revisionState = new RevisionStateMerge(underlyingEvent, null, null);
            this.statePerKey.put(key, revisionState);
            revisionEvent.setLastBaseEvent(underlyingEvent);
            revisionEvent.setKey(key);
            revisionEvent.setOverlay(null);
            revisionEvent.setLatest(true);
            for (EventTable table : indexRepository.getTables()) {
                table.add(newData);
            }
            revisionState.setLastEvent(revisionEvent);
            namedWindowRootView.updateChildren(new EventBean[]{revisionEvent}, null);
            return;
        }
        this.updateStrategy.handleUpdate(isBaseEventType, revisionState, revisionEvent, typesDesc);
        revisionEvent.setLastBaseEvent(revisionState.getBaseEventUnderlying());
        revisionEvent.setOverlay(revisionState.getOverlays());
        revisionEvent.setKey(key);
        revisionEvent.setLatest(true);
        RevisionEventBeanMerge lastEvent = revisionState.getLastEvent();
        lastEvent.setLatest(false);
        EventBean[] newDataPost = new EventBean[]{revisionEvent};
        EventBean[] oldDataPost = new EventBean[]{lastEvent};
        for (EventTable table : indexRepository.getTables()) {
            table.remove(oldDataPost);
            table.add(newDataPost);
        }
        revisionState.setLastEvent(revisionEvent);
        namedWindowRootView.updateChildren(newDataPost, oldDataPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<EventBean> getSnapshot(EPStatementAgentInstanceHandle createWindowStmtHandle, Viewable parent) {
        createWindowStmtHandle.getStatementAgentInstanceLock().acquireReadLock();
        try {
            Iterator<EventBean> it = parent.iterator();
            if (!it.hasNext()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
            while (it.hasNext()) {
                RevisionEventBeanMerge fullRevision = (RevisionEventBeanMerge)it.next();
                MultiKeyUntyped key = fullRevision.getKey();
                RevisionStateMerge state = this.statePerKey.get(key);
                list.add(state.getLastEvent());
            }
            ArrayDeque<EventBean> arrayDeque = list;
            return arrayDeque;
        }
        finally {
            createWindowStmtHandle.getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    @Override
    public void removeOldData(EventBean[] oldData, NamedWindowIndexRepository indexRepository) {
        for (EventBean anOldData : oldData) {
            RevisionEventBeanMerge event = (RevisionEventBeanMerge)anOldData;
            if (!event.isLatest()) continue;
            MultiKeyUntyped key = event.getKey();
            this.statePerKey.remove(key);
            for (EventTable table : indexRepository.getTables()) {
                table.remove(oldData);
            }
        }
    }

    private RevisionTypeDesc makeTypeDesc(EventType eventType, ConfigurationRevisionEventType.PropertyRevision propertyRevision) {
        EventPropertyGetter[] keyPropertyGetters = PropertyUtility.getGetters(eventType, this.revisionSpec.getKeyPropertyNames());
        int len = this.revisionSpec.getChangesetPropertyNames().length;
        ArrayList<EventPropertyGetter> listOfGetters = new ArrayList<EventPropertyGetter>();
        ArrayList<Integer> listOfIndexes = new ArrayList<Integer>();
        for (int i = 0; i < len; ++i) {
            String propertyName = this.revisionSpec.getChangesetPropertyNames()[i];
            EventPropertyGetter getter = null;
            if (propertyRevision != ConfigurationRevisionEventType.PropertyRevision.MERGE_EXISTS) {
                getter = eventType.getGetter(this.revisionSpec.getChangesetPropertyNames()[i]);
            } else {
                for (String propertyNamesDeclared : eventType.getPropertyNames()) {
                    if (!propertyNamesDeclared.equals(propertyName)) continue;
                    getter = eventType.getGetter(this.revisionSpec.getChangesetPropertyNames()[i] + "?");
                    break;
                }
            }
            if (getter == null) continue;
            listOfGetters.add(getter);
            listOfIndexes.add(i);
        }
        EventPropertyGetter[] changesetPropertyGetters = listOfGetters.toArray(new EventPropertyGetter[listOfGetters.size()]);
        int[] changesetPropertyIndex = new int[listOfIndexes.size()];
        for (int i = 0; i < listOfIndexes.size(); ++i) {
            changesetPropertyIndex[i] = (Integer)listOfIndexes.get(i);
        }
        return new RevisionTypeDesc(keyPropertyGetters, changesetPropertyGetters, changesetPropertyIndex);
    }
}

