/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.event.xml.SchemaElement;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.SchemaUtil;
import com.espertech.esper.event.xml.XPathNamespaceContext;
import com.espertech.esper.event.xml.XPathPropertyGetter;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class SchemaXMLPropertyParser {
    private static Log log = LogFactory.getLog(SchemaXMLPropertyParser.class);

    public static EventPropertyGetter getXPathResolution(String propertyName, XPathFactory xPathFactory, String rootElementName, String namespace, SchemaModel schemaModel, EventAdapterService eventAdapterService, BaseXMLEventType xmlEventType, boolean isAllowFragment, String defaultNamespace) throws EPException {
        XPathExpression expr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Determining XPath expression for property '" + propertyName + "'"));
        }
        XPathNamespaceContext ctx = new XPathNamespaceContext();
        List<String> namespaces = schemaModel.getNamespaces();
        String defaultNamespacePrefix = null;
        for (int i = 0; i < namespaces.size(); ++i) {
            String prefix = "n" + i;
            ctx.addPrefix(prefix, namespaces.get(i));
            if (defaultNamespace == null || !defaultNamespace.equals(namespaces.get(i))) continue;
            defaultNamespacePrefix = prefix;
        }
        Tree ast = PropertyParser.parse(propertyName);
        Property property = PropertyParser.parse(propertyName, false);
        boolean isDynamic = property.isDynamic();
        SchemaElementComplex rootComplexElement = SchemaUtil.findRootElement(schemaModel, namespace, rootElementName);
        String prefix = ctx.getPrefix(rootComplexElement.getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        xPathBuf.append(prefix);
        if (rootElementName.startsWith("//")) {
            xPathBuf.append(rootElementName.substring(2));
        } else {
            xPathBuf.append(rootElementName);
        }
        SchemaElementComplex parentComplexElement = rootComplexElement;
        Pair<String, QName> pair = null;
        if (ast.getChildCount() == 1) {
            pair = SchemaXMLPropertyParser.makeProperty(rootComplexElement, ast.getChild(0), ctx, true, isDynamic, defaultNamespacePrefix);
            if (pair == null) {
                throw new PropertyAccessException("Failed to locate property '" + propertyName + "' in schema");
            }
            xPathBuf.append(pair.getFirst());
        } else {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                boolean isLast = i == ast.getChildCount() - 1;
                Tree child = ast.getChild(i);
                pair = SchemaXMLPropertyParser.makeProperty(parentComplexElement, child, ctx, isLast, isDynamic, defaultNamespacePrefix);
                if (pair == null) {
                    throw new PropertyAccessException("Failed to locate property '" + propertyName + "' nested property part '" + child.toString() + "' in schema");
                }
                String text = child.getChild(0).getText();
                SchemaItem obj = SchemaUtil.findPropertyMapping(parentComplexElement, text);
                if (obj instanceof SchemaElementComplex) {
                    parentComplexElement = (SchemaElementComplex)obj;
                }
                xPathBuf.append(pair.getFirst());
            }
        }
        String xPath = xPathBuf.toString();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".parse XPath for property '" + propertyName + "' is expression=" + xPath));
        }
        XPath path = xPathFactory.newXPath();
        path.setNamespaceContext(ctx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Compiling XPath expression '" + xPath + "' for property '" + propertyName + "' using namespace context :" + ctx));
        }
        try {
            expr = path.compile(xPath);
        }
        catch (XPathExpressionException e) {
            String detail = "Error constructing XPath expression from property expression '" + propertyName + "' expression '" + xPath + "'";
            if (e.getMessage() != null) {
                throw new EPException(detail + " :" + e.getMessage(), e);
            }
            throw new EPException(detail, e);
        }
        SchemaItem item = property.getPropertyTypeSchema(rootComplexElement, eventAdapterService);
        if (item == null && !isDynamic) {
            return null;
        }
        Class resultType = !isDynamic ? SchemaUtil.toReturnType(item) : Node.class;
        FragmentFactoryDOMGetter fragmentFactory = null;
        if (isAllowFragment) {
            fragmentFactory = new FragmentFactoryDOMGetter(eventAdapterService, xmlEventType, propertyName);
        }
        return new XPathPropertyGetter(propertyName, xPath, expr, pair.getSecond(), resultType, fragmentFactory);
    }

    private static Pair<String, QName> makeProperty(SchemaElementComplex parent, Tree child, XPathNamespaceContext ctx, boolean isLast, boolean isDynamic, String defaultNamespacePrefix) {
        String text = child.getChild(0).getText();
        SchemaItem obj = SchemaUtil.findPropertyMapping(parent, text);
        if (obj instanceof SchemaElementSimple || obj instanceof SchemaElementComplex) {
            return SchemaXMLPropertyParser.makeElementProperty((SchemaElement)obj, child, ctx, isLast, isDynamic, defaultNamespacePrefix);
        }
        if (obj != null) {
            return SchemaXMLPropertyParser.makeAttributeProperty((SchemaItemAttribute)obj, child, ctx);
        }
        if (isDynamic) {
            return SchemaXMLPropertyParser.makeElementProperty(null, child, ctx, isLast, isDynamic, defaultNamespacePrefix);
        }
        return null;
    }

    private static Pair<String, QName> makeAttributeProperty(SchemaItemAttribute attribute, Tree child, XPathNamespaceContext ctx) {
        String prefix = ctx.getPrefix(attribute.getNamespace());
        prefix = prefix == null ? "" : prefix + ':';
        switch (child.getType()) {
            case 183: 
            case 186: {
                QName type = SchemaUtil.simpleTypeToQName(attribute.getXsSimpleType());
                String path = "/@" + prefix + child.getChild(0).getText();
                return new Pair<String, QName>(path, type);
            }
            case 184: 
            case 188: {
                throw new RuntimeException("Mapped properties not applicable to attributes");
            }
            case 185: 
            case 187: {
                throw new RuntimeException("Mapped properties not applicable to attributes");
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }

    private static Pair<String, QName> makeElementProperty(SchemaElement schemaElement, Tree child, XPathNamespaceContext ctx, boolean isAlone, boolean isDynamic, String defaultNamespacePrefix) {
        SchemaElementComplex complex;
        QName type = isDynamic ? XPathConstants.NODE : (schemaElement instanceof SchemaElementSimple ? SchemaUtil.simpleTypeToQName(((SchemaElementSimple)schemaElement).getXsSimpleType()) : ((complex = (SchemaElementComplex)schemaElement).getOptionalSimpleType() != null ? SchemaUtil.simpleTypeToQName(complex.getOptionalSimpleType()) : XPathConstants.NODE));
        String prefix = !isDynamic ? ctx.getPrefix(schemaElement.getNamespace()) : defaultNamespacePrefix;
        prefix = prefix == null ? "" : prefix + ':';
        switch (child.getType()) {
            case 183: 
            case 186: {
                if (!isDynamic && schemaElement.isArray() && !isAlone) {
                    throw new PropertyAccessException("Simple property not allowed in repeating elements at '" + schemaElement.getName() + "'");
                }
                return new Pair<String, QName>('/' + prefix + child.getChild(0).getText(), type);
            }
            case 184: 
            case 188: {
                if (!isDynamic && !schemaElement.isArray()) {
                    throw new PropertyAccessException("Element " + child.getChild(0).getText() + " is not a collection, cannot be used as mapped property");
                }
                String key = StringValue.parseString(child.getChild(1).getText());
                return new Pair<String, QName>('/' + prefix + child.getChild(0).getText() + "[@id='" + key + "']", type);
            }
            case 185: 
            case 187: {
                if (!isDynamic && !schemaElement.isArray()) {
                    throw new PropertyAccessException("Element " + child.getChild(0).getText() + " is not a collection, cannot be used as mapped property");
                }
                int index = IntValue.parseString(child.getChild(1).getText());
                int xPathPosition = index + 1;
                return new Pair<String, QName>('/' + prefix + child.getChild(0).getText() + "[position() = " + xPathPosition + ']', type);
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }
}

