/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNodeAdapterBase {
    private static final Log log = LogFactory.getLog(ExprNodeAdapterBase.class);
    protected final ExprNode exprNode;
    protected final ExprEvaluator exprNodeEval;
    protected final ExprEvaluatorContext evaluatorContext;

    public ExprNodeAdapterBase(ExprNode exprNode, ExprEvaluatorContext evaluatorContext) {
        this.exprNode = exprNode;
        this.exprNodeEval = exprNode.getExprEvaluator();
        this.evaluatorContext = evaluatorContext;
    }

    public boolean evaluate(EventBean event) {
        return this.evaluatePerStream(new EventBean[]{event});
    }

    protected boolean evaluatePerStream(EventBean[] eventsPerStream) {
        try {
            Boolean result = (Boolean)this.exprNodeEval.evaluate(eventsPerStream, true, this.evaluatorContext);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error evaluating expression '" + this.exprNode.toExpressionString() + "': " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }
}

