/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.ExprNodeAdapterBase;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexBooleanExpr
extends FilterParamIndexBase {
    private final Map<ExprNodeAdapterBase, EventEvaluator> evaluatorsMap = new HashMap<ExprNodeAdapterBase, EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexBooleanExpr.class);

    public FilterParamIndexBooleanExpr() {
        super(FilterOperator.BOOLEAN_EXPRESSION);
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        ExprNodeAdapterBase keyValues = (ExprNodeAdapterBase)filterConstant;
        return this.evaluatorsMap.get(keyValues);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        ExprNodeAdapterBase keys = (ExprNodeAdapterBase)filterConstant;
        this.evaluatorsMap.put(keys, evaluator);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        ExprNodeAdapterBase keys = (ExprNodeAdapterBase)filterConstant;
        return this.evaluatorsMap.remove(keys) != null;
    }

    @Override
    public final int size() {
        return this.evaluatorsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        ArrayList<EventEvaluator> evaluators = new ArrayList<EventEvaluator>();
        this.constantsMapRWLock.readLock().lock();
        for (ExprNodeAdapterBase exprNodeAdapter : this.evaluatorsMap.keySet()) {
            if (!exprNodeAdapter.evaluate(eventBean)) continue;
            evaluators.add(this.evaluatorsMap.get(exprNodeAdapter));
        }
        this.constantsMapRWLock.readLock().unlock();
        for (EventEvaluator evaluator : evaluators) {
            evaluator.matchEvent(eventBean, matches);
        }
    }
}

