/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterParamIndexCompareString
extends FilterParamIndexPropBase {
    private final TreeMap<Object, EventEvaluator> constantsMap = new TreeMap();
    private final ReadWriteLock constantsMapRWLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(FilterParamIndexCompareString.class);

    public FilterParamIndexCompareString(String propertyName, FilterOperator filterOperator, EventType eventType) {
        super(propertyName, filterOperator, eventType);
        if (filterOperator != FilterOperator.GREATER && filterOperator != FilterOperator.GREATER_OR_EQUAL && filterOperator != FilterOperator.LESS && filterOperator != FilterOperator.LESS_OR_EQUAL) {
            throw new IllegalArgumentException("Invalid filter operator for index of " + (Object)((Object)filterOperator));
        }
        if (this.getPropertyBoxedType() != String.class) {
            throw new IllegalArgumentException("Property named '" + propertyName + "' is not of String type");
        }
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        this.checkType(filterConstant);
        return this.constantsMap.get(filterConstant);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator matcher) {
        this.checkType(filterConstant);
        this.constantsMap.put(filterConstant, matcher);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        return this.constantsMap.remove(filterConstant) != null;
    }

    @Override
    public final int size() {
        return this.constantsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches) {
        EventEvaluator matcher;
        Object propertyValue = this.getGetter().get(eventBean);
        if (propertyValue == null) {
            return;
        }
        FilterOperator filterOperator = this.getFilterOperator();
        this.constantsMapRWLock.readLock().lock();
        SortedMap<Object, EventEvaluator> subMap = filterOperator == FilterOperator.GREATER || filterOperator == FilterOperator.GREATER_OR_EQUAL ? this.constantsMap.headMap(propertyValue) : this.constantsMap.tailMap(propertyValue);
        EventEvaluator exactEquals = null;
        if (filterOperator == FilterOperator.LESS) {
            exactEquals = this.constantsMap.get(propertyValue);
        }
        for (EventEvaluator matcher2 : subMap.values()) {
            if (exactEquals != null) {
                exactEquals = null;
                continue;
            }
            matcher2.matchEvent(eventBean, matches);
        }
        if (filterOperator == FilterOperator.GREATER_OR_EQUAL && (matcher = this.constantsMap.get(propertyValue)) != null) {
            matcher.matchEvent(eventBean, matches);
        }
        this.constantsMapRWLock.readLock().unlock();
    }

    private void checkType(Object filterConstant) {
        if (this.getPropertyBoxedType() != filterConstant.getClass()) {
            throw new IllegalArgumentException("Invalid type of filter constant of " + filterConstant.getClass().getName() + " for property " + this.getPropertyName());
        }
    }
}

